jQuery(document).ready(function($) {
    'use strict';
    
    // Add hover class for better touch devices support
    $('.appointment-item').on('touchstart', function() {
        $(this).addClass('hover');
    }).on('touchend', function() {
        $(this).removeClass('hover');
    });
    
    // Initialize tooltips if needed
    if (typeof $.fn.tooltip === 'function') {
        $('.appointment-item[title]').tooltip();
    }
    
    // Add click animation
    $('.appointment-item').on('mousedown', function() {
        $(this).addClass('active');
    }).on('mouseup mouseleave', function() {
        $(this).removeClass('active');
    });
    
    // Make sure images are loaded before animating
    $('.appointment-image img').on('load', function() {
        $(this).addClass('loaded');
    }).each(function() {
        if (this.complete) {
            $(this).trigger('load');
        }
    });
    
    // Equal height for items in the same row
    function setEqualHeights() {
        $('.appointment-container.elementor-view-grid').each(function() {
            var $container = $(this);
            var $items = $container.find('.appointment-item');
            
            // Reset heights
            $items.css('height', '');
            
            // Get the number of columns from the grid
            var gridComputedStyle = window.getComputedStyle($container[0]);
            var gridColumnCount = gridComputedStyle.gridTemplateColumns.split(' ').length;
            
            // Group items by row
            for (var i = 0; i < $items.length; i += gridColumnCount) {
                var $rowItems = $items.slice(i, i + gridColumnCount);
                var maxHeight = 0;
                
                // Find the tallest item in the row
                $rowItems.each(function() {
                    var itemHeight = $(this).outerHeight();
                    if (itemHeight > maxHeight) {
                        maxHeight = itemHeight;
                    }
                });
                
                // Set all items in the row to the same height
                $rowItems.css('height', maxHeight + 'px');
            }
        });
    }
    
    // Run on load and window resize
    $(window).on('load resize', function() {
        setTimeout(setEqualHeights, 100);
    });
    
    // Re-run after Elementor editor changes
    if (window.elementor) {
        elementor.hooks.addAction('panel/open_editor/widget', function() {
            setTimeout(setEqualHeights, 1000);
        });
    }
});
