jQuery(document).ready(function($) {
    // Initialize Jalali date picker if the element exists
    if ($('.jalali-date-picker').length > 0) {
        $('.jalali-date-picker').each(function() {
            $(this).persianDatepicker({
                format: 'YYYY/MM/DD',
                observer: true,
                autoClose: true,
                initialValue: true,
                calendar: {
                    persian: {
                        locale: 'en',
                        showHint: true,
                        leapYearMode: 'algorithmic'
                    },
                    gregorian: {
                        locale: 'en',
                        showHint: true
                    }
                }
            });
        });
    }

    // Convert Gregorian dates to Jalali in admin
    function convertAdminDatesToJalali() {
        // Add your date conversion logic here
        // This is a placeholder for any date conversion needed in the admin area
    }

    // Run on document ready
    convertAdminDatesToJalali();

    // Run again after AJAX loads
    $(document).ajaxComplete(function() {
        convertAdminDatesToJalali();
    });
});
