<?php get_header(); ?>

<?php if ( ! ( function_exists( 'elementor_theme_do_location' ) && elementor_theme_do_location( 'archive' ) ) ) : ?>

<div class="category-archive">
  <h1 class="category-title"><?php single_cat_title(); ?></h1>
  <div class="category-description">
    <?php echo category_description(); ?>
  </div>
  <div class="posts-list">
    <?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
      <article class="post-card">
        <a href="<?php the_permalink(); ?>" class="post-thumbnail">
          <?php if ( has_post_thumbnail() ) : ?>
            <?php the_post_thumbnail('medium'); ?>
          <?php else: ?>
            <img src="https://via.placeholder.com/300x200?text=No+Image" alt="<?php the_title(); ?>">
          <?php endif; ?>
        </a>
        <div class="post-content">
          <h2 class="post-title">
            <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
          </h2>
          <div class="post-meta">
            <span class="post-date"><?php echo get_the_date(); ?></span>
            <span class="post-author"><?php the_author(); ?></span>
          </div>
          <div class="post-excerpt">
            <?php the_excerpt(); ?>
          </div>
          <a href="<?php the_permalink(); ?>" class="read-more">ادامه مطلب</a>
        </div>
      </article>
    <?php endwhile; else: ?>
      <p>پستی یافت نشد.</p>
    <?php endif; ?>
  </div>
</div>
<?php endif; ?>
<?php get_footer(); ?>