<?php
/**
 * The header for our theme
 */

if (!defined('ABSPATH')) {
    exit;
}

// Check if we're on a single post/page and if header should be hidden
$hide_header = false;
$custom_header_template = '';
// Read body margin-top setting (default 100px)
$body_margin_top = absint(get_option('header_body_margin_top', 100));
// Read body background color from basic settings (default #ffffff)
$__basic_settings_for_body = get_option('basic_settings', array());
$body_bg_color = isset($__basic_settings_for_body['body_bg_color']) ? sanitize_hex_color($__basic_settings_for_body['body_bg_color']) : '#ffffff';
// Compose inline style for body
$__body_style_parts = array();
if ($body_margin_top) { $__body_style_parts[] = 'margin-top: ' . $body_margin_top . 'px'; }
if ($body_bg_color) { $__body_style_parts[] = 'background-color: ' . $body_bg_color; }
$body_style_attr = !empty($__body_style_parts) ? ' style="' . implode('; ', $__body_style_parts) . ';"' : '';

if (is_singular()) {
    $post_id = get_queried_object_id();
    $hide_header = get_post_meta($post_id, '_mohtavanegar_hide_header', true);
    $custom_header_template = get_post_meta($post_id, '_mohtavanegar_custom_header_template', true);
}

// If header is hidden, output minimal header and exit
if ($hide_header) {
    ?><!DOCTYPE html>
    <html <?php language_attributes(); ?>>
    <head>
        <meta charset="<?php bloginfo('charset'); ?>">
        <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
        <link rel="profile" href="https://gmpg.org/xfn/11">
        <?php wp_head(); ?>
    </head>
    <body <?php body_class(); ?><?php echo $body_style_attr; ?>>
    <?php
    // Add opening wrapper
    echo '<div id="page" class="site">';
    echo '<div id="content" class="site-content">';
    return; // Stop further execution of header.php
}

// If we have a custom header template, load it and exit
if (!empty($custom_header_template) && class_exists('\Elementor\Plugin')) {
    ?><!DOCTYPE html>
    <html <?php language_attributes(); ?>>
    <head>
        <meta charset="<?php bloginfo('charset'); ?>">
        <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
        <link rel="profile" href="https://gmpg.org/xfn/11">
        <?php wp_head(); ?>
    </head>
    <body <?php body_class(); ?><?php echo $body_style_attr; ?>>
    <?php
    $elementor = \Elementor\Plugin::instance();
    echo $elementor->frontend->get_builder_content_for_display($custom_header_template);
    // Add opening wrapper
    echo '<div id="page" class="site">';
    echo '<div id="content" class="site-content">';
    return; // Stop further execution of header.php
}

// Get basic settings for default header
$basic_settings = get_option('basic_settings', array());
$page_layout = $basic_settings['page_layout'] ?? 'container';
$container_width = $basic_settings['container_width'] ?? '1140';

// Set site width style
$site_style = '';
if ($page_layout === 'container') {
    $site_style = 'max-width: ' . $container_width . 'px; margin: 0 auto;';
} else {
    $site_style = 'max-width: 100%;';
}
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
    <link rel="profile" href="https://gmpg.org/xfn/11">
    <style>
        /* Critical CSS */
        body { margin: 0; padding: 0; }
        .site { display: flex; flex-direction: column; min-height: 100vh; }
        .site-content { flex: 1; }
        .site-header.type-blurry {
            --blur-current: var(--blur-initial, 0px);
            -webkit-backdrop-filter: blur(var(--blur-current));
            backdrop-filter: blur(var(--blur-current));
            transition: -webkit-backdrop-filter 0.3s ease, backdrop-filter 0.3s ease;
        }
        .site-header.type-blurry.scrolled {
            --blur-current: var(--blur-scrolled, 10px);
        }
        
        /* Loading Screen Styles */
        #loading-screen {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-color: #fff;
            display: flex;
            justify-content: center;
            align-items: center;
            z-index: 9999;
            transition: opacity 0.5s ease-out, visibility 0.5s ease-out;
        }
        
        #loading-screen.hidden {
            opacity: 0;
            visibility: hidden;
        }
        
        .loader {
            border: 5px solid #f3f3f3;
            border-top: 5px solid #3498db;
            border-radius: 50%;
            width: 50px;
            height: 50px;
            animation: spin 1s linear infinite;
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
    </style>
    <?php wp_head(); 
    
    
    if (function_exists('rank_math_the_open_graph_tags')) {
        rank_math_the_open_graph_tags();
    }
    ?>

    
</head>

<body <?php body_class(); ?><?php echo $body_style_attr; ?>>
<?php wp_body_open(); ?>

<!-- Loading Screen -->
<div id="loading-screen">
    <div class="loader"></div>
</div>

<script>
    // Hide loading screen when everything is loaded
    window.addEventListener('load', function() {
        var loadingScreen = document.getElementById('loading-screen');
        if (loadingScreen) {
            loadingScreen.classList.add('hidden');
            
            // Remove from DOM after animation completes
            setTimeout(function() {
                loadingScreen.remove();
            }, 500);
        }
    });
    
    // Fallback in case load event doesn't fire
    setTimeout(function() {
        var loadingScreen = document.getElementById('loading-screen');
        if (loadingScreen) {
            loadingScreen.classList.add('hidden');
            setTimeout(function() {
                loadingScreen.remove();
            }, 500);
        }
    }, 5000); // 5 seconds max wait time
</script>

<div id="page" class="site" style="<?php echo esc_attr($site_style); ?>">
    <a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e('Skip to content', 'mohtavanegar'); ?></a>

    <?php
        $header_type = get_option('header_type', 'default');
        $blur_initial = absint(get_option('header_blur_initial', 0));
        $blur_scrolled = absint(get_option('header_blur_scrolled', 10));
        $header_classes = 'site-header' . (get_option('header_fixed') ? ' fixed-top' : '');
        if ($header_type === 'blurry') {
            $header_classes .= ' type-blurry';
        } else {
            $header_classes .= ' type-' . sanitize_html_class($header_type);
        }
        $header_style = '';
        if ($header_type === 'blurry') {
            $header_style = '--blur-initial: ' . $blur_initial . 'px; --blur-scrolled: ' . $blur_scrolled . 'px;';
        }
    ?>
    <header id="masthead" class="<?php echo esc_attr($header_classes); ?>" style="<?php echo esc_attr($header_style); ?>">
        <?php
        // Get header template
        $header_template = get_option('header_template');
        $header_type = get_option('header_type', 'default');
        
        if ($header_template) {
            echo '<div class="site-header-inner">';
            echo do_shortcode('[elementor-template id="' . $header_template . '"]');
            echo '</div>';
        } else {
            // Default header content
            ?>
            <div class="site-branding">
                <?php
                if (has_custom_logo()) :
                    the_custom_logo();
                else :
                    ?>
                    <h1 class="site-title"><a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a></h1>
                    <?php
                    $description = get_bloginfo('description', 'display');
                    if ($description || is_customize_preview()) :
                        ?>
                        <p class="site-description"><?php echo $description; ?></p>
                    <?php endif; ?>
                <?php endif; ?>
            </div>

            <nav id="site-navigation" class="main-navigation">
                <?php
                wp_nav_menu(array(
                    'theme_location' => 'menu-1',
                    'menu_id'        => 'primary-menu',
                ));
                ?>
            </nav>
            <?php
        }
        ?>
    </header>

    <script>
        (function(){
            var header = document.getElementById('masthead');
            if (!header) return;
            if (!header.classList.contains('type-blurry')) return;
            var toggle = function(){
                if (window.scrollY > 10) {
                    header.classList.add('scrolled');
                } else {
                    header.classList.remove('scrolled');
                }
            };
            toggle();
            window.addEventListener('scroll', toggle, { passive: true });
        })();
    </script>

    <div id="content" class="site-content"> 