jQuery(document).ready(function($) {
    // Load SweetAlert2 CSS if not already loaded
    if (!$('#sweetalert2-css').length) {
        $('head').append('<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css" id="sweetalert2-css">');
    }
    
    // Load SweetAlert2 JS if not already loaded
    if (typeof Swal === 'undefined') {
        $.getScript('https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.all.min.js');
    }
    // Create answer modal if it doesn't exist
    if ($('#qa-answer-modal').length === 0) {
        $('body').append(`
            <div id="qa-answer-modal" class="qa-answer-modal">
                <div class="qa-answer-modal-content">
                    <span class="qa-answer-modal-close">&times;</span>
                    <h2>پاسخ به پرسش</h2>
                    <div id="qa-question-content"></div>
                    <div class="qa-answer-form-group">
                        <label for="qa-answer-text">پاسخ:</label>
                        <textarea id="qa-answer-text" class="qa-answer-textarea"></textarea>
                    </div>
                    <button id="qa-answer-submit" class="qa-answer-submit">ثبت پاسخ</button>
                </div>
            </div>
        `);
    }
    
    // Tab navigation
    $('.nav-tab-wrapper a').on('click', function(e) {
        e.preventDefault();
        
        // Hide all tab contents
        $('.tab-content').hide();
        
        // Remove active class from all tabs
        $('.nav-tab').removeClass('nav-tab-active');
        
        // Show the selected tab content
        $($(this).attr('href')).show();
        
        // Add active class to the clicked tab
        $(this).addClass('nav-tab-active');
    });
    
    // Approve comment
    $('.approve-comment').on('click', function() {
        var commentId = $(this).data('id');
        var row = $('#comment-' + commentId);
        
        Swal.fire({
            title: 'تایید نظر',
            text: 'آیا از تایید این نظر اطمینان دارید؟',
            icon: 'question',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'بله، تایید کن',
            cancelButtonText: 'لغو',
            reverseButtons: true
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: qaAdminData.ajaxUrl,
                    type: 'POST',
                    data: {
                        action: 'approve_qa_comment',
                        comment_id: commentId,
                        nonce: qaAdminData.nonce
                    },
                    success: function(response) {
                        if (response.success) {
                            Swal.fire({
                                title: 'موفق!',
                                text: 'نظر با موفقیت تایید شد.',
                                icon: 'success',
                                timer: 2000,
                                showConfirmButton: false
                            });
                            
                            row.fadeOut(300, function() {
                                $(this).remove();
                                
                                // Check if there are no more pending comments
                                if ($('#pending-comments tbody tr').length === 0) {
                                    $('#pending-comments tbody').html('<tr><td colspan="5">هیچ نظری در انتظار تایید وجود ندارد.</td></tr>');
                                }
                                
                                // Reload the page to update both tabs
                                setTimeout(function() {
                                    location.reload();
                                }, 2000);
                            });
                        } else {
                            Swal.fire({
                                title: 'خطا!',
                                text: response.data,
                                icon: 'error',
                                confirmButtonText: 'باشه'
                            });
                        }
                    },
                    error: function() {
                        Swal.fire({
                            title: 'خطا!',
                            text: 'خطا در ارتباط با سرور. لطفا دوباره تلاش کنید.',
                            icon: 'error',
                            confirmButtonText: 'باشه'
                        });
                    }
                });
            }
        });
    });
    
    // Delete comment
    $('.delete-comment').on('click', function() {
        var commentId = $(this).data('id');
        var row = $('#comment-' + commentId);
        
        Swal.fire({
            title: 'حذف نظر',
            text: 'آیا از حذف این نظر اطمینان دارید؟ این عمل غیرقابل بازگشت است.',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#d33',
            cancelButtonColor: '#3085d6',
            confirmButtonText: 'بله، حذف کن',
            cancelButtonText: 'لغو',
            reverseButtons: true
        }).then((result) => {
            if (result.isConfirmed) {
                $.ajax({
                    url: qaAdminData.ajaxUrl,
                    type: 'POST',
                    data: {
                        action: 'delete_qa_comment',
                        comment_id: commentId,
                        nonce: qaAdminData.nonce
                    },
                    success: function(response) {
                        if (response.success) {
                            Swal.fire({
                                title: 'موفق!',
                                text: 'نظر با موفقیت حذف شد.',
                                icon: 'success',
                                timer: 2000,
                                showConfirmButton: false
                            });
                            
                            row.fadeOut(300, function() {
                                $(this).remove();
                                
                                // Check if there are no more comments in the current tab
                                var currentTab = $('.nav-tab-active').attr('href');
                                if ($(currentTab + ' tbody tr').length === 0) {
                                    if (currentTab === '#pending-comments') {
                                        $(currentTab + ' tbody').html('<tr><td colspan="6">هیچ نظری در انتظار تایید وجود ندارد.</td></tr>');
                                    } else {
                                        $(currentTab + ' tbody').html('<tr><td colspan="7">هیچ نظر تایید شده‌ای وجود ندارد.</td></tr>');
                                    }
                                }
                            });
                        } else {
                            Swal.fire({
                                title: 'خطا!',
                                text: response.data,
                                icon: 'error',
                                confirmButtonText: 'باشه'
                            });
                        }
                    },
                    error: function() {
                        Swal.fire({
                            title: 'خطا!',
                            text: 'خطا در ارتباط با سرور. لطفا دوباره تلاش کنید.',
                            icon: 'error',
                            confirmButtonText: 'باشه'
                        });
                    }
                });
            }
        });
    });

    // Export Q&A data
    $('#export-qa-data').on('click', function() {
        var button = $(this);
        button.prop('disabled', true).text('در حال برون‌ریزی...');
        
        $.ajax({
            url: qaAdminData.ajaxUrl,
            type: 'POST',
            data: {
                action: 'export_qa_data',
                nonce: qaAdminData.nonce
            },
            success: function(response) {
                button.prop('disabled', false).text('برون‌ریزی داده‌ها (JSON)');
                
                if (response.success) {
                    // Create and download JSON file
                    var dataStr = JSON.stringify(response.data, null, 2);
                    var dataBlob = new Blob([dataStr], {type: 'application/json'});
                    var url = URL.createObjectURL(dataBlob);
                    
                    var link = document.createElement('a');
                    link.href = url;
                    link.download = 'qa-data-' + new Date().toISOString().slice(0, 10) + '.json';
                    document.body.appendChild(link);
                    link.click();
                    document.body.removeChild(link);
                    
                    Swal.fire(
                        'موفق!',
                        'داده‌ها با موفقیت برون‌ریزی شدند.',
                        'success'
                    );
                } else {
                    Swal.fire(
                        'خطا!',
                        response.data || 'خطا در برون‌ریزی داده‌ها.',
                        'error'
                    );
                }
            },
            error: function() {
                button.prop('disabled', false).text('برون‌ریزی داده‌ها (JSON)');
                Swal.fire(
                    'خطا!',
                    'خطا در برقراری ارتباط با سرور.',
                    'error'
                );
            }
        });
    });

    // Import Q&A data
    $('#import-qa-data').on('click', function() {
        $('#import-qa-file').click();
    });

    $('#import-qa-file').on('change', function(e) {
        var file = e.target.files[0];
        if (!file) return;
        
        if (file.type !== 'application/json') {
            Swal.fire(
                'خطا!',
                'لطفاً فقط فایل‌های JSON انتخاب کنید.',
                'error'
            );
            return;
        }
        
        var formData = new FormData();
        formData.append('action', 'import_qa_data');
        formData.append('nonce', qaAdminData.importNonce);
        formData.append('import_file', file);
        formData.append('service', $('#import-service-select').val());
        
        Swal.fire({
            title: 'در حال درون‌ریزی...',
            text: 'لطفاً منتظر بمانید...',
            allowOutsideClick: false,
            showConfirmButton: false,
            willOpen: () => {
                Swal.showLoading();
            }
        });
        
        $.ajax({
            url: qaAdminData.ajaxUrl,
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                if (response.success) {
                    Swal.fire(
                        'موفق!',
                        response.data,
                        'success'
                    ).then(() => {
                        location.reload();
                    });
                } else {
                    Swal.fire(
                        'خطا!',
                        response.data || 'خطا در درون‌ریزی داده‌ها.',
                        'error'
                    );
                }
            },
            error: function() {
                Swal.fire(
                    'خطا!',
                    'خطا در برقراری ارتباط با سرور.',
                    'error'
                );
            }
        });
        
        // Reset file input
        $('#import-qa-file').val('');
    });
    
    // Answer comment
    $('.answer-comment').on('click', function() {
        var commentId = $(this).data('id');
        var row = $('#comment-' + commentId);
        var questionText = row.find('td:nth-child(4)').text(); // Get question text
        var currentAnswer = row.find('td:nth-child(5)').html(); // Get current answer if exists
        
        // Set question and answer in modal
        $('#qa-question-content').html('<p><strong>پرسش:</strong> ' + questionText + '</p>');
        $('#qa-answer-text').val(currentAnswer ? currentAnswer.replace(/<br\/?>/g, '\n') : '');
        
        // Store comment ID for submission
        $('#qa-answer-submit').data('id', commentId);
        
        // Show modal
        $('#qa-answer-modal').fadeIn(300);
    });
    
    // Close modal
    $('.qa-answer-modal-close').on('click', function() {
        $('#qa-answer-modal').fadeOut(300);
    });
    
    // Close modal when clicking outside
    $(window).on('click', function(e) {
        if ($(e.target).is('.qa-answer-modal')) {
            $('.qa-answer-modal').fadeOut(300);
        }
    });
    
    // Submit answer
    $('#qa-answer-submit').on('click', function() {
        var commentId = $(this).data('id');
        var answerText = $('#qa-answer-text').val();
        
        $.ajax({
            url: qaAdminData.ajaxUrl,
            type: 'POST',
            data: {
                action: 'save_qa_answer',
                comment_id: commentId,
                answer: answerText,
                nonce: qaAdminData.nonce
            },
            beforeSend: function() {
                $('#qa-answer-submit').prop('disabled', true).text('در حال ذخیره...');
            },
            success: function(response) {
                if (response.success) {
                    // Update answer in table
                    var formattedAnswer = answerText.replace(/\n/g, '<br>');
                    $('#comment-' + commentId + ' td:nth-child(5)').html(formattedAnswer);
                    
                    // Close modal
                    $('#qa-answer-modal').fadeOut(300);
                    
                    // Show success message
                    Swal.fire({
                        title: 'موفق!',
                        text: 'پاسخ با موفقیت ذخیره شد.',
                        icon: 'success',
                        timer: 2000,
                        showConfirmButton: false
                    });
                } else {
                    Swal.fire({
                        title: 'خطا!',
                        text: response.data,
                        icon: 'error',
                        confirmButtonText: 'باشه'
                    });
                }
                
                // Re-enable submit button
                $('#qa-answer-submit').prop('disabled', false).text('ثبت پاسخ');
            },
            error: function() {
                Swal.fire({
                    title: 'خطا!',
                    text: 'خطا در ارتباط با سرور. لطفا دوباره تلاش کنید.',
                    icon: 'error',
                    confirmButtonText: 'باشه'
                });
                $('#qa-answer-submit').prop('disabled', false).text('ثبت پاسخ');
            }
        });
    });
    
    // Save answer in post edit screen
    $('#post input[name="save"]').on('click', function() {
        var answer = $('#qa_answer').val();
        var postId = $('#post_ID').val();
        
        // Store the answer in a hidden field to be saved with the post
        if (!$('#_qa_answer_hidden').length) {
            $('<input>').attr({
                type: 'hidden',
                id: '_qa_answer_hidden',
                name: '_qa_answer',
                value: answer
            }).appendTo('#post');
        } else {
            $('#_qa_answer_hidden').val(answer);
        }
    });
});