jQuery(document).ready(function($) {
    // Handle form submission
    $('#qa-submission-form').on('submit', function(e) {
        e.preventDefault();
        
        // Get form data
        var name = $('#qa-name').val();
        var email = $('#qa-email').val();
        var mobile = $('#qa-mobile').val();
        var question = $('#qa-question').val();
        var service = $('#qa-service').val();
        
        // Validate form data
        if (!name || !question) {
            showMessage('error', 'لطفا نام و پرسش خود را وارد کنید.');
            return;
        }
        
        // Validate email if provided
        if (email && !isValidEmail(email)) {
            showMessage('error', 'لطفا یک ایمیل معتبر وارد کنید.');
            return;
        }
        
        // Validate mobile if provided
        if (mobile && !isValidMobile(mobile)) {
            showMessage('error', 'لطفا یک شماره موبایل معتبر وارد کنید.');
            return;
        }
        
        // Submit form via AJAX
        $.ajax({
            url: qaFrontendData.ajaxUrl,
            type: 'POST',
            data: {
                action: 'submit_qa_comment',
                name: name,
                email: email,
                mobile: mobile,
                question: question,
                service: service,
                nonce: qaFrontendData.nonce
            },
            beforeSend: function() {
                $('.qa-submit-button').prop('disabled', true).text('در حال ارسال...');
            },
            success: function(response) {
                if (response.success) {
                    // Show success message
                    showMessage('success', response.data);
                    
                    // Reset form
                    $('#qa-submission-form')[0].reset();
                    $('#qa-service').val('');
                } else {
                    // Show error message
                    showMessage('error', response.data);
                }
                
                // Re-enable submit button
                $('.qa-submit-button').prop('disabled', false).text('ارسال پرسش');
            },
            error: function() {
                // Show error message
                showMessage('error', 'خطا در ارتباط با سرور. لطفا دوباره تلاش کنید.');
                
                // Re-enable submit button
                $('.qa-submit-button').prop('disabled', false).text('ارسال پرسش');
            }
        });
    });
    
    // Function to show messages
    function showMessage(type, message) {
        var messageElement = $('#qa-form-message');
        
        // Set message content and class
        messageElement.html(message).removeClass('success error').addClass(type);
        
        // Show message
        messageElement.fadeIn(300);
        
        // Hide message after 5 seconds
        setTimeout(function() {
            messageElement.fadeOut(300);
        }, 5000);
    }
    
    // Function to validate email
    function isValidEmail(email) {
        var emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        return emailRegex.test(email);
    }
    
    // Function to validate mobile number (Iranian format)
    function isValidMobile(mobile) {
        var mobileRegex = /^09[0-9]{9}$/;
        return mobileRegex.test(mobile);
    }

    // Bind search for a single container (traditional pagination via links)
    function bindQAPaginationForContainer($container, settings) {
        if (!$container || !$container.length) return;
        var widgetId = $container.data('widget-id');
        if (!widgetId) return;

        // Clear previous handlers for this container
        $container.off('.qaPagination');
        $(document).off('keydown.qaPagination.' + widgetId, '#qa-search-input-' + widgetId);

        // Bind Enter key on search input for this widget (outside container but namespaced by id)
        $(document).on('keydown.qaPagination.' + widgetId, '#qa-search-input-' + widgetId, function(e) {
            if (e.key === 'Enter') {
                e.preventDefault();
                var q = $(this).val() || '';
                var s = $container.data('settings') || settings || {};
                if (!s || typeof s !== 'object') { s = {}; }
                s.search = (q || '').trim();
                try { $container.data('settings', s); } catch (err) {}
                try { $container.attr('data-settings', JSON.stringify(s)); } catch (err2) {}
                // Navigate using traditional query param
                try {
                    var url = new URL(window.location.href);
                    url.searchParams.set('qa_page', '1');
                    if (s.search && s.search.length) {
                        url.searchParams.set('qa_search', s.search);
                    } else {
                        url.searchParams.delete('qa_search');
                    }
                    window.location.href = url.toString();
                } catch (e2) {
                    // Fallback
                    var loc = window.location.href;
                    var hasQuery = loc.indexOf('?') !== -1;
                    // remove existing qa_search if any
                    loc = loc.replace(/([?&])qa_search=[^&#]*(&|#|$)/, function(m, p1, p2){ return p2 === '&' ? p1 : p2; });
                    // set qa_page=1
                    if (loc.match(/[?&]qa_page=/)) {
                        loc = loc.replace(/([?&]qa_page=)(\d+)/, '$11');
                    } else {
                        loc += (hasQuery ? '&' : '?') + 'qa_page=1';
                        hasQuery = true;
                    }
                    if (s.search && s.search.length) {
                        loc += (hasQuery ? '&' : '?') + 'qa_search=' + encodeURIComponent(s.search);
                    }
                    window.location.href = loc;
                }
            }
        });
    }

    // Initialize for all containers
    function initQAPagination() {
        $('.qa-comments-container').each(function() {
            var $container = $(this);
            var widgetId = $container.data('widget-id');
            var settings = $container.data('settings') || {};
            // Fallback JSON parse if needed
            if (!settings || typeof settings !== 'object') {
                try { settings = JSON.parse($container.attr('data-settings') || '{}'); } catch (e) { settings = {}; }
            }
            // Fallback to individual data-* attributes if missing/escaped
            if (!settings || !Object.keys(settings).length) {
                settings = {
                    filter_by_service: $container.data('filter-by-service'),
                    specific_service: $container.data('specific-service'),
                    posts_per_page: parseInt($container.data('posts-per-page')) || 10,
                    enable_pagination: $container.data('enable-pagination'),
                    comments_title: $container.data('comments-title'),
                    search: ''
                };
            }
            // Coerce types for reliability
            settings.posts_per_page = parseInt(settings.posts_per_page) || 10;
            settings.enable_pagination = (settings.enable_pagination === true || settings.enable_pagination === '1' || settings.enable_pagination === 1);

            if (!widgetId || !settings || !settings.enable_pagination) {
                return; // continue .each
            }

            bindQAPaginationForContainer($container, settings);
        });
    }

    // Load QA page via AJAX (kept for backward compatibility but unused now)
    function loadQAPage(page, $container, settings) {
        var container = $container; // keep previous naming for minimal change
        if (!container || !container.length) {
            return;
        }

        // Show loading state
        container.addClass('loading');
        container.html('<div class="qa-loading"><div class="qa-spinner"></div><p>در حال بارگذاری...</p></div>');

        // Scroll to top of container
        $('html, body').animate({
            scrollTop: container.offset().top - 100
        }, 500);

        $.ajax({
            url: qaFrontendData.ajaxUrl,
            type: 'POST',
            data: {
                action: 'mohtavanegar_qa_pagination',
                page: page,
                widget_id: container.data('widget-id'),
                settings: settings,
                nonce: qaFrontendData.nonce
            },
            success: function(response) {
                if (response && response.success) {
                    container.html(response.data.html);

                    // Re-initialize accordion
                    if (typeof initAccordion !== 'undefined') {
                        initAccordion();
                    }

                    // Defensive: normalize pagination links returned from server and rebind only this container
                    var wid = container.data('widget-id');
                    normalizePaginationLinks(container, wid);
                    var latestSettings = container.data('settings') || settings || {};
                    bindQAPaginationForContainer(container, latestSettings);
                } else {
                    container.html('<div class="qa-error">خطا در بارگذاری داده‌ها</div>');
                }
                container.removeClass('loading');
            },
            error: function() {
                container.html('<div class="qa-error">خطا در ارتباط با سرور</div>');
                container.removeClass('loading');
            }
        });
    }

    // Do not modify pagination anchors for traditional navigation
    function normalizePaginationLinks($container, widgetId) {
        return;
    }

    // Initialize pagination on page load
    $(document).ready(function() {
        initQAPagination();
    });
});