(function($){
  function switchTab($wrapper, target){
    $wrapper.find('.nav-tab').removeClass('nav-tab-active');
    $wrapper.find('.tab-content').hide();
    $wrapper.find('a[href="#'+target+'"]').addClass('nav-tab-active');
    $('#'+target).show();
  }

  $(document).ready(function(){
    var $wrap = $('.wrap');
    $wrap.on('click', '.nav-tab-wrapper .nav-tab', function(e){
      e.preventDefault();
      var href = $(this).attr('href').replace('#','');
      switchTab($wrap, href);
    });

    $wrap.on('click', '.approve-review', function(){
      var id = $(this).data('id');
      var $row = $('#review-'+id);
      $.post(reviewsAdminData.ajaxUrl, {
        action: 'approve_patient_review',
        nonce: reviewsAdminData.nonce,
        review_id: id
      }).done(function(res){
        if(res && res.success){
          $row.fadeOut(200, function(){ $(this).remove(); });
        } else { alert((res && res.data) || 'Failed'); }
      }).fail(function(){ alert('Failed'); });
    });

    $wrap.on('click', '.delete-review', function(){
      if(!confirm('آیا مطمئن هستید؟')) return;
      var id = $(this).data('id');
      var $row = $('#review-'+id);
      $.post(reviewsAdminData.ajaxUrl, {
        action: 'delete_patient_review',
        nonce: reviewsAdminData.nonce,
        review_id: id
      }).done(function(res){
        if(res && res.success){
          $row.fadeOut(200, function(){ $(this).remove(); });
        } else { alert((res && res.data) || 'Failed'); }
      }).fail(function(){ alert('Failed'); });
    });
  });
})(jQuery);
