<?php
/**
 * Maintenance Mode Functionality
 * 
 * Displays a maintenance mode message for non-logged-in users when enabled
 */

if (!defined('ABSPATH')) {
    exit;
}

/**
 * Check if maintenance mode is enabled
 * 
 * @return bool True if maintenance mode is enabled, false otherwise
 */
function mohtavanegar_is_maintenance_mode() {
    $settings = get_option('basic_settings', array());
    return isset($settings['maintenance_mode']) && $settings['maintenance_mode'] == 1;
}

/**
 * Redirect non-logged-in users to maintenance page
 */
function mohtavanegar_maintenance_mode_redirect() {
    // Only apply if maintenance mode is enabled
    if (!mohtavanegar_is_maintenance_mode()) {
        return;
    }
    
    // Don't redirect logged-in users or admin pages
    if (is_user_logged_in() || is_admin()) {
        return;
    }
    
    // Don't redirect AJAX requests or API requests
    if (wp_doing_ajax() || (defined('REST_REQUEST') && REST_REQUEST)) {
        return;
    }
    
    // Display maintenance page
    wp_die(
        '<div style="text-align: center; font-family: Vazirmatn, sans-serif; padding: 50px 20px;">
            <h1 style="font-size: 36px; color: #333;">' . __('در حال تعمیر', 'mohtavanegar') . '</h1>
            <p style="font-size: 18px; color: #666; margin-top: 20px;">' . 
                __('سایت در حال حاضر در دست تعمیر است. لطفاً بعداً مراجعه کنید.', 'mohtavanegar') . 
            '</p>
        </div>',
        __('در حال تعمیر', 'mohtavanegar'),
        array('response' => 503)
    );
    exit;
}
add_action('template_redirect', 'mohtavanegar_maintenance_mode_redirect');

/**
 * Add admin bar notification when maintenance mode is active
 */
function mohtavanegar_maintenance_mode_admin_bar($admin_bar) {
    if (!mohtavanegar_is_maintenance_mode() || !is_admin_bar_showing()) {
        return;
    }
    
    $admin_bar->add_node(array(
        'id'    => 'maintenance-mode',
        'title' => '<span style="color: #ff6b6b;">' . __('حالت تعمیر فعال است', 'mohtavanegar') . '</span>',
        'href'  => admin_url('admin.php?page=theme-settings#basic-settings'),
        'meta'  => array(
            'title' => __('کلیک کنید برای غیرفعال کردن حالت تعمیر', 'mohtavanegar'),
        ),
    ));
}
add_action('admin_bar_menu', 'mohtavanegar_maintenance_mode_admin_bar', 100);
