<?php
if (!defined('ABSPATH')) {
    exit;
}

// Load Footer Template with Type
function mohtavanegar_load_footer_template() {
    if (!function_exists('mohtavanegar_is_elementor_active') || !mohtavanegar_is_elementor_active()) {
        return;
    }

    static $footer_template_id = null;
    static $footer_type = null;
    
    if ($footer_template_id === null) {
        $footer_template_id = get_option('footer_template');
        $footer_type = get_option('footer_type', 'default');
    }
    
    if ($footer_template_id) {
        echo '<div class="site-footer type-' . esc_attr($footer_type) . '">';
        if (function_exists('mohtavanegar_get_elementor_template')) {
            echo mohtavanegar_get_elementor_template($footer_template_id);
        } else {
            echo do_shortcode('[elementor-template id="' . $footer_template_id . '"]');
        }
        echo '</div>';
    }
}

// Add Theme Builder Footer Support
function mohtavanegar_theme_builder_footer() {
    if (!function_exists('mohtavanegar_is_elementor_active') || !mohtavanegar_is_elementor_active()) {
        return;
    }

    if (class_exists('\Elementor\Plugin')) {
        $elementor = \Elementor\Plugin::instance();
        $document = $elementor->documents->get_current();
        
        if ($document && $document->get_location() === 'footer') {
            remove_action('get_footer', 'mohtavanegar_load_footer_template');
        }
    }
}
add_action('wp', 'mohtavanegar_theme_builder_footer'); 