<?php
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Safe version of the Elementor cache clearing function for import process
 * This version doesn't require a nonce check
 */
function mohtavanegar_clear_elementor_cache_for_import() {
    error_log('Safely clearing Elementor cache for import process');
    
    // Clear Elementor cache
    if (class_exists('\Elementor\Plugin')) {
        try {
            error_log('Elementor class found, clearing cache');
            \Elementor\Plugin::$instance->files_manager->clear_cache();
            error_log('Elementor cache cleared successfully');
            return true;
        } catch (Exception $e) {
            error_log('Error clearing Elementor cache: ' . $e->getMessage());
            return false;
        }
    } else {
        error_log('Elementor class not found');
        return false;
    }
}
