jQuery(document).ready(function($) {
    // Show modal on import button click
    $('.import-template-btn').on('click', function() {
        var templateFile = $(this).data('template-file');
        $('#import-template-modal').data('template-file', templateFile).fadeIn();
    });

    // Hide modal on close
    $('.import-template-modal-close').on('click', function() {
        $('#import-template-modal').fadeOut();
        resetImportModal();
    });

    // Hide modal on outside click
    $(window).on('click', function(e) {
        if ($(e.target).is('#import-template-modal')) {
            $('#import-template-modal').fadeOut();
            resetImportModal();
        }
    });

    // Handle import form submit
    $('#import-template-form').on('submit', function(e) {
        e.preventDefault();
        var importItems = [];
        $('#import-template-form input[name="import_items[]"]:checked').each(function() {
            importItems.push($(this).val());
        });
        if (importItems.length === 0) {
            alert('لطفاً حداقل یک مورد را برای درون‌ریزی انتخاب کنید.');
            return;
        }
        var templateFile = $('#import-template-modal').data('template-file');
        if (!templateFile) {
            alert('فایل قالب انتخاب نشده است.');
            return;
        }
        $('.import-progress-container').show();
        $('.import-progress-bar').css('width', '0%').css('background-color', '#0073aa');
        $('.import-progress-text').text('در حال شروع درون‌ریزی...');
        $('.import-actions').html('');
        // Start import process (simulate file import via AJAX)
        startImport(templateFile, importItems);
    });

    function resetImportModal() {
        $('#import-template-form')[0].reset();
        $('.import-progress-container').hide();
        $('.import-progress-bar').css('width', '0%').css('background-color', '#0073aa');
        $('.import-progress-text').text('');
        $('.import-actions').html('');
    }

    // Simulate import process (replace with real AJAX as needed)
    function startImport(templateFile, importItems) {
        $.ajax({
            url: mohtavanegarReadyTemplates.ajaxurl,
            type: 'POST',
            data: {
                action: 'mohtavanegar_start_import',
                nonce: mohtavanegarReadyTemplates.nonce,
                import_url: templateFile,
                import_items: JSON.stringify(importItems)
            },
            success: function(response) {
                console.log('Start import response:', response);
                if (response.success && response.data && response.data.import_id) {
                    // Start polling for progress
                    $('.import-progress-text').text('درون‌ریزی آغاز شد...');
                    updateImportProgress(response.data.import_id);
                } else {
                    handleImportError(response.data && response.data.message ? response.data.message : 'خطا در شروع درون‌ریزی.');
                }
            },
            error: function() {
                handleImportError('خطا در ارتباط با سرور.');
            }
        });
    }

    // Update import progress by polling the server
    function updateImportProgress(importId) {
        console.log('Polling import progress for ID:', importId);
        $.ajax({
            url: mohtavanegarReadyTemplates.ajaxurl,
            type: 'POST',
            data: {
                action: 'mohtavanegar_import_progress',
                nonce: mohtavanegarReadyTemplates.nonce,
                import_id: importId,
                // The server-side import_progress function handles the step internally
                // We just need to keep asking for the latest status
            },
            success: function(response) {
                console.log('Progress update response:', response);
                if (response.success) {
                    const progress = response.data.progress;
                    const currentItem = response.data.current_item;
                    const isComplete = response.data.is_complete;

                    // Update progress bar
                    $('.import-progress-bar').css('width', progress + '%');
                    $('.import-progress-text').text(currentItem + ' - ' + progress + '%');

                    if (isComplete) {
                        $('.import-progress-text').text('درون‌ریزی با موفقیت انجام شد.');
                        // Show success message and potentially reload
                         const successMessage = $('<div>', {
                            'class': 'status-message status-success',
                            'text': 'درون‌ریزی با موفقیت انجام شد.',
                            'style': 'display: block; margin-top: 15px;'
                        });

                        $('.import-actions').html('').append(successMessage);

                        setTimeout(function() {
                            $('#import-template-modal').fadeOut();
                            resetImportModal();
                            // Consider reloading the page after successful import if needed
                            // location.reload();
                        }, 3000);
                    } else {
                        // Continue polling
                        setTimeout(function() {
                            updateImportProgress(importId);
                        }, 1000); // Poll every 1 second
                    }
                } else {
                     // Handle error reported by the server-side progress check
                     handleImportError(response.data && response.data.message ? response.data.message : 'خطا در به‌روزرسانی وضعیت درون‌ریزی.');
                }
            },
            error: function(xhr, status, error) {
                 console.error('AJAX error during progress update:', status, error);
                 console.error('Response text:', xhr.responseText);
                handleImportError('خطا در ارتباط با سرور برای وضعیت درون‌ریزی: ' + error);
            }
        });
    }

    function handleImportError(message) {
        $('.import-progress-text').text('خطا: ' + message);
        $('.import-progress-bar').css('background-color', '#dc3232');
    }
});
