<?php
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Ready Templates System
 * 
 * This file handles the functionality for displaying and importing ready-made templates
 * from an external API.
 */

// Add admin submenu for ready templates
function mohtavanegar_add_ready_templates_menu() {
    add_submenu_page(
        'theme-settings',
        'قالب های آماده',
        'قالب های آماده',
        'manage_options',
        'theme-ready-templates',
        'mohtavanegar_ready_templates_page'
    );
}
add_action('admin_menu', 'mohtavanegar_add_ready_templates_menu');

// Enqueue styles and scripts
function mohtavanegar_ready_templates_assets() {
    wp_enqueue_style('ready-templates-style', get_template_directory_uri() . '/settings/css/ready-templates.css');
    wp_enqueue_script('ready-templates-script', get_template_directory_uri() . '/settings/js/ready-templates.js', array('jquery'), null, true);
    wp_localize_script(
        'ready-templates-script',
        'mohtavanegarReadyTemplates',
        array(
            'ajaxurl' => admin_url('admin-ajax.php'),
            'nonce'   => wp_create_nonce('mohtavanegar_import_export_nonce'),
        )
    );
}
add_action('admin_enqueue_scripts', 'mohtavanegar_ready_templates_assets');

// Display the ready templates page
function mohtavanegar_ready_templates_page() {
    // Get templates from API
    $response = wp_remote_get('https://medpress.net/wp-json/dptm/v1/templates');
    
    if (is_wp_error($response)) {
        echo '<div class="error">خطا در دریافت قالب ها: ' . $response->get_error_message() . '</div>';
        return;
    }

    $templates = json_decode(wp_remote_retrieve_body($response), true);

    ?>
    <div class="wrap">
        <h1>قالب های آماده</h1>
        <div class="ready-templates-container">
            <div class="ready-templates-grid">
                <?php foreach ($templates as $template): ?>
                    <div class="template-card">
                        <img src="<?php echo esc_url($template['thumbnail']); ?>" alt="<?php echo esc_html($template['title']); ?>">
                        <div class="template-card-content">
                            <h3 class="template-card-title"><?php echo esc_html($template['title']); ?></h3>
                            <p class="template-card-description"><?php echo esc_html($template['description']); ?></p>
                            <div class="template-card-actions">
                                <a href="<?php echo esc_url($template['demo_link']); ?>" target="_blank" class="template-card-button primary">نمایش دمو</a>
                                <button type="button" class="template-card-button secondary import-template-btn" data-template-file="<?php echo esc_url($template['template_file']); ?>">درون‌ریزی</button>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
    <!-- Import Modal -->
    <div id="import-template-modal" class="import-template-modal" style="display:none;">
        <div class="import-template-modal-content">
            <span class="import-template-modal-close">&times;</span>
            <h2>برون‌ریزی محتوا</h2>
            <p>انتخاب کنید که چه بخش‌هایی از سایت را می‌خواهید برون‌ریزی کنید:</p>
            <form id="import-template-form">
                <label><input type="checkbox" name="import_items[]" checked value="posts"> نوشته‌ها + دسته‌بندی‌ها</label><br>
                <label><input type="checkbox" name="import_items[]" checked value="pages"> برگه‌ها</label><br>
                <label><input type="checkbox" name="import_items[]" checked value="services"> خدمات + دسته‌بندی‌ها</label><br>
                <label><input type="checkbox" name="import_items[]" checked value="menus"> منوها</label><br>
                <label><input type="checkbox" name="import_items[]" checked value="theme_settings"> تنظیمات قالب</label><br>
                <label><input type="checkbox" name="import_items[]" checked value="elementor_templates"> قالب‌های المنتور</label><br>
                <label><input type="checkbox" name="import_items[]" checked value="media"> رسانه‌ها</label><br>
                <button type="submit" class="template-card-button primary" id="start-import-btn">شروع درون‌ریزی</button>
            </form>
            <div class="import-progress-container" style="display:none; margin-top:20px;">
                <div class="import-progress-bar" style="width:0%;height:8px;background:#0073aa;border-radius:4px;"></div>
                <div class="import-progress-text" style="margin-top:10px;"></div>
                <div class="import-actions" style="margin-top:10px;"></div>
            </div>
        </div>
    </div>
    <?php
}
