<?php
function mohtavanegar_service_settings_page() {
    $service_settings = get_option('service_settings', array('service_button_color' => '#0073aa'));
    ?>
    <h2><?php _e('تنظیمات خدمات', 'mohtavanegar'); ?></h2>
    <table class="form-table">
        <tr>
            <th scope="row"><?php _e('رنگ دکمه خدمات', 'mohtavanegar'); ?></th>
            <td>
                <input type="text" name="service_settings[service_button_color]" value="<?php echo esc_attr($service_settings['service_button_color']); ?>" class="color-field" data-default-color="#0073aa" />
                <p class="description"><?php _e('رنگ دکمه خدمات را انتخاب کنید.', 'mohtavanegar'); ?></p>
            </td>
        </tr>
        <tr>
            <th scope="row"><?php _e('رنگ متن دکمه خدمات', 'mohtavanegar'); ?></th>
            <td>
                <input type="text" name="service_settings[service_button_text_color]" value="<?php echo esc_attr(isset($service_settings['service_button_text_color']) ? $service_settings['service_button_text_color'] : '#ffffff'); ?>" class="color-field" data-default-color="#ffffff" />
                <p class="description"><?php _e('رنگ متن دکمه خدمات را انتخاب کنید.', 'mohtavanegar'); ?></p>
            </td>
        </tr>
    </table>
    <script>
    jQuery(document).ready(function($){
        $('.color-field').wpColorPicker();
    });
    </script>
    <?php
} 