<?php

/**
 * Add icon upload field to taxonomy edit forms
 */
function add_taxonomy_icon_field($term) {
    $icon_id = null;
    $display_order = '';
    
    // If this is a term object (edit form)
    if (is_object($term) && isset($term->term_id)) {
        $icon_id = get_term_meta($term->term_id, 'taxonomy_icon', true);
        $display_order = get_term_meta($term->term_id, 'display_order', true);
    }
    // If this is a taxonomy string (add form)
    else if (is_string($term)) {
        $icon_id = null; // No icon for new terms
        $display_order = '';
    }
    ?>
    <tr class="form-field">
        <th scope="row" valign="top">
            <label for="taxonomy_icon">آیکون</label>
        </th>
        <td>
            <input type="hidden" id="taxonomy_icon" name="taxonomy_icon" value="<?php echo esc_attr($icon_id); ?>">
            <div id="taxonomy_icon_preview">
                <?php 
                if ($icon_id) {
                    echo wp_get_attachment_image($icon_id, 'thumbnail');
                } else {
                    echo '<p>آیکونی انتخاب نشده است</p>';
                }
                ?>
            </div>
            <p>
                <input type="button" class="button button-secondary" value="آپلود آیکون" id="upload_taxonomy_icon">
                <input type="button" class="button button-secondary" value="حذف آیکون" id="remove_taxonomy_icon" <?php echo $icon_id ? '' : 'style="display:none"'; ?>>
            </p>
            <p class="description">برای انتخاب آیکون از گالری وردپرس استفاده کنید</p>
        </td>
    </tr>
    <tr class="form-field">
        <th scope="row" valign="top">
            <label for="display_order">شماره ترتیب اولیت نمایش</label>
        </th>
        <td>
            <input type="number" id="display_order" name="display_order" value="<?php echo esc_attr($display_order); ?>" min="0" step="1" style="width: 100px;">
            <p class="description">ترتیب نمایش زیر دسته‌ها (اختیاری، پیش‌فرض خالی است)</p>
        </td>
    </tr>
    <?php
}
add_action('category_add_form_fields', 'add_taxonomy_icon_field', 10, 2);
add_action('category_edit_form_fields', 'add_taxonomy_icon_field', 10, 2);
add_action('post_tag_add_form_fields', 'add_taxonomy_icon_field', 10, 2);
add_action('post_tag_edit_form_fields', 'add_taxonomy_icon_field', 10, 2);
add_action('services_category_add_form_fields', 'add_taxonomy_icon_field', 10, 2);
add_action('services_category_edit_form_fields', 'add_taxonomy_icon_field', 10, 2);


add_action('portfolio_category_add_form_fields', 'add_taxonomy_icon_field', 10, 2);
add_action('portfolio_category_edit_form_fields', 'add_taxonomy_icon_field', 10, 2);
add_action('edited_portfolio_category', 'save_taxonomy_icon');
add_action('create_portfolio_category', 'save_taxonomy_icon');
add_filter('manage_edit-portfolio_category_columns', 'add_taxonomy_icon_column');
add_action('manage_portfolio_category_custom_column', 'display_taxonomy_icon_column', 10, 3);

/**
 * Save taxonomy icon
 */
function save_taxonomy_icon($term_id) {
    if (isset($_POST['taxonomy_icon'])) {
        update_term_meta($term_id, 'taxonomy_icon', sanitize_text_field($_POST['taxonomy_icon']));
    }
    if (isset($_POST['display_order'])) {
        $order = sanitize_text_field($_POST['display_order']);
        if ($order === '') {
            delete_term_meta($term_id, 'display_order');
        } else {
            update_term_meta($term_id, 'display_order', $order);
        }
    }
}
add_action('edited_category', 'save_taxonomy_icon');
add_action('create_category', 'save_taxonomy_icon');
add_action('edited_post_tag', 'save_taxonomy_icon');
add_action('create_post_tag', 'save_taxonomy_icon');
add_action('edited_services_category', 'save_taxonomy_icon');
add_action('create_services_category', 'save_taxonomy_icon');
add_action('sellino_product_category_add_form_fields', 'add_taxonomy_icon_field', 10, 2);
add_action('sellino_product_category_edit_form_fields', 'add_taxonomy_icon_field', 10, 2);
add_action('edited_sellino_product_category', 'save_taxonomy_icon');
add_action('create_sellino_product_category', 'save_taxonomy_icon');

/**
 * Enqueue media upload scripts
 */
function enqueue_taxonomy_icon_scripts($hook) {
    if (in_array($hook, array('category.php', 'edit-tags.php', 'term.php'))) {
        wp_enqueue_media();
        wp_enqueue_script('taxonomy-icon-script', get_template_directory_uri() . '/js/taxonomy-icon.js', array('jquery'), '1.0', true);
    }
}
add_action('admin_enqueue_scripts', 'enqueue_taxonomy_icon_scripts');

/**
 * Add icon column to taxonomy list
 */
function add_taxonomy_icon_column($columns) {
    $new_columns = array();
    foreach ($columns as $key => $value) {
        $new_columns[$key] = $value;
        if ($key === 'name') {
            $new_columns['icon'] = 'آیکون';
            $new_columns['display_order'] = 'شماره ترتیب';
        }
    }
    return $new_columns;
}
add_filter('manage_edit-category_columns', 'add_taxonomy_icon_column');
add_filter('manage_edit-post_tag_columns', 'add_taxonomy_icon_column');
add_filter('manage_edit-services_category_columns', 'add_taxonomy_icon_column');
add_filter('manage_edit-sellino_product_category_columns', 'add_taxonomy_icon_column');

function display_taxonomy_icon_column($content, $column_name, $term_id) {
    if ($column_name === 'icon') {
        $icon_id = get_term_meta($term_id, 'taxonomy_icon', true);
        if ($icon_id) {
            echo wp_get_attachment_image($icon_id, 'thumbnail');
        }
    } elseif ($column_name === 'display_order') {
        $order = get_term_meta($term_id, 'display_order', true);
        echo esc_html($order);
    }
}
add_action('manage_category_custom_column', 'display_taxonomy_icon_column', 10, 3);
add_action('manage_post_tag_custom_column', 'display_taxonomy_icon_column', 10, 3);
add_action('manage_services_category_custom_column', 'display_taxonomy_icon_column', 10, 3);
add_action('manage_sellino_product_category_custom_column', 'display_taxonomy_icon_column', 10, 3);

/**
 * Add icon to taxonomy term links
 */
function add_taxonomy_icon_to_link($link, $term) {
    $icon_id = get_term_meta($term->term_id, 'taxonomy_icon', true);
    if ($icon_id) {
        $icon = wp_get_attachment_image($icon_id, 'thumbnail');
        $link = str_replace('</a>', $icon . '</a>', $link);
    }
    return $link;
}
add_filter('get_term_link', 'add_taxonomy_icon_to_link', 10, 2);
