<?php
/**
 * The template for displaying services_category taxonomy archive
 */

get_header();

// Get service button color from settings
$service_settings = get_option('service_settings', array('service_button_color' => '#0073aa', 'service_button_text_color' => '#ffffff'));
$service_button_color = isset($service_settings['service_button_color']) ? $service_settings['service_button_color'] : '#0073aa';
$service_button_text_color = isset($service_settings['service_button_text_color']) ? $service_settings['service_button_text_color'] : '#ffffff';
?>

<style>

.read-more-btn{
    background-color:<?php echo esc_attr($service_button_color); ?> ;
    color: <?php echo esc_attr($service_button_text_color); ?>;
}
</style>

<main id="primary" class="site">
    <div class="container">
        <header class="page-header">
            <?php
            $term = get_queried_object();
            $term_icon_id = get_term_meta($term->term_id, 'taxonomy_icon', true);
            $has_term_icon = !empty($term_icon_id);
            ?>
            <div class="term-header-content">
                <?php if ($has_term_icon) : ?>
                <div class="term-icon">
                    <?php echo wp_get_attachment_image($term_icon_id, 'thumbnail'); ?>
                </div>
                <?php endif; ?>
                <div class="term-text">
                    <h1 class="page-title"><?php echo esc_html($term->name); ?></h1>
                    <?php if (!empty($term->description)) : ?>
                        <div class="archive-description"><?php echo wp_kses_post(wpautop(do_shortcode($term->description))); ?></div>
                    <?php endif; ?>
                </div>
            </div>
        </header>

        <div class="services_category-content">
            <?php
            // Get the current term and ensure it's valid
            $current_term = get_queried_object();
            
            // Display posts in this category - Show only direct posts of current category
            $services_query = new WP_Query(array(
                'post_type' => 'services',
                'posts_per_page' => -1, // Show all posts
                'tax_query' => array(
                    array(
                        'taxonomy' => 'services_category',
                        'field' => 'term_id',
                        'terms' => $current_term->term_id,
                        'include_children' => false, // Don't include posts from child categories
                    ),
                ),
                'orderby' => 'title',
                'order' => 'ASC',
            ));

            if ($services_query->have_posts()) :
                ?>
                <div class="services-section">
                    <h2 class="section-title"><?php esc_html_e('خدمات', 'mohtavanegar'); ?></h2>
                    <div class="services-grid">
                        <?php
                        while ($services_query->have_posts()) :
                            $services_query->the_post();
                            ?>
                            <article id="post-<?php the_ID(); ?>" <?php post_class('service-card'); ?>>
                                <?php if (has_post_thumbnail()) : ?>
                                    <div class="service-thumbnail">
                                        <a href="<?php the_permalink(); ?>">
                                            <?php the_post_thumbnail('medium'); ?>
                                        </a>
                                    </div>
                                <?php endif; ?>
                                
                                <div class="service-content">
                                    <header class="entry-header">
                                        <?php the_title('<h3 class="entry-title"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h3>'); ?>
                                    </header>

                                    <div class="entry-content">
                                        <?php echo wp_trim_words(get_the_excerpt(), 20, '...'); ?>
                                    </div>
                                    
                                    <div class="service-footer">
                                        <a href="<?php the_permalink(); ?>" class="read-more-btn">
                                            <?php esc_html_e('مشاهده جزئیات', 'mohtavanegar'); ?> <i class="fas fa-arrow-left"></i>
                                        </a>
                                    </div>
                                </div>
                            </article>
                            <?php
                        endwhile;
                        ?>
                    </div>
                </div>
                <?php
                wp_reset_postdata(); // Reset post data
            endif;

            if ($current_term && !is_wp_error($current_term)) {
                // Check if the current term has children
                $child_terms = get_terms(array(
                    'taxonomy' => 'services_category',
                    'parent' => $current_term->term_id,
                    'hide_empty' => false, // Show all subcategories regardless of posts
                    // We'll sort manually after fetching
                    'number' => 0, // No limit - show all subcategories
                ));

                // Display subcategories if they exist
                if (!empty($child_terms) && !is_wp_error($child_terms)) :
                    // Sort by display_order meta if set, otherwise by name
                    usort($child_terms, function($a, $b) {
                        $order_a = get_term_meta($a->term_id, 'display_order', true);
                        $order_b = get_term_meta($b->term_id, 'display_order', true);
                        if ($order_a === '' && $order_b === '') {
                            return strcasecmp($a->name, $b->name);
                        } elseif ($order_a === '') {
                            return 1;
                        } elseif ($order_b === '') {
                            return -1;
                        } elseif ($order_a == $order_b) {
                            return strcasecmp($a->name, $b->name);
                        } else {
                            return intval($order_a) - intval($order_b);
                        }
                    });
                    ?>
                    <div class="subcategories-section">
                        <h2 class="section-title"><?php esc_html_e('زیر دسته‌ها', 'mohtavanegar'); ?></h2>
                        <div class="services-subcategories">
                            <div class="taxonomy-display display-grid columns-3 mobile-columns-2">
                                <?php foreach ($child_terms as $child_term) : 
                                    $icon_id = get_term_meta($child_term->term_id, 'taxonomy_icon', true);
                                    $has_icon = !empty($icon_id);
                                    $term_count = $child_term->count;
                                    
                                    // Item class
                                    $item_class = 'taxonomy-item text-align-center subcategory-card';
                                    if ($has_icon) {
                                        $item_class .= ' has-icon icon-top';
                                    }
                                ?>
                                    <div class="<?php echo esc_attr($item_class); ?>">
                                        <a href="<?php echo get_term_link($child_term); ?>" class="taxonomy-card-link">
                                            <?php if ($has_icon) : ?>
                                                <div class="taxonomy-icon position-top">
                                                    <?php echo wp_get_attachment_image($icon_id, 'large'); ?>
                                                </div>
                                            <?php endif; ?>

                                            <div class="taxonomy-content">
                                                <h3 class="taxonomy-name"><?php echo esc_html($child_term->name); ?></h3>
                                                <span class="term-count"><?php printf(_n('%d خدمت', '%d خدمت', $term_count, 'mohtavanegar'), $term_count); ?></span>
                                                <?php if (!empty($child_term->description)) : ?>
                                                    <div class="term-description">
                                                        <?php echo wp_trim_words(do_shortcode($child_term->description), 15, '...'); ?>
                                                    </div>
                                                <?php endif; ?>
                                                <span class="view-more"><?php esc_html_e('مشاهده خدمات', 'mohtavanegar'); ?> <i class="fas fa-arrow-left"></i></span>
                                            </div>
                                        </a>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                    <?php
                endif;
            }
            
            ?>
        </div>
    </div>
</main>

<?php
get_footer();
