<?php
namespace Elementor;

if (!defined('ABSPATH')) {
    exit;
}

class Mohtavanegar_Before_After_Widget extends Widget_Base {

    public function get_name() {
        return 'mohtavanegar-before-after';
    }

    public function get_title() {
        return esc_html__('قبل و بعد', 'mohtavanegar');
    }

    public function get_icon() {
        return 'eicon-compare';
    }

    public function get_categories() {
        return ['mohtavanegar'];
    }

    protected function register_controls() {
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('تصاویر', 'mohtavanegar'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'before_image',
            [
                'label' => esc_html__('عکس قبل', 'mohtavanegar'),
                'type' => Controls_Manager::MEDIA,
                'default' => [__DIR__ . '/../../assets/images/placeholder.png']
            ]
        );

        $this->add_control(
            'after_image',
            [
                'label' => esc_html__('عکس بعد', 'mohtavanegar'),
                'type' => Controls_Manager::MEDIA,
                'default' => [__DIR__ . '/../../assets/images/placeholder.png']
            ]
        );

        $this->add_control(
            'before_label',
            [
                'label' => esc_html__('متن قبل', 'mohtavanegar'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('قبل', 'mohtavanegar'),
            ]
        );

        $this->add_control(
            'after_label',
            [
                'label' => esc_html__('متن بعد', 'mohtavanegar'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('بعد', 'mohtavanegar'),
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'settings_section',
            [
                'label' => esc_html__('تنظیمات', 'mohtavanegar'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'orientation',
            [
                'label' => esc_html__('جهت', 'mohtavanegar'),
                'type' => Controls_Manager::SELECT,
                'default' => 'horizontal',
                'options' => [
                    'horizontal' => esc_html__('افقی', 'mohtavanegar'),
                    'vertical' => esc_html__('عمودی', 'mohtavanegar'),
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('سیستم', 'mohtavanegar'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'margin',
            [
                'label' => esc_html__('حاشیه', 'mohtavanegar'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}}' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'border_radius',
            [
                'label' => esc_html__('حاشیه گرد', 'mohtavanegar'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .img-comp-container' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'selector' => '{{WRAPPER}} .img-comp-container',
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $before_image_url = $settings['before_image']['url'];
        $after_image_url = $settings['after_image']['url'];
        $before_label = $settings['before_label'];
        $after_label = $settings['after_label'];
        $orientation = $settings['orientation'];

        // Ensure unique ID for each instance
        $widget_id = $this->get_id();
        ?>
        <style>
            #mohtavanegar-compare-<?php echo esc_attr($widget_id); ?> {
                --slider-size: 40px;
                --slider-border: 2px;
            }
            .img-comp-container {
                position: relative;
                width: 100%;
                height: 0;
                padding-bottom: 56.25%; /* 16:9 Aspect Ratio */
                overflow: hidden;
            }
            .img-comp-img {
                position: absolute;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                overflow: hidden;
            }
            .img-comp-overlay {
                /* clip-path will be set dynamically by JavaScript */
            }
            .img-comp-img img {
                display: block;
                position: absolute;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                object-fit: cover;
                object-position: center;
                max-width: none;
                max-height: none;
            }
            .img-comp-slider {
                position: absolute;
                z-index: 9;
                width: var(--slider-size);
                height: var(--slider-size);
                background-color: #FFFFFF;
                opacity: 0.9;
                border-radius: 50%;
                border: var(--slider-border) solid #FFFFFF;
                box-shadow: 0 0 10px rgba(0,0,0,0.5);
                transform: translate(-50%, -50%);
                transition: background-color 0.2s ease;
            }
            .img-comp-slider:hover {
                background-color: #f0f0f0;
            }
            .img-comp-slider:after {
                content: '';
                position: absolute;
                background-color: #333;
            }
            .img-comp-container[data-orientation="horizontal"] .img-comp-slider {
                top: 50%;
                left: 50%;
                cursor: ew-resize;
            }
            .img-comp-container[data-orientation="horizontal"] .img-comp-slider:after {
                width: 20px;
                height: 20px;
                top: calc(50% - 10px);
                left: calc(50% - 10px);
                background-color: transparent;
                border-right: 2px solid #333;
                border-bottom: 2px solid #333;
                transform: rotate(-45deg);
            }
            .img-comp-container[data-orientation="vertical"] .img-comp-slider {
                left: 50%;
                top: 50%;
                cursor: ns-resize;
            }
            .img-comp-container[data-orientation="vertical"] .img-comp-slider:after {
                width: 20px;
                height: 20px;
                top: calc(50% - 10px);
                left: calc(50% - 10px);
                background-color: transparent;
                border-right: 2px solid #333;
                border-bottom: 2px solid #333;
                transform: rotate(45deg);
            }
            .img-comp-label {
                position: absolute;
                padding: 8px 12px;
                background: rgba(0,0,0,0.6);
                color: #fff;
                font-size: 14px;
                font-weight: bold;
                z-index: 8;
                border-radius: 4px;
                pointer-events: none;
            }
            .img-comp-label-before {
                left: 10px;
                top: 10px;
            }
            .img-comp-label-after {
                right: 10px;
                top: 10px;
                z-index: 10;
            }
        </style>
        <div class="img-comp-container" id="mohtavanegar-compare-<?php echo esc_attr($widget_id); ?>" data-orientation="<?php echo esc_attr($orientation); ?>">
            <div class="img-comp-img">
                <img src="<?php echo esc_url($before_image_url); ?>" alt="<?php echo esc_attr($before_label); ?>">
                <div class="img-comp-label img-comp-label-before"><?php echo esc_html($before_label); ?></div>
            </div>
            <div class="img-comp-img img-comp-overlay">
                <img src="<?php echo esc_url($after_image_url); ?>" alt="<?php echo esc_attr($after_label); ?>">
            </div>
            <div class="img-comp-label img-comp-label-after"><?php echo esc_html($after_label); ?></div>
        </div>
        <script>
            (function() {
                function initComparisons() {
                    var containers = document.querySelectorAll('.img-comp-container');
                    containers.forEach(function(container) {
                        var overlay = container.querySelector('.img-comp-overlay');
                        var orientation = container.getAttribute('data-orientation') || 'horizontal';
                        compareImages(overlay, orientation);
                    });
                    
                    function compareImages(img, orientation) {
                        var container = img.parentElement;
                        var slider, clicked = 0, w, h;
                        
                        // Get container dimensions
                        w = container.offsetWidth;
                        h = container.offsetHeight;
                        
                        // Set initial position
                        if (orientation === 'horizontal') {
                            img.style.clipPath = `inset(0 0 0 ${w/2}px)`;
                            img.style.width = "100%";
                            img.style.height = "100%";
                        } else {
                            img.style.clipPath = `inset(${h/2}px 0 0 0)`;
                            img.style.width = "100%";
                            img.style.height = "100%";
                        }
                        
                        // Check if slider already exists and remove it
                        var existingSlider = container.querySelector('.img-comp-slider');
                        if (existingSlider) {
                            container.removeChild(existingSlider);
                        }
                        
                        // Create slider
                        slider = document.createElement("DIV");
                        slider.setAttribute("class", "img-comp-slider");
                        container.appendChild(slider);
                        
                        // Position slider
                        var initialPos = orientation === 'horizontal' ? w / 2 : h / 2;
                        if (orientation === 'horizontal') {
                            slider.style.left = initialPos + "px";
                            slider.style.top = (h / 2) + "px";
                        } else {
                            slider.style.left = (w / 2) + "px";
                            slider.style.top = initialPos + "px";
                        }
                        
                        // Initial slide to set correct clip path
                        slide(initialPos);
                        
                        // Event listeners
                        slider.addEventListener("mousedown", slideReady);
                        window.addEventListener("mouseup", slideFinish);
                        slider.addEventListener("touchstart", slideReady);
                        window.addEventListener("touchend", slideFinish);
                        
                        function slideReady(e) {
                            e.preventDefault();
                            clicked = 1;
                            window.addEventListener("mousemove", slideMove);
                            window.addEventListener("touchmove", slideMove);
                        }
                        
                        function slideFinish() {
                            clicked = 0;
                            window.removeEventListener("mousemove", slideMove);
                            window.removeEventListener("touchmove", slideMove);
                        }
                        
                        function slideMove(e) {
                            if (clicked == 0) return false;
                            
                            var pos = getCursorPos(e);
                            
                            // Constrain position
                            if (orientation === 'horizontal') {
                                if (pos < 0) pos = 0;
                                if (pos > w) pos = w;
                                slide(pos);
                            } else {
                                if (pos < 0) pos = 0;
                                if (pos > h) pos = h;
                                slide(pos);
                            }
                        }
                        
                        function getCursorPos(e) {
                            var rect, x = 0, y = 0;
                            e = (e.changedTouches) ? e.changedTouches[0] : e;
                            rect = container.getBoundingClientRect();
                            
                            // Get cursor position relative to container
                            x = e.pageX - rect.left - window.pageXOffset;
                            y = e.pageY - rect.top - window.pageYOffset;
                            
                            return orientation === 'horizontal' ? x : y;
                        }
                        
                        function slide(pos) {
                            if (orientation === 'horizontal') {
                                img.style.clipPath = `inset(0 0 0 ${pos}px)`;
                                slider.style.left = pos + "px";
                            } else {
                                img.style.clipPath = `inset(${pos}px 0 0 0)`;
                                slider.style.top = pos + "px";
                            }
                        }
                    }
                }

                // Initialize on document ready
                if (document.readyState === 'complete' || document.readyState === 'interactive') {
                    setTimeout(initComparisons, 1);
                } else {
                    document.addEventListener('DOMContentLoaded', initComparisons);
                }
                
                // Also initialize when jQuery is ready for compatibility
                if (typeof jQuery !== 'undefined') {
                    jQuery(document).ready(function() {
                        initComparisons();
                    });
                }
            })();
        </script>
        <?php
    }

    protected function _content_template() {
        // This method is used in the Elementor editor to render a preview.
        // We'll add a basic template here.
        ?>
        <div class="mohtavanegar-before-after-container" data-orientation="{{{ settings.orientation }}}">
            <#
            var beforeImage = settings.before_image;
            var afterImage = settings.after_image;
            var beforeLabel = settings.before_label;
            var afterLabel = settings.after_label;
            #>
            <div class="mohtavanegar-before-image-container">
                <img src="{{{ beforeImage.url }}}" class="mohtavanegar-before-image" alt="{{{ beforeLabel }}}">
                <div class="mohtavanegar-before-label">{{{ beforeLabel }}}</div>
            </div>
            <div class="mohtavanegar-after-image-container">
                <img src="{{{ afterImage.url }}}" class="mohtavanegar-after-image" alt="{{{ afterLabel }}}">
            </div>
            <div class="mohtavanegar-slider"></div>
            <div class="mohtavanegar-after-label">{{{ afterLabel }}}</div>
        </div>
        <?php
    }

    public function get_style_depends() {
        return ['mohtavanegar-before-after-style'];
    }

    public function get_script_depends() {
        return ['mohtavanegar-before-after-script'];
    }
}