<?php
if (!defined('ABSPATH')) {
    exit;
}

class Mohtavanegar_Elementor_Widgets {
    private static $_instance = null;

    public static function instance() {
        if (is_null(self::$_instance)) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }

    public function __construct() {
        // Support both older and newer versions of Elementor
        if (version_compare(ELEMENTOR_VERSION, '3.5.0', '<')) {
            // For Elementor < 3.5.0
            add_action('elementor/widgets/widgets_registered', [$this, 'register_widgets']);
        } else {
            // For Elementor >= 3.5.0
            add_action('elementor/widgets/register', [$this, 'register_widgets']);
        }
        
        // Categories registration also has a newer hook
        if (version_compare(ELEMENTOR_VERSION, '3.0.0', '<')) {
            add_action('elementor/elements/categories_registered', [$this, 'add_widget_categories']);
        } else {
            add_action('elementor/elements/categories_register', [$this, 'add_widget_categories']);
        }
    }

    public function register_widgets($widgets_manager) {
        $this->register_mohtavanegar_elementor_widgets($widgets_manager);
    }

    public function register_mohtavanegar_elementor_widgets($widgets_manager) {
        // Enqueue widget styles
        wp_enqueue_style(
            'taxonomy-display-widget',
            get_template_directory_uri() . '/assets/css/taxonomy-display-widget.css',
            array(),
            '1.0.0'
        );

        // Enqueue widget styles and scripts
        wp_register_style(
            'contact-us-widget',
            get_template_directory_uri() . '/assets/css/contact-us-widget.css',
            [],
            '1.0.0'
        );
        
        wp_register_script(
            'contact-us-widget',
            get_template_directory_uri() . '/assets/js/contact-us-widget.js',
            ['jquery'],
            '1.0.0',
            true
        );
        
        // Register Appointment Websites Widget assets
        wp_register_style(
            'appointment-websites-widget',
            get_template_directory_uri() . '/assets/css/appointment-websites-widget.css',
            [],
            '1.0.0'
        );
        
        wp_register_script(
            'appointment-websites-widget',
            get_template_directory_uri() . '/assets/js/appointment-websites-widget.js',
            ['jquery', 'imagesloaded'],
            '1.0.0',
            true
        );

        // Register widget styles and scripts
 
        if (!wp_style_is('posts-display-widget', 'registered')) {
            wp_register_style(
                'posts-display-widget',
                get_template_directory_uri() . '/assets/css/posts-display-widget.css',
                ['swiper'],
                '1.5.0'
            );
        }
 
        if (!wp_script_is('posts-display-widget', 'registered')) {
            wp_register_script(
                'posts-display-widget',
                get_template_directory_uri() . '/assets/js/posts-display-widget.js',
                ['jquery', 'swiper'],
                '1.5.0',
                true
            );
            
            // Localize script for RTL support
            wp_localize_script('posts-display-widget', 'mohtavanegarPostsVars', [
                'rtl' => is_rtl()
            ]);
        }
        
        // Enqueue the scripts and styles
        wp_enqueue_style('swiper');
        wp_enqueue_style('posts-display-widget');
        wp_enqueue_script('swiper');
        wp_enqueue_script('posts-display-widget');

        // Register Search Modal widget assets
        if (!wp_style_is('search-modal-widget', 'registered')) {
            wp_register_style(
                'search-modal-widget',
                get_template_directory_uri() . '/assets/css/search-modal-widget.css',
                [],
                '1.0.0'
            );
        }
        if (!wp_script_is('search-modal-widget', 'registered')) {
            wp_register_script(
                'search-modal-widget',
                get_template_directory_uri() . '/assets/js/search-modal-widget.js',
                ['jquery'],
                '1.0.0',
                true
            );
            wp_localize_script('search-modal-widget', 'MN_SEARCH_MODAL_VARS', [
                'ajax_url' => admin_url('admin-ajax.php'),
                'nonce' => wp_create_nonce('mn_search_modal_nonce'),
                'home_url' => home_url('/'),
                'i18n_empty' => esc_html__('No results found', 'mohtavanegar'),
                'i18n_error' => esc_html__('An error occurred', 'mohtavanegar'),
            ]);
        }
        wp_enqueue_style('search-modal-widget');
        wp_enqueue_script('search-modal-widget');

        // Register Box Info widget assets (style only, loaded via widget dependency)
        if (!wp_style_is('box-info-widget', 'registered')) {
            wp_register_style(
                'box-info-widget',
                get_template_directory_uri() . '/assets/css/box-info-widget.css',
                [],
                '1.0.0'
            );
        }

        // Register Services List 02 widget style
        if (!wp_style_is('services-list-02-widget', 'registered')) {
            wp_register_style(
                'services-list-02-widget',
                get_template_directory_uri() . '/assets/css/services-list-02-widget.css',
                [],
                '1.0.0'
            );
        }

        // Include all widget files
        $widget_files = [
            'services-list-02-widget.php',
            'services-list-widget.php',
            'taxonomy-display-widget.php',
            'before-after-widget.php',
            'working-hours-widget.php',
            'qa-widget.php',
            'contact-us-widget.php',
            'appointment-websites-widget.php',
            'posts-display-widget.php',  // Moved here to include all widgets in one place
            'portfolio-widget.php', // اضافه شد
            'medpress-gallery-widget.php', // گالری مدپرس
            'search-modal-widget.php', // ویجت مودال جستجو
            'language-image-widget.php', // تصویر بر اساس زبان
            'box-info-widget.php', // باکس اطلاعات
            'reviews-form-widget.php',
            'reviews-slider-widget.php',
            'related-posts-slider-widget.php',
        ];
        
        foreach ($widget_files as $file) {
            $file_path = __DIR__ . '/' . $file;
            if (file_exists($file_path)) {
                require_once($file_path);
            } else {
                error_log('Widget file not found: ' . $file_path);
            }
        }
        
        // Register widgets with backward compatibility
        $this->register_widget_with_compatibility($widgets_manager, 'Mohtavanegar_Services_List_Widget');
        $this->register_widget_with_compatibility($widgets_manager, 'Mohtavanegar_Services_List_02_Widget');
        $this->register_widget_with_compatibility($widgets_manager, 'Elementor\\Mohtavanegar_Before_After_Widget');
        $this->register_widget_with_compatibility($widgets_manager, 'Mohtavanegar_Working_Hours_Widget');
        $this->register_widget_with_compatibility($widgets_manager, 'Mohtavanegar_Taxonomy_Display_Widget');
        $this->register_widget_with_compatibility($widgets_manager, 'Mohtavanegar_QA_Widget');
        
        // Check if the Posts Display Widget class exists before instantiating
        if (class_exists('Mohtavanegar_Posts_Display_Widget')) {
            $this->register_widget_with_compatibility($widgets_manager, 'Mohtavanegar_Posts_Display_Widget');
        } else {
            error_log('Mohtavanegar_Posts_Display_Widget class not found');
        }
        // ثبت ویجت نمونه کارها
        if (class_exists('Portfolio_Widget')) {
            $this->register_widget_with_compatibility($widgets_manager, 'Portfolio_Widget');
        } else {
            error_log('Portfolio_Widget class not found');
        }
        
        // ثبت ویجت گالری مدپرس
        if (class_exists('Mohtavanegar_Medpress_Gallery_Widget')) {
            $this->register_widget_with_compatibility($widgets_manager, 'Mohtavanegar_Medpress_Gallery_Widget');
        } else {
            error_log('Mohtavanegar_Medpress_Gallery_Widget class not found');
        }

        // ثبت ویجت مودال جستجو
        if (class_exists('Mohtavanegar_Search_Modal_Widget')) {
            $this->register_widget_with_compatibility($widgets_manager, 'Mohtavanegar_Search_Modal_Widget');
        } else {
            error_log('Mohtavanegar_Search_Modal_Widget class not found');
        }

        // ثبت ویجت تصویر بر اساس زبان
        if (class_exists('Elementor\\Mohtavanegar_Language_Image_Widget')) {
            $this->register_widget_with_compatibility($widgets_manager, 'Elementor\\Mohtavanegar_Language_Image_Widget');
        } else {
            error_log('Elementor\\Mohtavanegar_Language_Image_Widget class not found');
        }

        // ثبت ویجت Box Info
        if (class_exists('Mohtavanegar_Box_Info_Widget')) {
            $this->register_widget_with_compatibility($widgets_manager, 'Mohtavanegar_Box_Info_Widget');
        } else {
            error_log('Mohtavanegar_Box_Info_Widget class not found');
        }

        // ثبت ویجت های نظر بیماران
        if (class_exists('Mohtavanegar_Reviews_Form_Widget')) {
            $this->register_widget_with_compatibility($widgets_manager, 'Mohtavanegar_Reviews_Form_Widget');
        } else {
            error_log('Mohtavanegar_Reviews_Form_Widget class not found');
        }
        if (class_exists('Mohtavanegar_Reviews_Slider_Widget')) {
            $this->register_widget_with_compatibility($widgets_manager, 'Mohtavanegar_Reviews_Slider_Widget');
        } else {
            error_log('Mohtavanegar_Reviews_Slider_Widget class not found');
        }
        // ثبت ویجت پست های مرتبط
        if (class_exists('Mohtavanegar_Related_Posts_Slider_Widget')) {
            $this->register_widget_with_compatibility($widgets_manager, 'Mohtavanegar_Related_Posts_Slider_Widget');
        } else {
            error_log('Mohtavanegar_Related_Posts_Slider_Widget class not found');
        }
    }

    public function add_widget_categories($elements_manager) {
        $elements_manager->add_category(
            'mohtavanegar',
            [
                'title' => esc_html__('محتوا نگار', 'mohtavanegar'),
                'icon' => 'fa fa-plug',
            ]
        );
    }
    
    /**
     * Register widget with backward compatibility
     *
     * @param \Elementor\Widgets_Manager $widgets_manager
     * @param string $widget_class
     */
    private function register_widget_with_compatibility($widgets_manager, $widget_class) {
        if (class_exists($widget_class)) {
            if (method_exists($widgets_manager, 'register')) {
                // Elementor 3.5.0+
                $widgets_manager->register(new $widget_class());
            } else {
                // Older versions of Elementor
                $widgets_manager->register_widget_type(new $widget_class());
            }
        } else {
            error_log("Widget class not found: $widget_class");
        }
    }
}

// Initialize the widgets
Mohtavanegar_Elementor_Widgets::instance();


// AJAX برای بارگذاری فیلتر دسته‌ها
add_action('wp_ajax_filter_portfolio_items', 'filter_portfolio_items_callback');
add_action('wp_ajax_nopriv_filter_portfolio_items', 'filter_portfolio_items_callback');

function filter_portfolio_items_callback() {
    $cat_id = isset($_GET['cat_id']) ? sanitize_text_field($_GET['cat_id']) : 'all';
    $widget_id = isset($_GET['widget_id']) ? sanitize_text_field($_GET['widget_id']) : '';
    $elementor = \Elementor\Plugin::$instance->widgets_manager->get_widget_types()['portfolio_widget'] ?? null;

    if ($elementor && method_exists($elementor, 'render_portfolio_items')) {
        $elementor->render_portfolio_items($cat_id);
    }

    wp_die();
}

// AJAX: Search Modal
add_action('wp_ajax_mn_search_modal', 'mn_search_modal_ajax_callback');
add_action('wp_ajax_nopriv_mn_search_modal', 'mn_search_modal_ajax_callback');

function mn_search_modal_ajax_callback() {
    // Ensure the widget class is available
    if (!class_exists('Mohtavanegar_Search_Modal_Widget')) {
        $file_path = __DIR__ . '/search-modal-widget.php';
        if (file_exists($file_path)) {
            require_once $file_path;
        }
    }

    if (class_exists('Mohtavanegar_Search_Modal_Widget') && method_exists('Mohtavanegar_Search_Modal_Widget', 'ajax_search_handler')) {
        Mohtavanegar_Search_Modal_Widget::ajax_search_handler();
    } else {
        wp_send_json_error(['message' => 'Handler not found']);
    }
}