<?php
if (!defined('ABSPATH')) {
    exit;
}

class Mohtavanegar_QA_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'mohtavanegar_qa';
    }

    public function get_title() {
        return esc_html__('پرسش و پاسخ', 'mohtavanegar');
    }

    public function get_icon() {
        return 'eicon-comments';
    }

    public function get_categories() {
        return ['mohtavanegar'];
    }

    public function get_keywords() {
        return ['qa', 'question', 'answer', 'comment', 'mohtavanegar'];
    }

    public function get_style_depends() {
        wp_register_style(
            'qa-widget-style',
            get_template_directory_uri() . '/assets/css/qa-widget.css',
            array(),
            '1.0.0'
        );
        return ['qa-widget-style'];
    }

    private function get_services_options() {
        $options = [];
        
        $services = get_posts([
            'post_type' => 'services',
            'posts_per_page' => -1,
            'post_status' => 'publish',
            'orderby' => 'title',
            'order' => 'ASC'
        ]);
        
        foreach ($services as $service) {
            $options[$service->ID] = $service->post_title;
        }
        
        return $options;
    }

    protected function register_controls() {
        // Content Section
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('تنظیمات محتوا', 'mohtavanegar'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'show_form',
            [
                'label' => esc_html__('نمایش فرم ثبت نظر', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('بله', 'mohtavanegar'),
                'label_off' => esc_html__('خیر', 'mohtavanegar'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_comments',
            [
                'label' => esc_html__('نمایش لیست نظرات', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('بله', 'mohtavanegar'),
                'label_off' => esc_html__('خیر', 'mohtavanegar'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'comments_per_page',
            [
                'label' => esc_html__('تعداد نظرات در هر صفحه', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 100,
                'step' => 1,
                'default' => 5,
                'condition' => [
                    'show_comments' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'form_title',
            [
                'label' => esc_html__('عنوان فرم', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('ثبت پرسش جدید', 'mohtavanegar'),
                'condition' => [
                    'show_form' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'comments_title',
            [
                'label' => esc_html__('عنوان لیست نظرات', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('پرسش و پاسخ های کاربران', 'mohtavanegar'),
                'condition' => [
                    'show_comments' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'show_services_dropdown',
            [
                'label' => esc_html__('نمایش دراپ داون خدمات', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('بله', 'mohtavanegar'),
                'label_off' => esc_html__('خیر', 'mohtavanegar'),
                'return_value' => 'yes',
                'default' => '',
                'condition' => [
                    'show_form' => 'yes',
                ],
            ]
        );

        $this->end_controls_section();

        // Style Section - Form
        $this->start_controls_section(
            'form_style_section',
            [
                'label' => esc_html__('استایل فرم', 'mohtavanegar'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_form' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'form_title_color',
            [
                'label' => esc_html__('رنگ عنوان فرم', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .qa-form-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'form_title_typography',
                'label' => esc_html__('تایپوگرافی عنوان فرم', 'mohtavanegar'),
                'selector' => '{{WRAPPER}} .qa-form-title',
            ]
        );

        $this->add_control(
            'form_background_color',
            [
                'label' => esc_html__('رنگ پس زمینه فرم', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .qa-form-container' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'form_border',
                'label' => esc_html__('حاشیه فرم', 'mohtavanegar'),
                'selector' => '{{WRAPPER}} .qa-form-container',
            ]
        );

        $this->add_control(
            'form_border_radius',
            [
                'label' => esc_html__('گردی گوشه‌های فرم', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .qa-form-container' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'form_padding',
            [
                'label' => esc_html__('فاصله داخلی فرم', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .qa-form-container' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Comments Settings Section
        $this->start_controls_section(
            'comments_settings_section',
            [
                'label' => esc_html__('تنظیمات نظرات', 'mohtavanegar'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'show_comments' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'filter_by_service',
            [
                'label' => esc_html__('فیلتر بر اساس خدمت', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'all' => esc_html__('همه خدمات', 'mohtavanegar'),
                    'specific' => esc_html__('خدمت خاص', 'mohtavanegar'),
                ],
                'default' => 'all',
            ]
        );

        $this->add_control(
            'specific_service',
            [
                'label' => esc_html__('انتخاب خدمت', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'options' => $this->get_services_options(),
                'condition' => [
                    'filter_by_service' => 'specific',
                ],
                'multiple' => false,
            ]
        );

        $this->add_control(
            'posts_per_page',
            [
                'label' => esc_html__('تعداد نظرات در هر صفحه', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 50,
                'default' => 10,
            ]
        );

        $this->add_control(
            'enable_pagination',
            [
                'label' => esc_html__('فعال‌سازی صفحه‌بندی', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('بله', 'mohtavanegar'),
                'label_off' => esc_html__('خیر', 'mohtavanegar'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->end_controls_section();

        // Style Section - Comments
        $this->start_controls_section(
            'comments_style_section',
            [
                'label' => esc_html__('استایل نظرات', 'mohtavanegar'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_comments' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'comments_title_color',
            [
                'label' => esc_html__('رنگ عنوان لیست نظرات', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .qa-comments-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'comments_title_typography',
                'label' => esc_html__('تایپوگرافی عنوان لیست نظرات', 'mohtavanegar'),
                'selector' => '{{WRAPPER}} .qa-comments-title',
            ]
        );

        $this->add_control(
            'comment_background_color',
            [
                'label' => esc_html__('رنگ پس زمینه نظرات', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .qa-comment-item' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'question_color',
            [
                'label' => esc_html__('رنگ متن پرسش', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .qa-question' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'answer_color',
            [
                'label' => esc_html__('رنگ متن پاسخ', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .qa-answer' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'comment_border',
                'label' => esc_html__('حاشیه نظرات', 'mohtavanegar'),
                'selector' => '{{WRAPPER}} .qa-comment-item',
            ]
        );

        $this->add_control(
            'comment_border_radius',
            [
                'label' => esc_html__('گردی گوشه‌های نظرات', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .qa-comment-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'comment_padding',
            [
                'label' => esc_html__('فاصله داخلی نظرات', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .qa-comment-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'comment_margin',
            [
                'label' => esc_html__('فاصله بین نظرات', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .qa-comment-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'top' => '0',
                    'right' => '0',
                    'bottom' => '15',
                    'left' => '0',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
            ]
        );

        $this->end_controls_section();

        // Style Section - Button
        $this->start_controls_section(
            'button_style_section',
            [
                'label' => esc_html__('استایل دکمه', 'mohtavanegar'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_form' => 'yes',
                ],
            ]
        );

        $this->start_controls_tabs('button_style_tabs');

        $this->start_controls_tab(
            'button_normal_tab',
            [
                'label' => esc_html__('عادی', 'mohtavanegar'),
            ]
        );

        $this->add_control(
            'button_text_color',
            [
                'label' => esc_html__('رنگ متن دکمه', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .qa-submit-button' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'button_background_color',
            [
                'label' => esc_html__('رنگ پس زمینه دکمه', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .qa-submit-button' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'button_hover_tab',
            [
                'label' => esc_html__('هاور', 'mohtavanegar'),
            ]
        );

        $this->add_control(
            'button_hover_text_color',
            [
                'label' => esc_html__('رنگ متن دکمه (هاور)', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .qa-submit-button:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'button_hover_background_color',
            [
                'label' => esc_html__('رنگ پس زمینه دکمه (هاور)', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .qa-submit-button:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'button_border',
                'label' => esc_html__('حاشیه دکمه', 'mohtavanegar'),
                'selector' => '{{WRAPPER}} .qa-submit-button',
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'button_border_radius',
            [
                'label' => esc_html__('گردی گوشه‌های دکمه', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .qa-submit-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'button_padding',
            [
                'label' => esc_html__('فاصله داخلی دکمه', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .qa-submit-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $show_form = $settings['show_form'] === 'yes';
        $show_comments = $settings['show_comments'] === 'yes';
        $form_title = $settings['form_title'];
        $comments_title = $settings['comments_title'];
        
        // Get new settings
        $filter_by_service = $settings['filter_by_service'];
        $specific_service = $settings['specific_service'];
        $posts_per_page = $settings['posts_per_page'];
        $enable_pagination = $settings['enable_pagination'] === 'yes';
        
        // Pagination (support both WordPress paged and custom qa_page query arg)
        $paged = 1;
        if (isset($_GET['qa_page'])) {
            $paged = max(1, intval($_GET['qa_page']));
        } elseif (get_query_var('paged')) {
            $paged = max(1, intval(get_query_var('paged')));
        }
        if (!$enable_pagination) {
            $paged = 1;
        }
        
        // Enqueue the script for form submission and AJAX pagination
        $qa_frontend_js_path = get_template_directory() . '/js/qa-frontend.js';
        $qa_frontend_js_ver  = file_exists($qa_frontend_js_path) ? filemtime($qa_frontend_js_path) : '1.0.2';
        wp_enqueue_script(
            'qa-frontend-js',
            get_template_directory_uri() . '/js/qa-frontend.js',
            array('jquery'),
            $qa_frontend_js_ver,
            true
        );
        
        wp_localize_script('qa-frontend-js', 'qaFrontendData', array(
            'ajaxUrl' => admin_url('admin-ajax.php'),
            'nonce'   => wp_create_nonce('qa_submit_nonce')
        ));
        
        ?>
        <div class="mohtavanegar-qa-widget">
            <?php if ($show_form) : ?>
                <div class="qa-form-section">
                    <h3 class="qa-form-title"><?php echo esc_html($form_title); ?></h3>
                    
                    <div class="qa-message" id="qa-form-message"></div>
                    
                    <div class="qa-form-container">
                        <form id="qa-submission-form">
                            <div class="qa-form-group">
                                <label for="qa-name"><?php echo esc_html__('نام', 'mohtavanegar'); ?></label>
                                <input type="text" id="qa-name" name="qa-name" class="qa-form-control" required>
                            </div>
                            
                            <div class="qa-form-group">
                                <label for="qa-email"><?php echo esc_html__('ایمیل', 'mohtavanegar'); ?> <small>(اختیاری)</small></label>
                                <input type="email" id="qa-email" name="qa-email" class="qa-form-control">
                            </div>
                            
                            <div class="qa-form-group">
                                <label for="qa-mobile"><?php echo esc_html__('موبایل', 'mohtavanegar'); ?> <small>(اختیاری)</small></label>
                                <input type="tel" id="qa-mobile" name="qa-mobile" class="qa-form-control" placeholder="09xxxxxxxxx">
                            </div>

                            <?php if ($settings['show_services_dropdown'] === 'yes') : ?>
                            <div class="qa-form-group">
                                <label for="qa-service"><?php echo esc_html__('خدمت مورد نظر', 'mohtavanegar'); ?></label>
                                <select id="qa-service" name="qa-service" class="qa-form-control">
                                    <option value=""><?php echo esc_html__('انتخاب خدمت...', 'mohtavanegar'); ?></option>
                                    <?php
                                    $services = get_posts(array(
                                        'post_type' => 'services',
                                        'posts_per_page' => -1,
                                        'post_status' => 'publish',
                                        'orderby' => 'title',
                                        'order' => 'ASC'
                                    ));
                                    foreach ($services as $service) {
                                        echo '<option value="' . esc_attr($service->ID) . '">' . esc_html($service->post_title) . '</option>';
                                    }
                                    ?>
                                </select>
                            </div>
                            <?php endif; ?>
                            
                            <div class="qa-form-group">
                                <label for="qa-question"><?php echo esc_html__('پرسش شما', 'mohtavanegar'); ?></label>
                                <textarea id="qa-question" name="qa-question" class="qa-form-control" rows="4" required></textarea>
                            </div>
                            
                            <div class="qa-form-group">
                                <button type="submit" class="qa-submit-button"><?php echo esc_html__('ارسال پرسش', 'mohtavanegar'); ?></button>
                            </div>
                        </form>
                    </div>
                </div>
            <?php endif; ?>
            
            <?php if ($show_comments) : ?>
                <div class="qa-comments-section" id="qa-comments-<?php echo $this->get_id(); ?>">
                    <h3 class="qa-comments-title"><?php echo esc_html($comments_title); ?></h3>
                    <div class="qa-search-wrapper">
                        <input type="text" class="qa-search-input" id="qa-search-input-<?php echo $this->get_id(); ?>" placeholder="<?php echo esc_attr__('جستجو در پرسش و پاسخ...', 'mohtavanegar'); ?>" aria-label="<?php echo esc_attr__('جستجو در پرسش و پاسخ', 'mohtavanegar'); ?>">
                    </div>
                    <div class="qa-comments-container" id="qa-comments-container-<?php echo $this->get_id(); ?>"
                         data-widget-id="<?php echo esc_attr($this->get_id()); ?>"
                         data-settings='<?php echo esc_attr(wp_json_encode(array(
                             'filter_by_service' => $filter_by_service,
                             'specific_service'  => $specific_service,
                             'posts_per_page'    => $posts_per_page,
                             'enable_pagination' => $enable_pagination,
                             'comments_title'    => $comments_title,
                             'search'            => ''
                         ))); ?>'
                         data-filter-by-service="<?php echo esc_attr($filter_by_service); ?>"
                         data-specific-service="<?php echo esc_attr($specific_service); ?>"
                         data-posts-per-page="<?php echo esc_attr($posts_per_page); ?>"
                         data-enable-pagination="<?php echo esc_attr($enable_pagination ? '1' : '0'); ?>"
                         data-comments-title="<?php echo esc_attr($comments_title); ?>">
                        <?php
                        // Read search query from URL
                        $search_query = isset($_GET['qa_search']) ? sanitize_text_field(wp_unslash($_GET['qa_search'])) : '';

                        $args = array(
                            'post_type'      => 'qa_comment',
                            'post_status'    => 'publish',
                            'posts_per_page' => $posts_per_page,
                            'paged'          => $paged,
                            'orderby'        => 'date',
                            'order'          => 'DESC',
                        );
                        // Apply search on title and _qa_answer meta
                        if (!empty($search_query)) {
                            $args['s'] = $search_query;
                            $args['meta_query'] = isset($args['meta_query']) && is_array($args['meta_query']) ? $args['meta_query'] : array();
                            $args['meta_query'][] = array(
                                'relation' => 'OR',
                                array(
                                    'key'     => '_qa_answer',
                                    'value'   => $search_query,
                                    'compare' => 'LIKE',
                                ),
                            );
                        }

                        // Add service filter if specific service is selected
                        if ($filter_by_service === 'specific' && $specific_service) {
                            if (!isset($args['meta_query']) || !is_array($args['meta_query'])) {
                                $args['meta_query'] = array();
                            }
                            $args['meta_query'][] = array(
                                'key'     => '_qa_service',
                                'value'   => $specific_service,
                                'compare' => '=',
                            );
                        }
                        
                        $comments = new \WP_Query($args);
                        
                        if ($comments->have_posts()) :
                            // Enqueue the accordion script
                            wp_enqueue_script(
                                'qa-accordion-js',
                                get_template_directory_uri() . '/js/qa-accordion.js',
                                array('jquery'),
                                '1.0.0',
                                true
                            );
                            
                            echo '<div class="qa-accordion">';
                            
                            while ($comments->have_posts()) : $comments->the_post();
                                $name = get_post_meta(get_the_ID(), '_qa_name', true);
                                $question = get_the_title();
                                $answer = get_post_meta(get_the_ID(), '_qa_answer', true);
                                $date = get_the_date('Y-m-d');
                                ?>
                                <div class="qa-accordion-item">
                                    <div class="qa-accordion-header">
                                        <div class="qa-accordion-title"><?php echo esc_html($question); ?></div>
                                        <div class="qa-accordion-icon"></div>
                                    </div>
                                    
                                    <div class="qa-accordion-content">
                                        
                                        <div class="qa-accordion-question">
                                            <strong><?php echo esc_html__('پرسش:', 'mohtavanegar'); ?></strong>
                                            <?php echo esc_html($question); ?>
                                        </div>
                                        
                                        <?php if (!empty($answer)) : ?>
                                            <div class="qa-accordion-answer">
                                                <strong><?php echo esc_html__('پاسخ:', 'mohtavanegar'); ?></strong>
                                                <div class="qa-answer-content">
                                                    <?php echo wpautop(wp_kses_post($answer)); ?>
                                                </div>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <?php
                            endwhile;
                            
                            echo '</div>';
                            
                            // Pagination: traditional links with qa_page (preserve qa_search if present)
                            if ($enable_pagination && $comments->max_num_pages > 1) {
                                $total_pages = (int) $comments->max_num_pages;
                                $current     = max(1, (int) $paged);
                                echo '<div class="qa-pagination" id="qa-pagination-' . $this->get_id() . '">';
                                echo '<div class="qa-pagination-container">';
                                echo '<ul class="page-numbers">';

                                // Prev
                                if ($current > 1) {
                                    $prev_url = esc_url(add_query_arg(array('qa_page' => $current - 1, 'qa_search' => $search_query !== '' ? $search_query : null)));
                                    echo '<li><a href="' . $prev_url . '" class="prev page-numbers"><span class="pagination-arrow">‹</span> قبلی</a></li>';
                                }

                                // Page numbers
                                for ($i = 1; $i <= $total_pages; $i++) {
                                    if ($i === $current) {
                                        echo '<li><span class="page-numbers current"><span class="pagination-number">' . $i . '</span></span></li>';
                                    } else {
                                        $page_url = esc_url(add_query_arg(array('qa_page' => $i, 'qa_search' => $search_query !== '' ? $search_query : null)));
                                        echo '<li><a href="' . $page_url . '" class="page-numbers"><span class="pagination-number">' . $i . '</span></a></li>';
                                    }
                                }

                                // Next
                                if ($current < $total_pages) {
                                    $next_url = esc_url(add_query_arg(array('qa_page' => $current + 1, 'qa_search' => $search_query !== '' ? $search_query : null)));
                                    echo '<li><a href="' . $next_url . '" class="next page-numbers">بعدی <span class="pagination-arrow">›</span></a></li>';
                                }

                                echo '</ul>';
                                echo '</div>';
                                echo '</div>';
                            }
                            
                            wp_reset_postdata();
                        else :
                            echo '<div class="qa-no-comments">' . esc_html__('هیچ پرسش و پاسخی یافت نشد.', 'mohtavanegar') . '</div>';
                        endif;
                        ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>
        <?php
    }
}