<?php
if (!defined('ABSPATH')) { exit; }

class Mohtavanegar_Reviews_Form_Widget extends \Elementor\Widget_Base {
    public function get_name() { return 'mohtavanegar_reviews_form'; }
    public function get_title() { return esc_html__('فرم نظر بیماران', 'mohtavanegar'); }
    public function get_icon() { return 'eicon-form-horizontal'; }
    public function get_categories() { return ['mohtavanegar']; }

    public function get_style_depends() {
        if (!wp_style_is('reviews-form-widget', 'registered')) {
            wp_register_style(
                'reviews-form-widget',
                get_template_directory_uri() . '/assets/css/reviews-form-widget.css',
                [],
                '1.0.0'
            );
        }
        return ['reviews-form-widget'];
    }

    private function get_services_options() {
        $options = [];
        $services = get_posts([
            'post_type' => 'services',
            'posts_per_page' => -1,
            'post_status' => 'publish',
            'orderby' => 'title',
            'order' => 'ASC'
        ]);
        foreach ($services as $service) { $options[$service->ID] = $service->post_title; }
        return $options;
    }

    protected function register_controls() {
        $this->start_controls_section('content_section', [
            'label' => esc_html__('تنظیمات', 'mohtavanegar'),
            'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]);
        $this->add_control('form_title', [
            'label' => esc_html__('عنوان فرم', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__('ثبت نظر بیماران', 'mohtavanegar'),
        ]);
        $this->add_control('show_services_dropdown', [
            'label' => esc_html__('نمایش انتخاب خدمت', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::SWITCHER,
            'label_on' => esc_html__('بله', 'mohtavanegar'),
            'label_off' => esc_html__('خیر', 'mohtavanegar'),
            'return_value' => 'yes',
            'default' => 'yes',
        ]);
        $this->add_control('form_layout', [
            'label' => esc_html__('نحوه چینش ورودی‌ها', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::SELECT,
            'options' => [
                'stack' => esc_html__('زیر هم', 'mohtavanegar'),
                'grid' => esc_html__('شبکه‌ای', 'mohtavanegar'),
            ],
            'default' => 'stack',
        ]);
        $this->end_controls_section();

        // Inputs typography
        $this->start_controls_section('inputs_style_section', [
            'label' => esc_html__('ورودی‌ها', 'mohtavanegar'),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]);
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'inputs_typography',
                'label' => esc_html__('تایپوگرافی ورودی‌ها', 'mohtavanegar'),
                'selector' => '{{WRAPPER}} .mohtavanegar-reviews-form-widget .reviews-form-control',
            ]
        );
        $this->end_controls_section();

        // Button styles
        $this->start_controls_section('button_style_section', [
            'label' => esc_html__('دکمه ارسال', 'mohtavanegar'),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]);
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'button_typography',
                'label' => esc_html__('تایپوگرافی دکمه', 'mohtavanegar'),
                'selector' => '{{WRAPPER}} .mohtavanegar-reviews-form-widget .reviews-submit-button',
            ]
        );
        $this->start_controls_tabs('button_style_tabs');
        $this->start_controls_tab('button_normal_tab', [ 'label' => esc_html__('عادی', 'mohtavanegar') ]);
        $this->add_control('button_text_color', [
            'label' => esc_html__('رنگ متن', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .mohtavanegar-reviews-form-widget .reviews-submit-button' => 'color: {{VALUE}};',
            ],
        ]);
        $this->add_control('button_background_color', [
            'label' => esc_html__('رنگ پس‌زمینه', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .mohtavanegar-reviews-form-widget .reviews-submit-button' => 'background-color: {{VALUE}};',
            ],
        ]);
        $this->end_controls_tab();
        $this->start_controls_tab('button_hover_tab', [ 'label' => esc_html__('هاور', 'mohtavanegar') ]);
        $this->add_control('button_hover_text_color', [
            'label' => esc_html__('رنگ متن (هاور)', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .mohtavanegar-reviews-form-widget .reviews-submit-button:hover' => 'color: {{VALUE}};',
            ],
        ]);
        $this->add_control('button_hover_background_color', [
            'label' => esc_html__('رنگ پس‌زمینه (هاور)', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .mohtavanegar-reviews-form-widget .reviews-submit-button:hover' => 'background-color: {{VALUE}};',
            ],
        ]);
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        // Style controls
        $this->start_controls_section('style_section', [
            'label' => esc_html__('استایل', 'mohtavanegar'),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]);
        $this->add_control('form_background', [
            'label' => esc_html__('رنگ پس‌زمینه', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .mohtavanegar-reviews-form-widget .reviews-form-container' => 'background-color: {{VALUE}};',
            ],
        ]);
        $this->add_responsive_control('inputs_gap', [
            'label' => esc_html__('فاصله بین ورودی‌ها', 'mohtavanegar'),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => ['px', 'em'],
            'range' => [
                'px' => ['min' => 0, 'max' => 48],
                'em' => ['min' => 0, 'max' => 3],
            ],
            'default' => ['size' => 12, 'unit' => 'px'],
            'selectors' => [
                '{{WRAPPER}} .mohtavanegar-reviews-form-widget .reviews-form-container' => '--reviews-input-gap: {{SIZE}}{{UNIT}};',
            ],
        ]);
        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $form_title = $settings['form_title'];

        // Enqueue frontend script
        wp_enqueue_script(
            'reviews-frontend-js',
            get_template_directory_uri() . '/js/reviews-frontend.js',
            ['jquery'],
            file_exists(get_template_directory() . '/js/reviews-frontend.js') ? filemtime(get_template_directory() . '/js/reviews-frontend.js') : '1.0.0',
            true
        );
        wp_localize_script('reviews-frontend-js', 'reviewsFrontendData', [
            'ajaxUrl' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('reviews_submit_nonce'),
            'i18n_success' => esc_html__('نظر شما ثبت شد و پس از تایید نمایش داده می‌شود.', 'mohtavanegar'),
            'i18n_error' => esc_html__('خطا در ثبت نظر. دوباره تلاش کنید.', 'mohtavanegar'),
        ]);
        $layout = isset($settings['form_layout']) ? $settings['form_layout'] : 'stack';
        $layout_class = $layout === 'grid' ? 'layout-grid' : 'layout-stack';
        ?>
        <div class="mohtavanegar-reviews-form-widget">
            <h3 class="reviews-form-title"><?php echo esc_html($form_title); ?></h3>
            <div class="reviews-message" id="reviews-form-message"></div>
            <div class="reviews-form-container <?php echo esc_attr($layout_class); ?>">
            <form id="reviews-submission-form">
                <div class="reviews-form-group">
                    <label for="review-name"><?php echo esc_html__('نام و نام خانوادگی', 'mohtavanegar'); ?></label>
                    <input type="text" id="review-name" name="review-name" class="reviews-form-control" required>
                </div>
                <?php if ($settings['show_services_dropdown'] === 'yes') : ?>
                <div class="reviews-form-group">
                    <label for="review-service"><?php echo esc_html__('نوع خدمت', 'mohtavanegar'); ?></label>
                    <select id="review-service" name="review-service" class="reviews-form-control">
                        <option value=""><?php echo esc_html__('انتخاب خدمت...', 'mohtavanegar'); ?></option>
                        <?php foreach ($this->get_services_options() as $id => $title) { echo '<option value="' . esc_attr($id) . '">' . esc_html($title) . '</option>'; } ?>
                    </select>
                </div>
                <?php endif; ?>
                <div class="reviews-form-group">
                    <label><?php echo esc_html__('امتیاز', 'mohtavanegar'); ?></label>
                    <div class="reviews-stars" role="radiogroup" aria-label="rating">
                        <?php
                        // render 5 to 1 so first star is 5
                        for ($i = 5; $i >= 1; $i--) :
                            $input_id = 'rating-' . esc_attr($this->get_id()) . '-' . $i;
                            ?>
                            <input class="review-star-input" type="radio" id="<?php echo $input_id; ?>" name="review-rating" value="<?php echo $i; ?>" data-value="<?php echo $i; ?>" <?php echo $i===5 ? 'checked' : ''; ?>>
                            <label class="review-star-label" for="<?php echo $input_id; ?>" data-value="<?php echo $i; ?>">★</label>
                        <?php endfor; ?>
                    </div>
                </div>
                <div class="reviews-form-group">
                    <label for="review-text"><?php echo esc_html__('متن نظر', 'mohtavanegar'); ?></label>
                    <textarea id="review-text" name="review-text" class="reviews-form-control" rows="4" required></textarea>
                </div>
                <div class="reviews-form-group">
                    <button type="submit" class="reviews-submit-button"><?php echo esc_html__('ارسال نظر', 'mohtavanegar'); ?></button>
                </div>
            </form>
            </div>
        </div>
        <?php
    }
}
