<?php
if (!defined('ABSPATH')) {
    exit;
}

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;

class Mohtavanegar_Services_List_02_Widget extends Widget_Base {
    public function get_name() {
        return 'mohtavanegar_services_list_02';
    }

    public function get_title() {
        return __('لیست خدمات 02', 'mohtavanegar');
    }

    public function get_icon() {
        return 'eicon-posts-grid';
    }

    public function get_categories() {
        return ['mohtavanegar'];
    }

    public function get_style_depends() {
        return ['services-list-02-widget'];
    }

    protected function register_controls() {
        $this->start_controls_section('content_section', [
            'label' => __('تنظیمات محتوا', 'mohtavanegar'),
            'tab' => Controls_Manager::TAB_CONTENT,
        ]);

        // Source selector
        $this->add_control('source_type', [
            'label' => __('منبع داده', 'mohtavanegar'),
            'type' => Controls_Manager::SELECT,
            'options' => [
                'post' => __('پست‌ها (services)', 'mohtavanegar'),
                'taxonomy' => __('دسته‌بندی‌ها', 'mohtavanegar'),
            ],
            'default' => 'post',
        ]);

        $this->add_control('posts_per_page', [
            'label' => __('تعداد خدمات', 'mohtavanegar'),
            'type' => Controls_Manager::NUMBER,
            'min' => 1,
            'max' => 100,
            'step' => 1,
            'default' => 6,
            'condition' => [ 'source_type' => 'post' ],
        ]);

        $this->add_responsive_control('columns', [
            'label' => __('تعداد ستون‌ها', 'mohtavanegar'),
            'type' => Controls_Manager::SELECT,
            'default' => '6',
            'tablet_default' => '4',
            'mobile_default' => '2',
            'options' => [
                '1' => '1', '2' => '2', '3' => '3', '4' => '4', '5' => '5', '6' => '6'
            ],
            'selectors' => [
                '{{WRAPPER}} .services02-grid' => 'grid-template-columns: repeat({{VALUE}}, minmax(0,1fr));',
            ],
        ]);

        // Grid gap control
        $this->add_responsive_control('grid_gap', [
            'label' => __('فاصله بین آیتم‌ها (Gap)', 'mohtavanegar'),
            'type' => Controls_Manager::SLIDER,
            'size_units' => ['px', 'em', 'rem'],
            'range' => [ 'px' => ['min' => 0, 'max' => 60], 'em' => ['min' => 0, 'max' => 4, 'step' => 0.1], 'rem' => ['min' => 0, 'max' => 4, 'step' => 0.1] ],
            'default' => ['size' => 16, 'unit' => 'px'],
            'selectors' => [
                '{{WRAPPER}} .services02-grid' => 'gap: {{SIZE}}{{UNIT}};',
            ],
        ]);

        $this->add_control('category', [
            'label' => __('دسته‌بندی', 'mohtavanegar'),
            'type' => Controls_Manager::SELECT2,
            'options' => $this->get_services_categories(),
            'multiple' => true,
            'condition' => [ 'source_type' => 'post' ],
        ]);

        $this->add_control('orderby', [
            'label' => __('مرتب‌سازی', 'mohtavanegar'),
            'type' => Controls_Manager::SELECT,
            'default' => 'date',
            'options' => [
                'date' => __('تاریخ', 'mohtavanegar'),
                'title' => __('عنوان', 'mohtavanegar'),
                'menu_order' => __('ترتیب منو', 'mohtavanegar'),
            ],
            'condition' => [ 'source_type' => 'post' ],
        ]);

        $this->add_control('order', [
            'label' => __('ترتیب', 'mohtavanegar'),
            'type' => Controls_Manager::SELECT,
            'default' => 'DESC',
            'options' => [ 'ASC' => __('صعودی','mohtavanegar'), 'DESC' => __('نزولی','mohtavanegar') ],
            'condition' => [ 'source_type' => 'post' ],
        ]);

        // Taxonomy source controls
        $this->add_control('taxonomy_name', [
            'label' => __('نوع دسته‌بندی', 'mohtavanegar'),
            'type' => Controls_Manager::SELECT,
            'options' => [
                'services_category' => __('دسته بندی خدمات', 'mohtavanegar'),
            ],
            'default' => 'services_category',
            'condition' => [ 'source_type' => 'taxonomy' ],
        ]);

        $this->add_control('include_terms', [
            'label' => __('انتخاب دسته‌ها', 'mohtavanegar'),
            'type' => Controls_Manager::SELECT2,
            'options' => $this->get_all_terms_for_select('services_category'),
            'multiple' => true,
            'label_block' => true,
            'condition' => [ 'source_type' => 'taxonomy' ],
        ]);

        $this->end_controls_section();

        $this->start_controls_section('style_section', [
            'label' => __('استایل', 'mohtavanegar'),
            'tab' => Controls_Manager::TAB_STYLE,
        ]);

        // Alignment control (default center)
        $this->add_responsive_control('item_align', [
            'label' => __('چیدمان محتوا', 'mohtavanegar'),
            'type' => Controls_Manager::CHOOSE,
            'options' => [
                'flex-start' => [ 'title' => __('چپ/راست', 'mohtavanegar'), 'icon' => 'eicon-text-align-right' ],
                'center' => [ 'title' => __('وسط', 'mohtavanegar'), 'icon' => 'eicon-text-align-center' ],
                'flex-end' => [ 'title' => __('چپ/راست مقابل', 'mohtavanegar'), 'icon' => 'eicon-text-align-left' ],
            ],
            'default' => 'center',
            'selectors' => [
                '{{WRAPPER}} .service02-card' => 'align-items: {{VALUE}}; text-align: {{VALUE}};',
            ],
        ]);

        // Icon size
        $this->add_responsive_control('icon_size', [
            'label' => __('سایز آیکون', 'mohtavanegar'),
            'type' => Controls_Manager::SLIDER,
            'size_units' => ['px'],
            'range' => [ 'px' => ['min' => 16, 'max' => 128] ],
            'default' => ['size' => 42, 'unit' => 'px'],
            'selectors' => [
                '{{WRAPPER}} .services02-icon img' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                '{{WRAPPER}} .services02-icon-fallback' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}}; font-size: calc({{SIZE}}{{UNIT}} * 0.48);',
            ],
        ]);

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typo',
                'selector' => '{{WRAPPER}} .service02-title',
            ]
        );

        // Title colors
        $this->add_control('title_color', [
            'label' => __('رنگ عنوان', 'mohtavanegar'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service02-title' => 'color: {{VALUE}};',
            ],
        ]);
        $this->add_control('title_color_hover', [
            'label' => __('رنگ عنوان (هاور)', 'mohtavanegar'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service02-card:hover .service02-title' => 'color: {{VALUE}};',
            ],
        ]);

        $this->add_control('item_radius', [
            'label' => __('گردی گوشه‌ها', 'mohtavanegar'),
            'type' => Controls_Manager::SLIDER,
            'size_units' => ['px', '%'],
            'range' => [ 'px' => ['min' => 0, 'max' => 40] ],
            'default' => ['size' => 16, 'unit' => 'px'],
            'selectors' => [
                '{{WRAPPER}} .service02-card' => 'border-radius: {{SIZE}}{{UNIT}};',
            ],
        ]);

        // Normal/Hover tabs for box appearance
        $this->start_controls_tabs('tabs_item_style');

        // Normal tab
        $this->start_controls_tab('tab_item_normal', [
            'label' => __('معمولی', 'mohtavanegar'),
        ]);

        $this->add_control('item_bg', [
            'label' => __('پس‌زمینه', 'mohtavanegar'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service02-card' => 'background-color: {{VALUE}};',
            ],
        ]);

        $this->add_responsive_control('item_padding', [
            'label' => __('Padding', 'mohtavanegar'),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => ['px', 'em', '%'],
            'selectors' => [
                '{{WRAPPER}} .service02-card' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]);

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'selector' => '{{WRAPPER}} .service02-card',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_shadow',
                'selector' => '{{WRAPPER}} .service02-card',
            ]
        );

        $this->end_controls_tab();

        // Hover tab
        $this->start_controls_tab('tab_item_hover', [
            'label' => __('هاور', 'mohtavanegar'),
        ]);

        $this->add_control('item_bg_hover', [
            'label' => __('پس‌زمینه (هاور)', 'mohtavanegar'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .service02-card:hover' => 'background-color: {{VALUE}};',
            ],
        ]);

        $this->add_responsive_control('item_padding_hover', [
            'label' => __('Padding (هاور)', 'mohtavanegar'),
            'type' => Controls_Manager::DIMENSIONS,
            'size_units' => ['px', 'em', '%'],
            'selectors' => [
                '{{WRAPPER}} .service02-card:hover' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
        ]);

        $this->add_control('item_radius_hover', [
            'label' => __('گردی گوشه‌ها (هاور)', 'mohtavanegar'),
            'type' => Controls_Manager::SLIDER,
            'size_units' => ['px', '%'],
            'range' => [ 'px' => ['min' => 0, 'max' => 40] ],
            'selectors' => [
                '{{WRAPPER}} .service02-card:hover' => 'border-radius: {{SIZE}}{{UNIT}};',
            ],
        ]);

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'item_border_hover',
                'selector' => '{{WRAPPER}} .service02-card:hover',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_shadow_hover',
                'selector' => '{{WRAPPER}} .service02-card:hover',
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        // Hover lift
        $this->add_responsive_control('hover_lift', [
            'label' => __('جابجایی عمودی در هاور', 'mohtavanegar'),
            'type' => Controls_Manager::SLIDER,
            'size_units' => ['px'],
            'range' => [ 'px' => ['min' => 0, 'max' => 20] ],
            'default' => ['size' => 2, 'unit' => 'px'],
            'selectors' => [
                '{{WRAPPER}} .service02-card:hover' => 'transform: translateY(-{{SIZE}}{{UNIT}});',
            ],
        ]);

        // Transition controls (duration & easing)
        $this->add_control('transition_duration_ms', [
            'label' => __('زمان ترنزیشن (میلی‌ثانیه)', 'mohtavanegar'),
            'type' => Controls_Manager::NUMBER,
            'min' => 0,
            'max' => 2000,
            'step' => 10,
            'default' => 300,
            'selectors' => [
                '{{WRAPPER}} .service02-card' => '--mn-tr-dur: {{VALUE}}ms; transition-duration: {{VALUE}}ms;',
            ],
        ]);

        $this->add_control('transition_easing', [
            'label' => __('نمودار حرکت (easing)', 'mohtavanegar'),
            'type' => Controls_Manager::SELECT,
            'default' => 'ease-out',
            'options' => [
                'linear' => 'linear',
                'ease' => 'ease',
                'ease-in' => 'ease-in',
                'ease-out' => 'ease-out',
                'ease-in-out' => 'ease-in-out',
                'cubic-bezier(0.4,0,0.2,1)' => 'material (0.4,0,0.2,1)',
            ],
            'selectors' => [
                '{{WRAPPER}} .service02-card' => '--mn-tr-ease: {{VALUE}}; transition-timing-function: {{VALUE}};',
            ],
        ]);

        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();

        $this->add_render_attribute('grid', 'class', 'services02-grid');
        echo '<div ' . $this->get_render_attribute_string('grid') . '>';

        if (($s['source_type'] ?? 'post') === 'taxonomy') {
            $tax = $s['taxonomy_name'] ?? 'services_category';
            $term_args = [
                'taxonomy' => $tax,
                'hide_empty' => false,
            ];
            if (!empty($s['include_terms'])) {
                $term_args['include'] = $s['include_terms'];
                $term_args['orderby'] = 'include';
            }
            $terms = get_terms($term_args);
            if (!is_wp_error($terms)) {
                foreach ($terms as $term) {
                    $classes = 'service02-card';
                    echo '<a class="' . esc_attr($classes) . '" href="' . esc_url(get_term_link($term)) . '">';
                    echo '<span class="services02-icon">';
                    $icon_id = get_term_meta($term->term_id, 'taxonomy_icon', true);
                    if ($icon_id) {
                        echo wp_get_attachment_image($icon_id, 'thumbnail', false, ['loading' => 'lazy']);
                    } else {
                        echo '<span class="services02-icon-fallback">+</span>';
                    }
                    echo '</span>';
                    echo '<span class="service02-title">' . esc_html($term->name) . '</span>';
                    echo '</a>';
                }
            }
        } else {
            $args = [
                'post_type' => 'services',
                'posts_per_page' => $s['posts_per_page'] ?? 6,
                'orderby' => $s['orderby'] ?? 'date',
                'order' => $s['order'] ?? 'DESC',
            ];
            if (!empty($s['category'])) {
                $args['tax_query'] = [[
                    'taxonomy' => 'services_category',
                    'field' => 'term_id',
                    'terms' => $s['category'],
                ]];
            }
            $q = new \WP_Query($args);
            if ($q->have_posts()) {
                while ($q->have_posts()) { $q->the_post();
                    $classes = 'service02-card';
                    echo '<a class="' . esc_attr($classes) . '" href="' . esc_url(get_permalink()) . '">';
                    echo '<span class="services02-icon">';
                    if (has_post_thumbnail()) {
                        echo get_the_post_thumbnail(get_the_ID(), 'thumbnail', ['loading' => 'lazy']);
                    } else {
                        echo '<span class="services02-icon-fallback">+</span>';
                    }
                    echo '</span>';
                    echo '<span class="service02-title">' . esc_html(get_the_title()) . '</span>';
                    echo '</a>';
                }
                wp_reset_postdata();
            }
        }

        echo '</div>';
    }

    private function get_services_categories() {
        $terms = get_terms([
            'taxonomy' => 'services_category',
            'hide_empty' => false,
        ]);
        $options = [];
        if (!is_wp_error($terms)) {
            foreach ($terms as $t) { $options[$t->term_id] = $t->name; }
        }
        return $options;
    }

    // Helper for taxonomy term select
    private function get_all_terms_for_select($taxonomy = 'services_category') {
        $terms = get_terms([
            'taxonomy' => $taxonomy,
            'hide_empty' => false,
        ]);
        $options = [];
        if (!is_wp_error($terms)) {
            foreach ($terms as $t) { $options[$t->term_id] = $t->name; }
        }
        return $options;
    }
}
