# Mohtavanegar WordPress Theme

A custom WordPress theme with Elementor support, designed specifically for medical/healthcare service providers.

## Overview

Mohtavanegar Theme is a specialized WordPress theme developed for healthcare professionals and medical service providers. It features custom taxonomy for services categorization, optimized performance, and seamless integration with Elementor page builder.

## Features

- **Elementor Integration**: Full compatibility with Elementor page builder
- **Custom Services Post Type**: Dedicated post type for medical services with categorization
- **Taxonomy Icons**: Support for visual icons in service categories
- **Performance Optimized**: Includes critical CSS loading, resource hints, and script optimization
- **Responsive Design**: Mobile-friendly layout for all devices
- **RTL Support**: Full right-to-left language support for Persian/Farsi content
- **WooCommerce Compatible**: Optional e-commerce functionality when WooCommerce is active

## Requirements

- WordPress 5.0 or higher
- PHP 7.2 or higher
- Elementor plugin (recommended)
- WooCommerce plugin (optional)

## Installation

1. Upload the theme folder to the `/wp-content/themes/` directory
2. Activate the theme through the 'Themes' menu in WordPress
3. Install and activate recommended plugins when prompted

## Theme Structure

```
mohtavanegar-theme/
├── assets/            # Theme assets (images, fonts)
├── css/               # CSS files including critical CSS
├── js/                # JavaScript files
├── settings/          # Theme settings and custom post types
├── template-parts/    # Reusable template components
├── widgets/           # Custom Elementor widgets
├── footer.php         # Footer template
├── functions.php      # Theme functions and setup
├── header.php         # Header template
├── index.php          # Main template file
├── style.css          # Main stylesheet
└── taxonomy-services_category.php  # Custom taxonomy template for services
```

## Customization

The theme includes several customization options accessible through:

1. **WordPress Customizer**: Go to Appearance > Customize
2. **Theme Settings**: Available in the admin dashboard
3. **Elementor Editor**: For page-specific layouts and designs

## Custom Post Types and Taxonomies

- **Services**: Custom post type for medical services
- **Services Category**: Taxonomy for categorizing services with icon support

## Performance Optimization

The theme includes several performance optimizations:

- Critical CSS loading
- Asynchronous script loading
- Resource hints (preconnect, dns-prefetch)
- Conditional asset loading

## Credits

- Developed by: [Mohtavanegar](https://mohtavanegar.com)
- Theme URI: https://mohtavanegar.com

## License

GNU General Public License v2 or later - http://www.gnu.org/licenses/gpl-2.0.html
