    </div><!-- #content -->

    <?php
    // Check if we're on a single post/page and if footer should be hidden or custom
    $hide_footer = false;
    $custom_footer_template = '';

    if (is_singular()) {
        $post_id = get_queried_object_id();
        $hide_footer = get_post_meta($post_id, '_mohtavanegar_hide_footer', true);
        $custom_footer_template = get_post_meta($post_id, '_mohtavanegar_custom_footer_template', true);
    }

    // If footer is not hidden, display it
    if (!$hide_footer) {
        // If we have a custom footer template, load it
        if (!empty($custom_footer_template) && class_exists('\Elementor\Plugin')) {
            $elementor = \Elementor\Plugin::instance();
            echo $elementor->frontend->get_builder_content_for_display($custom_footer_template);
        } else {
            // Otherwise, load default footer
            ?>
            <footer id="colophon" class="site-footer">
                <?php mohtavanegar_load_footer_template(); ?>
            </footer>
            <?php
        }
    }
    ?>

</div><!-- #page -->

<?php wp_footer(); ?>

</body>
</html>