(function($){
  function intOrDefault(v, d){ v = parseInt(v, 10); return isNaN(v) ? d : v; }
  function initRelatedPostsSwiper($root){
    var rtl = (window.RelatedPostsSliderVars && !!RelatedPostsSliderVars.rtl) || $('html').attr('dir') === 'rtl';
    var $swiper = $root.find('.related-posts-swiper');
    var el = $swiper[0];
    if(!el) return;
    var d = intOrDefault($swiper.data('slides-desktop'), 3);
    var t = intOrDefault($swiper.data('slides-tablet'), 2);
    var m = intOrDefault($swiper.data('slides-mobile'), 1);
    var autoplayEnabled = String($swiper.data('autoplay')) === '1';
    var delay = intOrDefault($swiper.data('delay'), 3500);
    var speed = intOrDefault($swiper.data('speed'), 600);
    var arrows = String($swiper.data('arrows')) === '1';
    var pagination = String($swiper.data('pagination')) === '1';

    // eslint-disable-next-line no-undef
    new Swiper(el, {
      slidesPerView: d,
      spaceBetween: 16,
      loop: true,
      rtl: rtl,
      speed: speed,
      autoplay: autoplayEnabled ? { delay: delay, disableOnInteraction: false } : false,
      pagination: pagination ? { el: $root.find('.swiper-pagination')[0], clickable: true } : undefined,
      navigation: arrows ? { nextEl: $root.find('.swiper-button-next')[0], prevEl: $root.find('.swiper-button-prev')[0] } : undefined,
      breakpoints: {
        0: { slidesPerView: m },
        768: { slidesPerView: t },
        1024: { slidesPerView: d }
      }
    });
  }
  $(document).ready(function(){
    $('.mohtavanegar-related-posts-slider').each(function(){ initRelatedPostsSwiper($(this)); });
  });
})(jQuery);
