jQuery(document).ready(function($) {
    // Initialize media uploader
    var mediaUploader;

    // Handle upload button click
    $(document).on('click', '#upload_taxonomy_icon', function(e) {
        e.preventDefault();
        
        // If the uploader object has already been created, reopen the dialog
        if (mediaUploader) {
            mediaUploader.open();
            return;
        }

        // Create a new media uploader
        mediaUploader = wp.media({
            title: 'انتخاب آیکون',
            button: {
                text: 'انتخاب'
            },
            multiple: false
        });

        // When a file is selected, set it as the value of the hidden input
        mediaUploader.on('select', function() {
            var attachment = mediaUploader.state().get('selection').first().toJSON();
            $('#taxonomy_icon').val(attachment.id);
            $('#taxonomy_icon_preview').html(attachment.url);
            $('#remove_taxonomy_icon').show();
        });

        // Open the uploader dialog
        mediaUploader.open();
    });

    // Handle remove button click
    $(document).on('click', '#remove_taxonomy_icon', function(e) {
        e.preventDefault();
        $('#taxonomy_icon').val('');
        $('#taxonomy_icon_preview').html('<p>آیکونی انتخاب نشده است</p>');
        $(this).hide();
    });
});
