<?php
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Import/Export System for Theme
 * 
 * This file handles the import and export functionality for:
 * - Posts + Categories
 * - Pages
 * - Services + Categories
 * - Menus
 * - Theme Settings
 * - Elementor Templates
 * - Media
 */

// Add admin menu for import/export
function mohtavanegar_add_import_export_menu() {
    add_submenu_page(
        'theme-settings',
        'درون‌ریزی/برون‌ریزی',
        'درون‌ریزی/برون‌ریزی',
        'manage_options',
        'theme-import-export',
        'mohtavanegar_import_export_page'
    );
}
add_action('admin_menu', 'mohtavanegar_add_import_export_menu');

// Enqueue scripts and styles for the import/export page
function mohtavanegar_import_export_assets($hook) {
    // Only load on our specific admin page
    /*
    if ($hook !== 'theme-import-export') {
        return;
    }*/

    wp_enqueue_style(
        'mohtavanegar-import-export-style',
        get_template_directory_uri() . '/settings/css/import-export.css',
        array(),
        '1.0.0'
    );

    wp_enqueue_script(
        'mohtavanegar-import-export-script',
        get_template_directory_uri() . '/settings/js/import-export.js',
        array('jquery'),
        '1.0.0',
        true
    );

    wp_localize_script(
        'mohtavanegar-import-export-script',
        'mohtavanegarImportExport',
        array(
            'ajaxurl' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('mohtavanegar_import_export_nonce'),
            'export_text' => __('در حال برون‌ریزی...', 'mohtavanegar'),
            'import_text' => __('در حال درون‌ریزی...', 'mohtavanegar'),
            'complete_text' => __('تکمیل شد!', 'mohtavanegar'),
            'error_text' => __('خطا رخ داد!', 'mohtavanegar')
        )
    );
}
add_action('admin_enqueue_scripts', 'mohtavanegar_import_export_assets');

// Import/Export Page Content
function mohtavanegar_import_export_page() {
    if (!current_user_can('manage_options')) {
        return;
    }
    ?>
    <div class="wrap mohtavanegar-import-export-wrap">
        <h1><?php _e('درون‌ریزی/برون‌ریزی قالب', 'mohtavanegar'); ?></h1>
        
        <div class="mohtavanegar-tabs">
            <div class="mohtavanegar-tab active" data-tab="export"><?php _e('برون‌ریزی', 'mohtavanegar'); ?></div>
            <div class="mohtavanegar-tab" data-tab="import"><?php _e('درون‌ریزی', 'mohtavanegar'); ?></div>
        </div>
        
        <div class="mohtavanegar-tab-content active" id="export-tab">
            <div class="mohtavanegar-card">
                <h2><?php _e('برون‌ریزی محتوا', 'mohtavanegar'); ?></h2>
                <p><?php _e('انتخاب کنید که چه بخش‌هایی از سایت را می‌خواهید برون‌ریزی کنید:', 'mohtavanegar'); ?></p>
                
                <form id="mohtavanegar-export-form" method="post" onsubmit="return false;">
                    <div class="export-options">
                        <label>
                            <input type="checkbox" name="export_items[]" value="posts" checked>
                            <?php _e('نوشته‌ها + دسته‌بندی‌ها', 'mohtavanegar'); ?>
                        </label>
                        
                        <label>
                            <input type="checkbox" name="export_items[]" value="pages" checked>
                            <?php _e('برگه‌ها', 'mohtavanegar'); ?>
                        </label>
                        
                        <label>
                            <input type="checkbox" name="export_items[]" value="services" checked>
                            <?php _e('خدمات + دسته‌بندی‌ها', 'mohtavanegar'); ?>
                        </label>
                        
                        <label>
                            <input type="checkbox" name="export_items[]" value="menus" checked>
                            <?php _e('منوها', 'mohtavanegar'); ?>
                        </label>
                        
                        <label>
                            <input type="checkbox" name="export_items[]" value="theme_settings" checked>
                            <?php _e('تنظیمات قالب', 'mohtavanegar'); ?>
                        </label>
                        
                        <label>
                            <input type="checkbox" name="export_items[]" value="elementor_templates" checked>
                            <?php _e('قالب‌های المنتور', 'mohtavanegar'); ?>
                        </label>
                        
                        <label>
                            <input type="checkbox" name="export_items[]" value="media" checked>
                            <?php _e('رسانه‌ها', 'mohtavanegar'); ?>
                        </label>
                    </div>
                    
                    <div class="export-progress-container">
                        <div class="export-progress">
                            <div class="export-progress-bar"></div>
                        </div>
                        <div class="export-progress-text"></div>
                    </div>
                    
                    <div class="export-actions">
                        <button type="button" id="export-button" class="button button-primary"><?php _e('برون‌ریزی', 'mohtavanegar'); ?></button>
                    </div>
                </form>
            </div>
        </div>
        
        <div class="mohtavanegar-tab-content" id="import-tab">
            <div class="mohtavanegar-card">
                <h2><?php _e('درون‌ریزی محتوا', 'mohtavanegar'); ?></h2>
                <p><?php _e('فایل زیپ برون‌ریزی شده را انتخاب کنید:', 'mohtavanegar'); ?></p>
                
                <form id="mohtavanegar-import-form" method="post" enctype="multipart/form-data" onsubmit="return false;">
                    <div class="import-file">
                        <input type="file" name="import_file" id="import_file" accept=".zip">
                    </div>
                    
                    <div class="import-options">
                        <h3><?php _e('گزینه‌های درون‌ریزی', 'mohtavanegar'); ?></h3>
                        
                        <label>
                            <input type="checkbox" name="import_items[]" value="posts" checked>
                            <?php _e('نوشته‌ها + دسته‌بندی‌ها', 'mohtavanegar'); ?>
                        </label>
                        
                        <label>
                            <input type="checkbox" name="import_items[]" value="pages" checked>
                            <?php _e('برگه‌ها', 'mohtavanegar'); ?>
                        </label>
                        
                        <label>
                            <input type="checkbox" name="import_items[]" value="services" checked>
                            <?php _e('خدمات + دسته‌بندی‌ها', 'mohtavanegar'); ?>
                        </label>
                        
                        <label>
                            <input type="checkbox" name="import_items[]" value="menus" checked>
                            <?php _e('منوها', 'mohtavanegar'); ?>
                        </label>
                        
                        <label>
                            <input type="checkbox" name="import_items[]" value="theme_settings" checked>
                            <?php _e('تنظیمات قالب', 'mohtavanegar'); ?>
                        </label>
                        
                        <label>
                            <input type="checkbox" name="import_items[]" value="elementor_templates" checked>
                            <?php _e('قالب‌های المنتور', 'mohtavanegar'); ?>
                        </label>
                        
                        <label>
                            <input type="checkbox" name="import_items[]" value="media" checked>
                            <?php _e('رسانه‌ها', 'mohtavanegar'); ?>
                        </label>
                    </div>
                    
                    <div class="import-progress-container">
                        <div class="import-progress">
                            <div class="import-progress-bar"></div>
                        </div>
                        <div class="import-progress-text"></div>
                    </div>
                    
                    <div class="import-actions">
                        <button type="button" id="import-button" class="button button-primary"><?php _e('درون‌ریزی', 'mohtavanegar'); ?></button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <?php
}

// Include all import/export modules
require_once get_template_directory() . '/settings/import-export/elementor-data-processor.php';
require_once get_template_directory() . '/settings/import-export/posts.php';
require_once get_template_directory() . '/settings/import-export/pages.php';
require_once get_template_directory() . '/settings/import-export/services.php';
require_once get_template_directory() . '/settings/import-export/menu-fix.php';
require_once get_template_directory() . '/settings/import-export/menus.php';
require_once get_template_directory() . '/settings/import-export/theme-settings.php';
require_once get_template_directory() . '/settings/import-export/elementor-templates.php';
require_once get_template_directory() . '/settings/import-export/media.php';
require_once get_template_directory() . '/settings/import-export/export-handler.php';
require_once get_template_directory() . '/settings/import-export/import-handler.php';
