<?php
function mohtavanegar_service_settings_page() {
    $defaults = array(
        'service_button_color' => '#0073aa',
        'service_button_text_color' => '#ffffff',
        'category_icon_bg' => '#f5f5f5',
        'subcategory_image_width' => 300,
        'subcategory_image_height' => 200,
        'show_view_button' => 'on',
        'show_description' => 'on',
        'subcategory_columns' => 3
    );
    $service_settings = wp_parse_args(get_option('service_settings', array()), $defaults);
    ?>
    <h2><?php _e('تنظیمات خدمات', 'mohtavanegar'); ?></h2>
    <table class="form-table">
        <tr>
            <th scope="row"><?php _e('رنگ دکمه خدمات', 'mohtavanegar'); ?></th>
            <td>
                <input type="text" name="service_settings[service_button_color]" value="<?php echo esc_attr($service_settings['service_button_color']); ?>" class="color-field" data-default-color="#0073aa" />
                <p class="description"><?php _e('رنگ دکمه خدمات را انتخاب کنید.', 'mohtavanegar'); ?></p>
            </td>
        </tr>
        <tr>
            <th scope="row"><?php _e('رنگ متن دکمه خدمات', 'mohtavanegar'); ?></th>
            <td>
                <input type="text" name="service_settings[service_button_text_color]" value="<?php echo esc_attr($service_settings['service_button_text_color']); ?>" class="color-field" data-default-color="#ffffff" />
                <p class="description"><?php _e('رنگ متن دکمه خدمات را انتخاب کنید.', 'mohtavanegar'); ?></p>
            </td>
        </tr>
        <tr>
            <th scope="row"><?php _e('رنگ پس‌زمینه آیکون دسته‌بندی', 'mohtavanegar'); ?></th>
            <td>
                <input type="text" name="service_settings[category_icon_bg]" value="<?php echo esc_attr($service_settings['category_icon_bg']); ?>" class="color-field" data-default-color="#f5f5f5" />
                <p class="description"><?php _e('رنگ پس‌زمینه آیکون دسته‌بندی را انتخاب کنید.', 'mohtavanegar'); ?></p>
            </td>
        </tr>
        <tr>
            <th scope="row"><?php _e('اندازه تصویر زیرشاخه‌ها', 'mohtavanegar'); ?></th>
            <td>
                <label><?php _e('عرض (پیکسل):', 'mohtavanegar'); ?> 
                    <input type="number" name="service_settings[subcategory_image_width]" value="<?php echo esc_attr($service_settings['subcategory_image_width']); ?>" min="100" max="1200" step="10" style="width: 80px;" />
                </label>
                <label style="margin-right: 20px;">
                    <?php _e('ارتفاع (پیکسل):', 'mohtavanegar'); ?> 
                    <input type="number" name="service_settings[subcategory_image_height]" value="<?php echo esc_attr($service_settings['subcategory_image_height']); ?>" min="100" max="1200" step="10" style="width: 80px;" />
                </label>
            </td>
        </tr>
        <tr>
            <th scope="row"><?php _e('نمایش توضیحات', 'mohtavanegar'); ?></th>
            <td>
                <label>
                    <input type="checkbox" name="service_settings[show_description]" <?php checked($service_settings['show_description'], 'on'); ?> />
                    <?php _e('نمایش توضیحات در کارت‌های خدمات', 'mohtavanegar'); ?>
                </label>
            </td>
        </tr>
        <tr>
            <th scope="row"><?php _e('نمایش دکمه مشاهده جزئیات', 'mohtavanegar'); ?></th>
            <td>
                <label>
                    <input type="checkbox" name="service_settings[show_view_button]" <?php checked($service_settings['show_view_button'], 'on'); ?> />
                    <?php _e('نمایش دکمه "مشاهده جزئیات" در کارت‌های خدمات', 'mohtavanegar'); ?>
                </label>
            </td>
        </tr>
        <tr>
            <th scope="row"><?php _e('تعداد ستون‌های زیرشاخه‌ها', 'mohtavanegar'); ?></th>
            <td>
                <select name="service_settings[subcategory_columns]">
                    <?php for ($i = 1; $i <= 6; $i++): ?>
                        <option value="<?php echo $i; ?>" <?php selected($service_settings['subcategory_columns'], $i); ?>><?php echo $i; ?> ستونه</option>
                    <?php endfor; ?>
                </select>
                <p class="description"><?php _e('تعداد ستون‌های نمایش زیرشاخه‌ها را انتخاب کنید', 'mohtavanegar'); ?></p>
            </td>
        </tr>
    </table>
    <script>
    jQuery(document).ready(function($){
        $('.color-field').wpColorPicker();
    });
    </script>
    <?php
} 