<?php
if (!defined('ABSPATH')) {
    exit;
}

// Check if Elementor is active
function mohtavanegar_is_elementor_active() {
    return did_action('elementor/loaded');
}

// Get Elementor template
function mohtavanegar_get_elementor_template($template_id) {
    if (!$template_id) {
        return '';
    }
    
    if (class_exists('\Elementor\Plugin')) {
        $elementor = \Elementor\Plugin::instance();
        return $elementor->frontend->get_builder_content_for_display($template_id);
    }
    
    return '';
}

// Load Single Post Template
function mohtavanegar_single_post_template($template) {
    if (is_single() && !(class_exists('WooCommerce') && is_product())) {
        $single_post_template_id = get_option('single_post_template');
        if ($single_post_template_id) {
            return get_page_template();
        }
    }
    return $template;
}
add_filter('single_template', 'mohtavanegar_single_post_template');

// Load Single Product Template
function mohtavanegar_single_product_template($template) {
    if (class_exists('WooCommerce') && is_product()) {
        $single_product_template_id = get_option('single_product_template');
        if ($single_product_template_id) {
            return get_page_template();
        }
    }
    return $template;
}
add_filter('single_template', 'mohtavanegar_single_product_template');

// Add Theme Builder Support
function mohtavanegar_theme_builder_support() {
    if (!mohtavanegar_is_elementor_active()) {
        return;
    }

    // Register Theme Builder Locations
    add_action('elementor/theme/register_locations', function($elementor_theme_manager) {
        $elementor_theme_manager->register_location('header');
        $elementor_theme_manager->register_location('footer');
        $elementor_theme_manager->register_location('single');
        $elementor_theme_manager->register_location('archive');
    });

    // Add Theme Builder Support
    add_action('elementor/init', function() {
        add_theme_support('elementor');
        add_theme_support('elementor-pro');
    });
}
add_action('after_setup_theme', 'mohtavanegar_theme_builder_support');

// Add Theme Builder Locations
function mohtavanegar_theme_builder_locations($elementor_theme_manager) {
    if (!mohtavanegar_is_elementor_active()) {
        return;
    }

    $elementor_theme_manager->register_location('header');
    $elementor_theme_manager->register_location('footer');
    $elementor_theme_manager->register_location('single');
    $elementor_theme_manager->register_location('archive');
}
add_action('elementor/theme/register_locations', 'mohtavanegar_theme_builder_locations'); 