<?php
if (!defined('ABSPATH')) {
    exit;
}

// Register typography settings
function mohtavanegar_register_typography_settings() {
    register_setting('mohtavanegar_typography', 'typography_settings');
}
add_action('admin_init', 'mohtavanegar_register_typography_settings');

// Get Elementor Global Fonts
function mohtavanegar_get_elementor_fonts() {
    if (!class_exists('\Elementor\Plugin')) {
        return array();
    }

    $kit = \Elementor\Plugin::$instance->kits_manager->get_active_kit();
    if (!$kit) {
        return array();
    }

    $kit_settings = $kit->get_settings();
    $system_typography = $kit_settings['system_typography'] ?? array();
    
    $fonts = array(
        'primary' => array(
            'title' => 'Primary',
            'font_family' => '',
            'font_weight' => ''
        ),
        'secondary' => array(
            'title' => 'Secondary',
            'font_family' => '',
            'font_weight' => ''
        ),
        'text' => array(
            'title' => 'Text',
            'font_family' => '',
            'font_weight' => ''
        ),
        'accent' => array(
            'title' => 'Accent',
            'font_family' => '',
            'font_weight' => ''
        )
    );

    if (!empty($system_typography)) {
        foreach ($system_typography as $typography) {
            if (isset($typography['_id'])) {
                switch ($typography['_id']) {
                    case 'primary':
                        $fonts['primary'] = array(
                            'title' => 'Primary',
                            'font_family' => $typography['typography_font_family'] ?? '',
                            'font_weight' => $typography['typography_font_weight'] ?? ''
                        );
                        break;
                    case 'secondary':
                        $fonts['secondary'] = array(
                            'title' => 'Secondary',
                            'font_family' => $typography['typography_font_family'] ?? '',
                            'font_weight' => $typography['typography_font_weight'] ?? ''
                        );
                        break;
                    case 'text':
                        $fonts['text'] = array(
                            'title' => 'Text',
                            'font_family' => $typography['typography_font_family'] ?? '',
                            'font_weight' => $typography['typography_font_weight'] ?? ''
                        );
                        break;
                    case 'accent':
                        $fonts['accent'] = array(
                            'title' => 'Accent',
                            'font_family' => $typography['typography_font_family'] ?? '',
                            'font_weight' => $typography['typography_font_weight'] ?? ''
                        );
                        break;
                }
            }
        }
    }

    return $fonts;
}


// Get available fonts from Elementor
// Get available fonts from Elementor
function mohtavanegar_get_available_fonts() {
    if (!class_exists('\Elementor\Plugin')) {
        return mohtavanegar_get_default_fonts();
    }

    try {
        // Try to get Elementor's default fonts
        $fonts = array();
        
        // Add system fonts - these are always available
        $system_fonts = array(
            'Arial' => 'Arial',
            'Tahoma' => 'Tahoma',
            'Verdana' => 'Verdana',
            'Helvetica' => 'Helvetica',
            'Times New Roman' => 'Times New Roman',
            'Georgia' => 'Georgia',
            'Vazirmatn' => 'Vazirmatn',
            'IRANSansX' => 'IRANSansX',
            'Yekan' => 'Yekan'
        );
        
        $fonts = array_merge($fonts, $system_fonts);
        
        // Try to get the list of Google fonts - this is more reliable if possible
        if (class_exists('\Elementor\Fonts') && method_exists('\Elementor\Fonts', 'get_google_fonts')) {
            $google_fonts = \Elementor\Fonts::get_google_fonts();
            if (is_array($google_fonts)) {
                foreach ($google_fonts as $font_name => $font_props) {
                    $fonts[$font_name] = $font_name;
                }
            }
        } else {
            // Add popular Google Fonts if we can't get the full list
            $popular_google_fonts = array(
                'Roboto' => 'Roboto',
                'Open Sans' => 'Open Sans',
                'Lato' => 'Lato',
                'Montserrat' => 'Montserrat',
                'Oswald' => 'Oswald',
                'Source Sans Pro' => 'Source Sans Pro',
                'Raleway' => 'Raleway',
                'Vazirmatn' => 'Vazirmatn',
                'IRANSansX' => 'IRANSansX'
            );
            
            $fonts = array_merge($fonts, $popular_google_fonts);
        }
        
        // Sort fonts alphabetically
        ksort($fonts);
    } catch (\Exception $e) {
        // If something goes wrong, return default fonts
        return mohtavanegar_get_default_fonts();
    }

    return $fonts;
}

// Helper function to get default fonts
function mohtavanegar_get_default_fonts() {
    return array(
        'Arial' => 'Arial',
        'Tahoma' => 'Tahoma',
        'Vazirmatn' => 'Vazirmatn',
        'IRANSansX' => 'IRANSansX',
        'Yekan' => 'Yekan',
        'Roboto' => 'Roboto',
        'Open Sans' => 'Open Sans',
        'Montserrat' => 'Montserrat'
    );
}

// Update Elementor Global Fonts
function mohtavanegar_update_elementor_fonts($new_settings) {
    if (!class_exists('\Elementor\Plugin')) {
        return false;
    }

    try {
        // Get active kit
        $kit = \Elementor\Plugin::$instance->kits_manager->get_active_kit();
        if (!$kit) {
            error_log('Elementor active kit not found');
            return false;
        }

        // Get current settings
        $current_settings = $kit->get_settings();
        
        // Update typography settings
        $system_typography = array(
            array(
                '_id' => 'primary',
                'title' => 'Primary',
                'typography_typography' => 'custom',
                'typography_font_family' => $new_settings['primary_font'] ?? '',
                'typography_font_weight' => $new_settings['primary_font_weight'] ?? '400',
                'typography_font_size' => array(
                    'unit' => 'px',
                    'size' => '',
                    'sizes' => array()
                ),
                'typography_text_transform' => '',
                'typography_font_style' => '',
                'typography_text_decoration' => '',
                'typography_line_height' => array(
                    'unit' => 'px',
                    'size' => '',
                    'sizes' => array()
                ),
                'typography_letter_spacing' => array(
                    'unit' => 'px',
                    'size' => '',
                    'sizes' => array()
                ),
                'typography_word_spacing' => array(
                    'unit' => 'px',
                    'size' => '',
                    'sizes' => array()
                )
            ),
            array(
                '_id' => 'secondary',
                'title' => 'Secondary',
                'typography_typography' => 'custom',
                'typography_font_family' => $new_settings['secondary_font'] ?? '',
                'typography_font_weight' => $new_settings['secondary_font_weight'] ?? '400',
                'typography_font_size' => array(
                    'unit' => 'px',
                    'size' => '',
                    'sizes' => array()
                ),
                'typography_text_transform' => '',
                'typography_font_style' => '',
                'typography_text_decoration' => '',
                'typography_line_height' => array(
                    'unit' => 'px',
                    'size' => '',
                    'sizes' => array()
                ),
                'typography_letter_spacing' => array(
                    'unit' => 'px',
                    'size' => '',
                    'sizes' => array()
                ),
                'typography_word_spacing' => array(
                    'unit' => 'px',
                    'size' => '',
                    'sizes' => array()
                )
            ),
            array(
                '_id' => 'text',
                'title' => 'Text',
                'typography_typography' => 'custom',
                'typography_font_family' => $new_settings['text_font'] ?? '',
                'typography_font_weight' => $new_settings['text_font_weight'] ?? '400',
                'typography_font_size' => array(
                    'unit' => 'px',
                    'size' => '',
                    'sizes' => array()
                ),
                'typography_text_transform' => '',
                'typography_font_style' => '',
                'typography_text_decoration' => '',
                'typography_line_height' => array(
                    'unit' => 'px',
                    'size' => '',
                    'sizes' => array()
                ),
                'typography_letter_spacing' => array(
                    'unit' => 'px',
                    'size' => '',
                    'sizes' => array()
                ),
                'typography_word_spacing' => array(
                    'unit' => 'px',
                    'size' => '',
                    'sizes' => array()
                )
            ),
            array(
                '_id' => 'accent',
                'title' => 'Accent',
                'typography_typography' => 'custom',
                'typography_font_family' => $new_settings['accent_font'] ?? '',
                'typography_font_weight' => $new_settings['accent_font_weight'] ?? '400',
                'typography_font_size' => array(
                    'unit' => 'px',
                    'size' => '',
                    'sizes' => array()
                ),
                'typography_text_transform' => '',
                'typography_font_style' => '',
                'typography_text_decoration' => '',
                'typography_line_height' => array(
                    'unit' => 'px',
                    'size' => '',
                    'sizes' => array()
                ),
                'typography_letter_spacing' => array(
                    'unit' => 'px',
                    'size' => '',
                    'sizes' => array()
                ),
                'typography_word_spacing' => array(
                    'unit' => 'px',
                    'size' => '',
                    'sizes' => array()
                )
            )
        );

        // Update current settings with new typography
        $current_settings['system_typography'] = $system_typography;

        // Get Document instance
        $document = \Elementor\Plugin::$instance->documents->get($kit->get_id());
        
        // Save settings using Document
        $document->save([
            'settings' => $current_settings
        ]);

        // Clear Elementor cache
        \Elementor\Plugin::$instance->files_manager->clear_cache();

        // Force Elementor to reload its data
        \Elementor\Plugin::$instance->kits_manager->clear_cache();

        // Clear WordPress cache
        wp_cache_flush();

        return true;
    } catch (\Exception $e) {
        error_log('Error updating Elementor fonts: ' . $e->getMessage());
        return false;
    }
}

// Typography Settings Page Content
function mohtavanegar_typography_settings_page() {
    $current_settings = get_option('typography_settings', array());
    $elementor_fonts = mohtavanegar_get_elementor_fonts();
    $available_fonts = mohtavanegar_get_available_fonts();
    ?>
    <h2><?php _e('تایپوگرافی', 'mohtavanegar'); ?></h2>
    <table class="form-table">
        <tr>
            <th scope="row"><?php _e('فونت اصلی', 'mohtavanegar'); ?></th>
            <td>
                <select name="typography_settings[primary_font]" id="primary_font">
                    <option value=""><?php _e('انتخاب فونت اصلی', 'mohtavanegar'); ?></option>
                    <?php foreach ($available_fonts as $font_family): ?>
                        <option value="<?php echo esc_attr($font_family); ?>" <?php selected($current_settings['primary_font'] ?? $elementor_fonts['primary']['font_family'], $font_family); ?>><?php echo esc_html($font_family); ?></option>
                    <?php endforeach; ?>
                </select>
                <select name="typography_settings[primary_font_weight]" id="primary_font_weight">
                    <option value="300" <?php selected($current_settings['primary_font_weight'] ?? $elementor_fonts['primary']['font_weight'], '300'); ?>><?php _e('نازک', 'mohtavanegar'); ?></option>
                    <option value="400" <?php selected($current_settings['primary_font_weight'] ?? $elementor_fonts['primary']['font_weight'], '400'); ?>><?php _e('معمولی', 'mohtavanegar'); ?></option>
                    <option value="500" <?php selected($current_settings['primary_font_weight'] ?? $elementor_fonts['primary']['font_weight'], '500'); ?>><?php _e('متوسط', 'mohtavanegar'); ?></option>
                    <option value="700" <?php selected($current_settings['primary_font_weight'] ?? $elementor_fonts['primary']['font_weight'], '700'); ?>><?php _e('ضخیم', 'mohtavanegar'); ?></option>
                </select>
            </td>
        </tr>
        <tr>
            <th scope="row"><?php _e('فونت ثانویه', 'mohtavanegar'); ?></th>
            <td>
                <select name="typography_settings[secondary_font]" id="secondary_font">
                    <option value=""><?php _e('انتخاب فونت ثانویه', 'mohtavanegar'); ?></option>
                    <?php foreach ($available_fonts as $font_family): ?>
                        <option value="<?php echo esc_attr($font_family); ?>" <?php selected($current_settings['secondary_font'] ?? $elementor_fonts['secondary']['font_family'], $font_family); ?>><?php echo esc_html($font_family); ?></option>
                    <?php endforeach; ?>
                </select>
                <select name="typography_settings[secondary_font_weight]" id="secondary_font_weight">
                    <option value="300" <?php selected($current_settings['secondary_font_weight'] ?? $elementor_fonts['secondary']['font_weight'], '300'); ?>><?php _e('نازک', 'mohtavanegar'); ?></option>
                    <option value="400" <?php selected($current_settings['secondary_font_weight'] ?? $elementor_fonts['secondary']['font_weight'], '400'); ?>><?php _e('معمولی', 'mohtavanegar'); ?></option>
                    <option value="500" <?php selected($current_settings['secondary_font_weight'] ?? $elementor_fonts['secondary']['font_weight'], '500'); ?>><?php _e('متوسط', 'mohtavanegar'); ?></option>
                    <option value="700" <?php selected($current_settings['secondary_font_weight'] ?? $elementor_fonts['secondary']['font_weight'], '700'); ?>><?php _e('ضخیم', 'mohtavanegar'); ?></option>
                </select>
            </td>
        </tr>
        <tr>
            <th scope="row"><?php _e('فونت متن', 'mohtavanegar'); ?></th>
            <td>
                <select name="typography_settings[text_font]" id="text_font">
                    <option value=""><?php _e('انتخاب فونت متن', 'mohtavanegar'); ?></option>
                    <?php foreach ($available_fonts as $font_family): ?>
                        <option value="<?php echo esc_attr($font_family); ?>" <?php selected($current_settings['text_font'] ?? $elementor_fonts['text']['font_family'], $font_family); ?>><?php echo esc_html($font_family); ?></option>
                    <?php endforeach; ?>
                </select>
                <select name="typography_settings[text_font_weight]" id="text_font_weight">
                    <option value="300" <?php selected($current_settings['text_font_weight'] ?? $elementor_fonts['text']['font_weight'], '300'); ?>><?php _e('نازک', 'mohtavanegar'); ?></option>
                    <option value="400" <?php selected($current_settings['text_font_weight'] ?? $elementor_fonts['text']['font_weight'], '400'); ?>><?php _e('معمولی', 'mohtavanegar'); ?></option>
                    <option value="500" <?php selected($current_settings['text_font_weight'] ?? $elementor_fonts['text']['font_weight'], '500'); ?>><?php _e('متوسط', 'mohtavanegar'); ?></option>
                    <option value="700" <?php selected($current_settings['text_font_weight'] ?? $elementor_fonts['text']['font_weight'], '700'); ?>><?php _e('ضخیم', 'mohtavanegar'); ?></option>
                </select>
            </td>
        </tr>
        <tr>
            <th scope="row"><?php _e('فونت تاکیدی', 'mohtavanegar'); ?></th>
            <td>
                <select name="typography_settings[accent_font]" id="accent_font">
                    <option value=""><?php _e('انتخاب فونت تاکیدی', 'mohtavanegar'); ?></option>
                    <?php foreach ($available_fonts as $font_family): ?>
                        <option value="<?php echo esc_attr($font_family); ?>" <?php selected($current_settings['accent_font'] ?? $elementor_fonts['accent']['font_family'], $font_family); ?>><?php echo esc_html($font_family); ?></option>
                    <?php endforeach; ?>
                </select>
                <select name="typography_settings[accent_font_weight]" id="accent_font_weight">
                    <option value="300" <?php selected($current_settings['accent_font_weight'] ?? $elementor_fonts['accent']['font_weight'], '300'); ?>><?php _e('نازک', 'mohtavanegar'); ?></option>
                    <option value="400" <?php selected($current_settings['accent_font_weight'] ?? $elementor_fonts['accent']['font_weight'], '400'); ?>><?php _e('معمولی', 'mohtavanegar'); ?></option>
                    <option value="500" <?php selected($current_settings['accent_font_weight'] ?? $elementor_fonts['accent']['font_weight'], '500'); ?>><?php _e('متوسط', 'mohtavanegar'); ?></option>
                    <option value="700" <?php selected($current_settings['accent_font_weight'] ?? $elementor_fonts['accent']['font_weight'], '700'); ?>><?php _e('ضخیم', 'mohtavanegar'); ?></option>
                </select>
            </td>
        </tr>
    </table>
    <?php
} 