<?php
/**
 * Language URL Shortcode
 * Adds current language prefix to URLs
 * 
 * Usage: [lang_url url="https://example.com/page/"]
 */
function lang_url_shortcode($atts) {
    // Parse shortcode attributes
    $atts = shortcode_atts(
        array(
            'url' => '',  // The URL to process
        ),
        $atts,
        'lang_url'
    );

    // If no URL provided, return empty
    if (empty($atts['url'])) {
        return '';
    }

    // Get the current language code (e.g., 'ar', 'en', etc.)
    $lang = function_exists('pll_current_language') ? pll_current_language('slug') : '';
    
    // If we're on the default language or no language is set, return the URL as is
    if (empty($lang) || $lang === pll_default_language('slug')) {
        return esc_url($atts['url']);
    }

    // Parse the URL
    $url_parts = parse_url($atts['url']);
    $site_url = site_url();
    $site_url_parts = parse_url($site_url);
    
    // Check if the URL is from the same site
    $same_site = ($url_parts['host'] ?? '') === ($site_url_parts['host'] ?? '');
    
    if ($same_site) {
        $path = $url_parts['path'] ?? '';
        $site_path = $site_url_parts['path'] ?? '';
        
        // Remove site path from URL path if present
        if (!empty($site_path) && strpos($path, $site_path) === 0) {
            $path = substr($path, strlen($site_path));
        }
        
        // Check if URL already has a language prefix
        $lang_prefix = '/' . $lang . '/';
        if (strpos($path, $lang_prefix) !== 0) {
            // Add language prefix to the path
            $new_path = $lang_prefix . ltrim($path, '/');
            $url_parts['path'] = $site_path . $new_path;
            
            // Rebuild the URL
            $scheme = $url_parts['scheme'] ?? 'https';
            $host = $url_parts['host'] ?? '';
            $path = $url_parts['path'] ?? '';
            $query = isset($url_parts['query']) ? '?' . $url_parts['query'] : '';
            $fragment = isset($url_parts['fragment']) ? '#' . $url_parts['fragment'] : '';
            
            return esc_url($scheme . '://' . $host . $path . $query . $fragment);
        }
    }
    
    // Return the original URL if no changes were made
    return esc_url($atts['url']);
}
add_shortcode('lang_url', 'lang_url_shortcode');