<?php
/**
 * The template for displaying single posts
 *
 * @package StandAloneProject
 */

get_header();

if ( ! ( function_exists( 'elementor_theme_do_location' ) && elementor_theme_do_location( 'single' ) ) ) : ?>

<main id="primary" class="site">
    <div class="container py-4">
        <div class="row g-4">
            <div class="col-lg-8 col-12">
                <?php
                while (have_posts()) :
                    the_post();
                    ?>

                    <article id="post-<?php the_ID(); ?>" <?php post_class('single-post'); ?>>
                        <header class="entry-header">
                            <?php
                            if (has_post_thumbnail()) :
                                echo '<div class="post-thumbnail mb-4">';
                                the_post_thumbnail('full', array('class' => 'img-fluid rounded'));
                                echo '</div>';
                            endif;
                            
                            the_title('<h1 class="entry-title mb-3">', '</h1>');
                            
                            if ('post' === get_post_type()) :
                                ?>
                                <div class="entry-meta mb-4">
                                    <?php
                                    echo '<span class="posted-on me-3"><i class="far fa-calendar-alt me-1"></i> ' . get_the_date() . '</span>';
                                    echo '<span class="byline me-3"><i class="far fa-user me-1"></i> ' . get_the_author() . '</span>';
                                    
                                    $categories_list = get_the_category_list(esc_html__(', ', 'stand-alone-project'));
                                    if ($categories_list) {
                                        echo '<span class="cat-links"><i class="far fa-folder me-1"></i> ' . $categories_list . '</span>';
                                    }
                                    ?>
                                </div>
                            <?php endif; ?>
                        </header>

                        <div class="entry-content">
                            <?php
                            the_content();
                            
                            wp_link_pages(
                                array(
                                    'before' => '<div class="page-links">' . esc_html__('Pages:', 'stand-alone-project'),
                                    'after'  => '</div>',
                                )
                            );
                            ?>
                        </div>


                        <footer class="entry-footer mt-4 pt-3 border-top">
                            <?php
                            $tags_list = get_the_tag_list('', ', ');
                            if ($tags_list) {
                                echo '<div class="tags-links mb-3">';
                                echo '<span class="me-2"><i class="fas fa-tags me-1"></i> ' . esc_html__('برچسب‌ها:', 'stand-alone-project') . '</span>';
                                echo $tags_list;
                                echo '</div>';
                            }
                            ?>
                        </footer>
                    </article>

                    <?php
                    // Related Posts
                    $related_posts = new WP_Query(
                        array(
                            'category__in' => wp_get_post_categories(get_the_ID()),
                            'posts_per_page' => 3,
                            'post__not_in' => array(get_the_ID()),
                            'orderby' => 'rand'
                        )
                    );

                    if ($related_posts->have_posts()) :
                        ?>
                        <div class="related-posts mt-5">
                            <h3 class="related-posts-title"><?php esc_html_e('مطالب مرتبط', 'stand-alone-project'); ?></h3>
                            <div class="elementor-grid">
                                <?php
                                while ($related_posts->have_posts()) :
                                    $related_posts->the_post();
                                    ?>
                                    <div class="elementor-grid-item">
                                        <div class="elementor-post">
                                            <?php if (has_post_thumbnail()) : ?>
                                                <a class="elementor-post__thumbnail" href="<?php the_permalink(); ?>">
                                                    <?php the_post_thumbnail('medium', array('class' => 'elementor-post__thumbnail-img')); ?>
                                                </a>
                                            <?php endif; ?>
                                            <div class="elementor-post__content">
                                                <h4 class="elementor-post__title">
                                                    <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                                </h4>
                                                <div class="elementor-post__meta">
                                                    <span class="elementor-post-date"><?php echo get_the_date(); ?></span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php
                                endwhile;
                                wp_reset_postdata();
                                ?>
                            </div>
                        </div>
                    <?php
                    endif;

                    // If comments are open or we have at least one comment, load up the comment template.
                    if (comments_open() || get_comments_number()) :
                        comments_template();
                    endif;

                endwhile; // End of the loop.
                ?>
            </div>
            
            
        </div>
    </div>
</main>

<?php endif; ?>

<?php
get_footer();
