<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class Appointment_Websites_Widget extends \Elementor\Widget_Base {
    
    public function get_name() {
        return 'appointment_websites_widget';
    }

    public function get_title() {
        return __('سایت‌های نوبت‌دهی', 'textdomain');
    }

    public function get_icon() {
        return 'eicon-calendar';
    }

    public function get_categories() {
        return ['mohtavanegar'];
    }

    public function get_script_depends() {
        return ['appointment-websites-widget'];
    }

    public function get_style_depends() {
        return ['appointment-websites-widget'];
    }

    protected function _register_controls() {
        // Content Tab
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('محتوا', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'website_image',
            [
                'label' => __('آیکون/تصویر', 'textdomain'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_group_control(
            \Elementor\Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'exclude' => ['custom'],
                'include' => [],
                'default' => 'medium',
            ]
        );

        $repeater->add_control(
            'website_title',
            [
                'label' => __('عنوان', 'textdomain'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('عنوان سایت', 'textdomain'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'website_link',
            [
                'label' => __('لینک', 'textdomain'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('https://example.com', 'textdomain'),
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );

        $this->add_control(
            'websites',
            [
                'label' => __('سایت‌های نوبت‌دهی', 'textdomain'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'website_title' => __('نوبت دهی اینترنتی', 'textdomain'),
                    ],
                    [
                        'website_title' => __('نوبت دهی تلفنی', 'textdomain'),
                    ],
                ],
                'title_field' => '{{{ website_title }}}',
            ]
        );

        $this->add_control(
            'view',
            [
                'label' => __('حالت نمایش', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'grid',
                'options' => [
                    'list' => __('لیستی', 'textdomain'),
                    'grid' => __('شبکه‌ای', 'textdomain'),
                ],
                'prefix_class' => 'elementor-view-',
            ]
        );

        $this->add_responsive_control(
            'columns',
            [
                'label' => __('تعداد ستون‌ها', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '3',
                'tablet_default' => '2',
                'mobile_default' => '1',
                'options' => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    '6' => '6',
                ],
                'selectors' => [
                    '{{WRAPPER}}.elementor-view-grid .appointment-container' => 'grid-template-columns: repeat({{VALUE}}, 1fr);',
                ],
                'condition' => [
                    'view' => 'grid',
                ],
            ]
        );

        $this->end_controls_section();

        // Style Tab
        $this->start_controls_section(
            'style_section',
            [
                'label' => __('استایل‌ها', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'item_height',
            [
                'label' => __('ارتفاع کارت‌ها', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'vh'],
                'range' => [
                    'px' => [
                        'min' => 100,
                        'max' => 1000,
                    ],
                    'vh' => [
                        'min' => 10,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .appointment-item' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'item_style_heading',
            [
                'label' => __('استایل کارت‌ها', 'textdomain'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->start_controls_tabs('item_style_tabs');

        $this->start_controls_tab(
            'item_normal_tab',
            [
                'label' => __('عادی', 'textdomain'),
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'item_background',
                'label' => __('پس‌زمینه', 'textdomain'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .appointment-item',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_box_shadow',
                'label' => __('سایه', 'textdomain'),
                'selector' => '{{WRAPPER}} .appointment-item',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'item_hover_tab',
            [
                'label' => __('هاور', 'textdomain'),
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'item_hover_background',
                'label' => __('پس‌زمینه در هاور', 'textdomain'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .appointment-item:hover',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_hover_box_shadow',
                'label' => __('سایه در هاور', 'textdomain'),
                'selector' => '{{WRAPPER}} .appointment-item:hover',
            ]
        );

        $this->add_control(
            'hover_animation',
            [
                'label' => __('انیمیشن هاور', 'textdomain'),
                'type' => \Elementor\Controls_Manager::HOVER_ANIMATION,
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'label' => __('حاشیه', 'textdomain'),
                'selector' => '{{WRAPPER}} .appointment-item',
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'item_border_radius',
            [
                'label' => __('گردی گوشه‌ها', 'textdomain'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .appointment-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'item_padding',
            [
                'label' => __('فاصله داخلی', 'textdomain'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .appointment-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'item_margin',
            [
                'label' => __('فاصله خارجی', 'textdomain'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .appointment-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        // Image Style
        $this->add_control(
            'image_style_heading',
            [
                'label' => __('استایل تصویر', 'textdomain'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'image_size',
            [
                'label' => __('اندازه تصویر', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 300,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .appointment-image img' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'image_border_radius',
            [
                'label' => __('گردی گوشه‌های تصویر', 'textdomain'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .appointment-image img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'image_box_shadow',
                'label' => __('سایه تصویر', 'textdomain'),
                'selector' => '{{WRAPPER}} .appointment-image img',
            ]
        );

        $this->add_responsive_control(
            'image_margin_bottom',
            [
                'label' => __('فاصله تصویر از متن', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .appointment-image' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        // Title Style
        $this->add_control(
            'title_style_heading',
            [
                'label' => __('استایل عنوان', 'textdomain'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __('رنگ متن', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .appointment-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'title_hover_color',
            [
                'label' => __('رنگ متن در هاور', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .appointment-item:hover .appointment-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('تایپوگرافی عنوان', 'textdomain'),
                'selector' => '{{WRAPPER}} .appointment-title',
            ]
        );

        $this->add_responsive_control(
            'title_margin_bottom',
            [
                'label' => __('فاصله عنوان از پایین', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .appointment-title' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $animation_class = !empty($settings['hover_animation']) ? 'elementor-animation-' . $settings['hover_animation'] : '';
        ?>
        <div class="appointment-websites-widget">
            <div class="appointment-container elementor-view-<?php echo esc_attr($settings['view']); ?>">
                <?php foreach ($settings['websites'] as $item) : 
                    $target = $item['website_link']['is_external'] ? ' target="_blank"' : '';
                    $nofollow = $item['website_link']['nofollow'] ? ' rel="nofollow"' : '';
                    $link = !empty($item['website_link']['url']) ? $item['website_link']['url'] : 'javascript:;';
                    $image_url = !empty($item['website_image']['url']) ? $item['website_image']['url'] : '';
                    $image_alt = !empty($item['website_title']) ? $item['website_title'] : __('تصویر سایت', 'textdomain');
                    ?>
                    <a href="<?php echo esc_url($link); ?>" <?php echo $target . ' ' . $nofollow; ?> class="appointment-item <?php echo esc_attr($animation_class); ?>">
                        <?php if (!empty($image_url)) : ?>
                            <div class="appointment-image">
                                <img src="<?php echo esc_url($image_url); ?>" alt="<?php echo esc_attr($image_alt); ?>" />
                            </div>
                        <?php endif; ?>
                        <?php if (!empty($item['website_title'])) : ?>
                            <h3 class="appointment-title"><?php echo esc_html($item['website_title']); ?></h3>
                        <?php endif; ?>
                    </a>
                <?php endforeach; ?>
            </div>
        </div>
        <?php
    }
}

// Register the widget
\Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Appointment_Websites_Widget());
