<?php
if (!defined('ABSPATH')) { exit; }

class Mohtavanegar_Box_Info_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'box_info_widget';
    }

    public function get_title() {
        return esc_html__('باکس اطلاعات', 'mohtavanegar');
    }

    public function get_icon() {
        return 'eicon-info-box';
    }

    public function get_categories() {
        return ['mohtavanegar'];
    }

    public function get_style_depends() {
        return ['box-info-widget'];
    }

    protected function register_controls() {
        // Content
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('محتوا', 'mohtavanegar'),
                'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'icon',
            [
                'label' => esc_html__('آیکون', 'mohtavanegar'),
                'type'  => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-seedling',
                    'library' => 'solid',
                ],
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__('عنوان', 'mohtavanegar'),
                'type'  => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('خدمات یکپارچه', 'mohtavanegar'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'description',
            [
                'label' => esc_html__('توضیحات', 'mohtavanegar'),
                'type'  => \Elementor\Controls_Manager::TEXTAREA,
                'default' => esc_html__('در کلینیک زخم ایرانیان ...', 'mohtavanegar'),
                'rows' => 5,
            ]
        );

        $this->end_controls_section();

        // Style
        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('استایل باکس', 'mohtavanegar'),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'text_align',
            [
                'label' => esc_html__('تراز متن', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'right' => [ 'title' => esc_html__('راست', 'mohtavanegar'), 'icon' => 'eicon-text-align-right' ],
                    'center'=> [ 'title' => esc_html__('وسط', 'mohtavanegar'), 'icon' => 'eicon-text-align-center' ],
                    'left'  => [ 'title' => esc_html__('چپ', 'mohtavanegar'),  'icon' => 'eicon-text-align-left'  ],
                    'justify' => [ 'title' => esc_html__('تراز دوطرفه', 'mohtavanegar'), 'icon' => 'eicon-text-align-justify' ],
                ],
                'default' => is_rtl() ? 'right' : 'left',
                'selectors' => [
                    '{{WRAPPER}} .mn-box-info' => 'text-align: {{VALUE}};'
                ],
            ]
        );

        $this->start_controls_tabs('box_colors_tabs');
        $this->start_controls_tab('box_colors_normal', [ 'label' => esc_html__('معمولی', 'mohtavanegar') ]);
        $this->add_control(
            'box_bg',
            [
                'label' => esc_html__('رنگ باکس', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#f7f3f6',
                'selectors' => [
                    '{{WRAPPER}} .mn-box-info' => 'background-color: {{VALUE}};'
                ],
            ]
        );
        $this->add_control(
            'header_bg',
            [
                'label' => esc_html__('رنگ پس‌زمینه عنوان/آیکون', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mn-box-info .mn-box-header' => 'background-color: {{VALUE}};'
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'box_shadow',
                'selector' => '{{WRAPPER}} .mn-box-info',
            ]
        );
        $this->add_responsive_control(
            'border_size',
            [
                'label' => esc_html__('ضخامت حاشیه', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [ 'px' => ['min' => 0, 'max' => 20] ],
                'default' => [ 'size' => 1, 'unit' => 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .mn-box-info' => 'border-width: {{SIZE}}{{UNIT}}; border-style: solid;'
                ],
            ]
        );
        $this->add_control(
            'border_color',
            [
                'label' => esc_html__('رنگ حاشیه', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mn-box-info' => 'border-color: {{VALUE}};'
                ],
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab('box_colors_hover', [ 'label' => esc_html__('هاور', 'mohtavanegar') ]);
        $this->add_control(
            'box_bg_hover',
            [
                'label' => esc_html__('رنگ باکس در هاور', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ae1745',
                'selectors' => [
                    '{{WRAPPER}} .mn-box-info:hover' => 'background-color: {{VALUE}};'
                ],
            ]
        );
        $this->add_control(
            'header_bg_hover',
            [
                'label' => esc_html__('رنگ پس‌زمینه عنوان/آیکون در هاور', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mn-box-info:hover .mn-box-header' => 'background-color: {{VALUE}};'
                ],
            ]
        );
        $this->add_control(
            'title_hover_color',
            [
                'label' => esc_html__('رنگ عنوان در هاور', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mn-box-info:hover .mn-box-title' => 'color: {{VALUE}};'
                ],
            ]
        );
        $this->add_control(
            'text_hover_color',
            [
                'label' => esc_html__('رنگ متن در هاور', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mn-box-info:hover .mn-box-desc' => 'color: {{VALUE}};'
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();

        // Header shape controls
        $this->add_responsive_control(
            'header_padding',
            [
                'label' => esc_html__('فاصله داخلی هدر (عنوان/آیکون)', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px','em','%'],
                'selectors' => [
                    '{{WRAPPER}} .mn-box-info .mn-box-header' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ],
            ]
        );

        $this->add_responsive_control(
            'header_border_radius',
            [
                'label' => esc_html__('گردی گوشه‌های هدر', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px','%','em'],
                'selectors' => [
                    '{{WRAPPER}} .mn-box-info .mn-box-header' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => esc_html__('تایپوگرافی عنوان', 'mohtavanegar'),
                'selector' => '{{WRAPPER}} .mn-box-title',
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('رنگ عنوان', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mn-box-title' => 'color: {{VALUE}};'
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'desc_typography',
                'label' => esc_html__('تایپوگرافی توضیحات', 'mohtavanegar'),
                'selector' => '{{WRAPPER}} .mn-box-desc',
            ]
        );
        $this->add_control(
            'text_color',
            [
                'label' => esc_html__('رنگ متن توضیحات', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mn-box-desc' => 'color: {{VALUE}};'
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $s = $this->get_settings_for_display();
        $this->add_render_attribute('wrapper','class','mn-box-info');
        ?>
        <div <?php echo $this->get_render_attribute_string('wrapper'); ?>>
            <div class="mn-box-header">
                <?php if (!empty($s['icon']['value'])): ?>
                    <span class="mn-box-icon"><?php \Elementor\Icons_Manager::render_icon($s['icon'], ['aria-hidden' => 'true']); ?></span>
                <?php endif; ?>
                <?php if (!empty($s['title'])): ?>
                    <h3 class="mn-box-title"><?php echo esc_html($s['title']); ?></h3>
                <?php endif; ?>
            </div>
            <?php if (!empty($s['description'])): ?>
                <p class="mn-box-desc"><?php echo esc_html($s['description']); ?></p>
            <?php endif; ?>
        </div>
        <?php
    }
}
