<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class Contact_Us_Widget extends \Elementor\Widget_Base {
    
    public function get_name() {
        return 'contact_us_widget';
    }

    public function get_title() {
        return __('تماس با ما', 'textdomain');
    }

    public function get_icon() {
        return 'eicon-call-to-action';
    }

    public function get_categories() {
        return ['mohtavanegar'];
    }

    public function get_script_depends() {
        return ['contact-us-widget'];
    }

    public function get_style_depends() {
        return ['contact-us-widget'];
    }

    protected function _register_controls() {
        // Content Tab
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('محتوا', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'item_icon',
            [
                'label' => __('آیکون', 'textdomain'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'solid',
                ],
            ]
        );

        $repeater->add_control(
            'item_title',
            [
                'label' => __('عنوان', 'textdomain'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('عنوان آیتم', 'textdomain'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'item_link',
            [
                'label' => __('لینک', 'textdomain'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('https://your-link.com', 'textdomain'),
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );

        $this->add_control(
            'contact_items',
            [
                'label' => __('آیتم‌های تماس', 'textdomain'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'item_title' => __('تلفن', 'textdomain'),
                        'item_icon' => [
                            'value' => 'fas fa-phone',
                            'library' => 'solid',
                        ],
                    ],
                    [
                        'item_title' => __('ایمیل', 'textdomain'),
                        'item_icon' => [
                            'value' => 'fas fa-envelope',
                            'library' => 'solid',
                        ],
                    ],
                    [
                        'item_title' => __('آدرس', 'textdomain'),
                        'item_icon' => [
                            'value' => 'fas fa-map-marker-alt',
                            'library' => 'solid',
                        ],
                    ],
                ],
                'title_field' => '{{{ item_title }}}',
            ]
        );

        $this->add_control(
            'view',
            [
                'label' => __('حالت نمایش', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'list',
                'options' => [
                    'list' => __('لیستی', 'textdomain'),
                    'grid' => __('شبکه‌ای', 'textdomain'),
                ],
                'prefix_class' => 'elementor-view-',
            ]
        );

        // Columns control for desktop
        $this->add_responsive_control(
            'columns',
            [
                'label' => __('تعداد ستون‌ها', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '3',
                'tablet_default' => '2',
                'mobile_default' => '1',
                'options' => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    '6' => '6',
                ],
                'prefix_class' => 'elementor-grid-columns-%s-',
                'condition' => [
                    'view' => 'grid',
                ],
                'selectors' => [
                    '{{WRAPPER}}.elementor-view-grid .contact-us-widget' => 'grid-template-columns: repeat({{VALUE}}, 1fr);',
                ],
            ]
        );

        // Gap between items
        $this->add_responsive_control(
            'gap',
            [
                'label' => __('فاصله بین آیتم‌ها', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'default' => [
                    'size' => 20,
                    'unit' => 'px',
                ],
                'size_units' => ['px', '%', 'em'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}}.elementor-view-grid .contact-us-widget' => 'gap: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'view' => 'grid',
                ],
            ]
        );

        $this->end_controls_section();

        // Style Tab
        $this->start_controls_section(
            'style_section',
            [
                'label' => __('استایل‌ها', 'textdomain'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'item_style_heading',
            [
                'label' => __('استایل آیتم‌ها', 'textdomain'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'item_background',
                'label' => __('پس‌زمینه', 'textdomain'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .contact-item',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'label' => __('حاشیه', 'textdomain'),
                'selector' => '{{WRAPPER}} .contact-item',
            ]
        );

        $this->add_control(
            'item_border_radius',
            [
                'label' => __('گردی گوشه‌ها', 'textdomain'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .contact-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'item_padding',
            [
                'label' => __('فاصله داخلی', 'textdomain'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .contact-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'item_margin',
            [
                'label' => __('فاصله خارجی', 'textdomain'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .contact-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'title_style_heading',
            [
                'label' => __('استایل عنوان', 'textdomain'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __('رنگ متن', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('تایپوگرافی عنوان', 'textdomain'),
                'selector' => '{{WRAPPER}} .contact-title',
            ]
        );

        $this->add_control(
            'icon_style_heading',
            [
                'label' => __('استایل آیکون', 'textdomain'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => __('رنگ آیکون', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact-icon' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}} .contact-icon i' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}} .contact-icon svg' => 'color: {{VALUE}} !important; fill: {{VALUE}} !important;',
                    '{{WRAPPER}} .contact-icon svg path' => 'fill: {{VALUE}} !important;',
                    '{{WRAPPER}} .contact-icon i:before' => 'color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_size',
            [
                'label' => __('اندازه آیکون', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', 'rem'],
                'range' => [
                    'px' => [
                        'min' => 1,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .contact-icon' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_spacing_right',
            [
                'label' => __('فاصله از راست', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .contact-icon' => 'margin-right: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_spacing_left',
            [
                'label' => __('فاصله از چپ', 'textdomain'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .contact-icon' => 'margin-left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'hover_style_heading',
            [
                'label' => __('حالت هاور', 'textdomain'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'item_hover_animation',
            [
                'label' => __('انیمیشن هاور', 'textdomain'),
                'type' => \Elementor\Controls_Manager::HOVER_ANIMATION,
            ]
        );

        $this->add_control(
            'item_hover_background',
            [
                'label' => __('پس‌زمینه در هاور', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact-item:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'title_hover_color',
            [
                'label' => __('رنگ عنوان در هاور', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact-item:hover .contact-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'icon_hover_color',
            [
                'label' => __('رنگ آیکون در هاور', 'textdomain'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact-item:hover .contact-icon' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}} .contact-item:hover .contact-icon i' => 'color: {{VALUE}} !important;',
                    '{{WRAPPER}} .contact-item:hover .contact-icon svg' => 'color: {{VALUE}} !important; fill: {{VALUE}} !important;',
                    '{{WRAPPER}} .contact-item:hover .contact-icon svg path' => 'fill: {{VALUE}} !important;',
                    '{{WRAPPER}} .contact-item:hover .contact-icon i:before' => 'color: {{VALUE}} !important;',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $animation_class = !empty($settings['item_hover_animation']) ? 'elementor-animation-' . $settings['item_hover_animation'] : '';
        
        // Add responsive classes
        $this->add_render_attribute('container', 'class', [
            'contact-us-widget',
            'elementor-view-' . $settings['view'],
            'elementor-grid',
        ]);
        ?>
        <div <?php echo $this->get_render_attribute_string('container'); ?>>
            <?php foreach ($settings['contact_items'] as $item) : 
                $target = $item['item_link']['is_external'] ? ' target="_blank"' : '';
                $nofollow = $item['item_link']['nofollow'] ? ' rel="nofollow"' : '';
                $link = !empty($item['item_link']['url']) ? $item['item_link']['url'] : 'javascript:;';
                ?>
                <a href="<?php echo esc_url($link); ?>" <?php echo $target . ' ' . $nofollow; ?> class="contact-item <?php echo esc_attr($animation_class); ?>">
                    <span class="contact-icon">
                        <?php \Elementor\Icons_Manager::render_icon($item['item_icon'], ['aria-hidden' => 'true']); ?>
                    </span>
                    <span class="contact-title"><?php echo esc_html($item['item_title']); ?></span>
                </a>
            <?php endforeach; ?>
        </div>
        <?php
    }
}

// Register the widget
\Elementor\Plugin::instance()->widgets_manager->register_widget_type(new Contact_Us_Widget());
