<?php
if (!defined('ABSPATH')) exit;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

class Portfolio_Widget extends Widget_Base {
    public function get_name() {
        return 'portfolio_widget';
    }

    public function get_title() {
        return __('نمونه کارها', 'mohtavanegar');
    }

    public function get_icon() {
        return 'eicon-gallery-grid';
    }

    public function get_categories() {
        return ['basic'];
    }

    protected function register_controls() {
        $this->start_controls_section('section_content', [
            'label' => __('محتوا', 'mohtavanegar'),
        ]);

        $this->add_control('show_title', [
            'label' => __('نمایش عنوان پروژه', 'mohtavanegar'),
            'type' => Controls_Manager::SWITCHER,
            'default' => 'yes',
        ]);

        $this->add_control('items_limit', [
            'label' => __('تعداد آیتم‌ها', 'mohtavanegar'),
            'type' => Controls_Manager::NUMBER,
            'default' => 12,
            'min' => 1,
            'max' => 100,
        ]);

        $this->end_controls_section();

        $this->start_controls_section('section_style', [
            'label' => __('استایل', 'mohtavanegar'),
            'tab' => Controls_Manager::TAB_STYLE,
        ]);

        $this->add_control('item_per_row', [
            'label' => __('تعداد در هر ردیف', 'mohtavanegar'),
            'type' => Controls_Manager::SELECT,
            'options' => ['2' => '2', '3' => '3', '4' => '4'],
            'default' => '3',
        ]);

        $this->add_control('item_gap', [
            'label' => __('فاصله آیتم‌ها', 'mohtavanegar'),
            'type' => Controls_Manager::SLIDER,
            'range' => ['px' => ['min' => 0, 'max' => 50]],
            'default' => ['size' => 20],
        ]);

        $this->add_control('category_color', [
            'label' => __('رنگ دسته‌بندی', 'mohtavanegar'),
            'type' => Controls_Manager::COLOR,
            'default' => '#333333',
        ]);

        $this->add_control('category_active_color', [
            'label' => __('رنگ دسته فعال', 'mohtavanegar'),
            'type' => Controls_Manager::COLOR,
            'default' => '#0073aa',
        ]);

        $this->add_control('item_bg_color', [
            'label' => __('رنگ پس‌زمینه آیتم', 'mohtavanegar'),
            'type' => Controls_Manager::COLOR,
            'default' => '#ffffff',
        ]);

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $categories = get_terms([
            'taxonomy' => 'portfolio_category',
            'hide_empty' => true,
        ]);

        $unique_id = 'portfolio_' . $this->get_id();
        ?>
        <div id="<?php echo esc_attr($unique_id); ?>" class="portfolio-widget" data-item-per-row="<?php echo esc_attr($settings['item_per_row']); ?>" data-gap="<?php echo esc_attr($settings['item_gap']['size']); ?>">
            <div class="portfolio-categories" style="margin-bottom:20px;">
                <button class="portfolio-cat-btn active" data-cat="all" style="color:<?php echo esc_attr($settings['category_active_color']); ?>;"><?php _e('همه', 'mohtavanegar'); ?></button>
                <?php foreach ($categories as $cat): ?>
                    <button class="portfolio-cat-btn" data-cat="<?php echo esc_attr($cat->term_id); ?>" style="color:<?php echo esc_attr($settings['category_color']); ?>;"><?php echo esc_html($cat->name); ?></button>
                <?php endforeach; ?>
            </div>
            <div class="portfolio-items-grid" style="display:grid;grid-template-columns:repeat(<?php echo esc_attr($settings['item_per_row']); ?>, 1fr);gap:<?php echo esc_attr($settings['item_gap']['size']); ?>px;">
                <?php $this->render_portfolio_items('all', $settings); ?>
            </div>
        </div>
        <script>
            document.addEventListener("DOMContentLoaded", function() {
                const container = document.querySelector("#<?php echo esc_js($unique_id); ?>");
                const buttons = container.querySelectorAll(".portfolio-cat-btn");
                const grid = container.querySelector(".portfolio-items-grid");

                buttons.forEach(btn => {
                    btn.addEventListener("click", function() {
                        buttons.forEach(b => b.classList.remove("active"));
                        btn.classList.add("active");
                        const catID = btn.getAttribute("data-cat");

                        fetch('<?php echo admin_url('admin-ajax.php'); ?>?action=filter_portfolio_items&cat_id=' + catID + '&widget_id=<?php echo esc_attr($this->get_id()); ?>')
                            .then(res => res.text())
                            .then(html => {
                                grid.innerHTML = html;
                            });
                    });
                });
            });
        </script>
        <?php
    }

    public function render_portfolio_items($cat_id = 'all', $settings = null) {
        if (!$settings) {
            $settings = $this->get_settings_for_display();
        }

        $args = [
            'post_type' => 'portfolio',
            'posts_per_page' => $settings['items_limit'],
        ];

        if ($cat_id !== 'all') {
            $args['tax_query'] = [[
                'taxonomy' => 'portfolio_category',
                'field' => 'term_id',
                'terms' => $cat_id,
            ]];
        }

        $query = new WP_Query($args);

        if ($query->have_posts()):
            while ($query->have_posts()): $query->the_post(); ?>
                <div class="portfolio-item" style="background-color:<?php echo esc_attr($settings['item_bg_color']); ?>;padding:10px;border-radius:8px;overflow:hidden;box-shadow:0 2px 10px rgba(0,0,0,0.05);transition:transform 0.3s;">
                    <a href="<?php the_permalink(); ?>" style="text-decoration:none;color:inherit;">
                        <?php if (has_post_thumbnail()) {
                            the_post_thumbnail('medium', ['style' => 'width:100%;border-radius:6px;']);
                        } ?>
                        <?php if ($settings['show_title'] === 'yes'): ?>
                            <h4 style="margin-top:10px;text-align:center;"><?php the_title(); ?></h4>
                        <?php endif; ?>
                    </a>
                </div>
            <?php endwhile;
            wp_reset_postdata();
        else:
            echo '<p>' . __('هیچ نمونه کاری یافت نشد.', 'mohtavanegar') . '</p>';
        endif;
    }
}