<?php
if (!defined('ABSPATH')) {
    exit;
}

class Mohtavanegar_Posts_Display_Widget extends \Elementor\Widget_Base {
    public function get_name() {
        return 'mohtavanegar_posts_display';
    }

    public function get_title() {
        return __('نمایش پست‌ها', 'mohtavanegar');
    }

    public function get_icon() {
        return 'eicon-posts-grid';
    }

    public function get_categories() {
        return ['mohtavanegar'];
    }

    protected function register_controls() {
        // Content Tab
        $this->start_controls_section(
            'content_section',
            [
                'label' => __('محتوا', 'mohtavanegar'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        // Post Type
        $post_types = get_post_types(['public' => true], 'objects');
        $post_type_options = [];
        foreach ($post_types as $post_type) {
            $post_type_options[$post_type->name] = $post_type->label;
        }

        $this->add_control(
            'post_type',
            [
                'label' => __('نوع پست', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'post',
                'options' => $post_type_options,
            ]
        );
        
        // Category Filter
        $categories = get_categories(['hide_empty' => false]);
        $category_options = ['' => __('همه دسته‌بندی‌ها', 'mohtavanegar')];
        foreach ($categories as $cat) {
            $category_options[$cat->term_id] = $cat->name;
        }
        $this->add_control(
            'category',
            [
                'label' => __('دسته‌بندی', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '',
                'options' => $category_options,
                'condition' => [
                    'post_type' => 'post',
                ],
            ]
        );
        
        // Exclude Category Filter
        $this->add_control(
            'exclude_category',
            [
                'label' => __('مستثنی کردن دسته‌بندی', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $category_options,
                'condition' => [
                    'post_type' => 'post',
                ],
                'description' => __('دسته‌بندی‌هایی که می‌خواهید از نمایش مستثنی شوند را انتخاب کنید.', 'mohtavanegar'),
            ]
        );
        
        // Sort Order
        $this->add_control(
            'orderby',
            [
                'label' => __('مرتب‌سازی بر اساس', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'date',
                'options' => [
                    'date' => __('تاریخ انتشار (جدیدترین)', 'mohtavanegar'),
                    'title' => __('عنوان', 'mohtavanegar'),
                    'modified' => __('آخرین ویرایش', 'mohtavanegar'),
                    'rand' => __('تصادفی', 'mohtavanegar'),
                    'comment_count' => __('تعداد نظرات', 'mohtavanegar'),
                ],
                'separator' => 'before',
            ]
        );
        
        $this->add_control(
            'order',
            [
                'label' => __('ترتیب', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'DESC',
                'options' => [
                    'DESC' => __('نزولی (جدیدترین اول)', 'mohtavanegar'),
                    'ASC' => __('صعودی (قدیمی‌ترین اول)', 'mohtavanegar'),
                ],
                'condition' => [
                    'orderby!' => 'rand',
                ],
            ]
        );

        // Display Type
        $this->add_control(
            'display_type',
            [
                'label' => __('نوع نمایش', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'grid',
                'options' => [
                    'grid' => __('شبکه‌ای', 'mohtavanegar'),
                    'carousel' => __('کروسل', 'mohtavanegar'),
                    'list' => __('لیستی', 'mohtavanegar'),
                ],
                'frontend_available' => true,
            ]
        );

        // Image Settings
        $this->add_control(
            'show_thumbnail',
            [
                'label' => __('نمایش تصویر شاخص', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('نمایش', 'mohtavanegar'),
                'label_off' => __('مخفی', 'mohtavanegar'),
                'return_value' => 'yes',
                'default' => 'yes',
                'separator' => 'before',
            ]
        );
        
        // Add custom image size for grid view
        add_image_size('mohtavanegar_grid_300x260', 300, 260, true);
        
        $this->add_control(
            'image_size',
            [
                'label' => __('اندازه تصویر شاخص', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'options' => [
                    'thumbnail' => __('تصویر بند انگشتی', 'mohtavanegar'),
                    'medium' => __('متوسط', 'mohtavanegar'),
                    'large' => __('بزرگ', 'mohtavanegar'),
                    'full' => __('سایز کامل', 'mohtavanegar'),
                    'mohtavanegar_grid_300x260' => __('شبکه 300x260 (برش خورده)', 'mohtavanegar'),
                ],
                'default' => 'mohtavanegar_grid_300x260',
                'condition' => [
                    'show_thumbnail' => 'yes',
                ],
            ]
        );
        
        $this->add_control(
            'image_size_custom',
            [
                'label' => __('سایز سفارشی تصویر', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'description' => __('عرض و ارتفاع تصویر را به پیکسل وارد کنید. برای فعال کردن برش خودکار، هر دو مقدار را وارد کنید.', 'mohtavanegar'),
                'condition' => [
                    'show_thumbnail' => 'yes',
                    'image_size' => 'custom',
                ],
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-post-thumbnail img' => 'width: {{WIDTH}}{{UNIT}}; height: {{HEIGHT}}{{UNIT}}; object-fit: cover;',
                ],
            ]
        );

        $this->end_controls_section(); // End content_section

        // Carousel Settings Section
        $this->start_controls_section(
            'carousel_section',
            [
                'label' => __('تنظیمات کروسل', 'mohtavanegar'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'display_type' => 'carousel',
                ],
            ]
        );

        // Show Arrows
        $this->add_control(
            'show_arrows',
            [
                'label' => __('نمایش فلش‌های ناوبری', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('نمایش', 'mohtavanegar'),
                'label_off' => __('مخفی', 'mohtavanegar'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        // Arrow Style
        $this->add_control(
            'arrow_style',
            [
                'label' => __('استایل فلش‌ها', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'default',
                'options' => [
                    'default' => __('پیش‌فرض', 'mohtavanegar'),
                    'circle' => __('دایره', 'mohtavanegar'),
                    'square' => __('مربع', 'mohtavanegar'),
                    'angle' => __('زاویه‌دار', 'mohtavanegar'),
                ],
                'condition' => [
                    'show_arrows' => 'yes',
                ],
            ]
        );

        // Show Dots
        $this->add_control(
            'show_dots',
            [
                'label' => __('نمایش نقاط ناوبری', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('نمایش', 'mohtavanegar'),
                'label_off' => __('مخفی', 'mohtavanegar'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        // Autoplay
        $this->add_control(
            'autoplay',
            [
                'label' => __('پخش خودکار', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('روشن', 'mohtavanegar'),
                'label_off' => __('خاموش', 'mohtavanegar'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        // Autoplay Speed
        $this->add_control(
            'autoplay_speed',
            [
                'label' => __('سرعت پخش خودکار (میلی‌ثانیه)', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 3000,
                'condition' => [
                    'autoplay' => 'yes',
                ],
            ]
        );

        // Loop
        $this->add_control(
            'infinite_loop',
            [
                'label' => __('حلقه بی‌نهایت', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('روشن', 'mohtavanegar'),
                'label_off' => __('خاموش', 'mohtavanegar'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        // Pause on Hover
        $this->add_control(
            'pause_on_hover',
            [
                'label' => __('توقف در هنگام هاور', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('روشن', 'mohtavanegar'),
                'label_off' => __('خاموش', 'mohtavanegar'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'autoplay' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'carousel_image_spacing',
            [
                'label' => __('فاصله تصاویر در کروسل', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'size' => 10,
                    'unit' => 'px',
                ],
            ]
        );

        $this->end_controls_section(); // End Carousel Settings Section
        
        // Content Display Section
        $this->start_controls_section(
            'content_display_section',
            [
                'label' => __('نمایش محتوا', 'mohtavanegar'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        // Posts Per Page
        $this->add_control(
            'posts_per_page',
            [
                'label' => __('تعداد پست‌های قابل نمایش', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::NUMBER,
                'default' => 6,
                'min' => 1,
                'max' => 50,
            ]
        );

        // Pagination Toggle
        $this->add_control(
            'show_pagination',
            [
                'label' => __('نمایش صفحه‌بندی', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('بله', 'mohtavanegar'),
                'label_off' => __('خیر', 'mohtavanegar'),
                'return_value' => 'yes',
                'default' => 'no',
                'description' => __('برای نمایش لینک‌های صفحه‌بندی در حالت شبکه‌ای/لیستی فعال کنید.', 'mohtavanegar'),
                'condition' => [
                    'display_type!' => 'carousel',
                ],
            ]
        );

        // Show Excerpt
        $this->add_control(
            'show_excerpt',
            [
                'label' => __('نمایش خلاصه مطلب', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('بله', 'mohtavanegar'),
                'label_off' => __('خیر', 'mohtavanegar'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        // Show Title
        $this->add_control(
            'show_title',
            [
                'label' => __('نمایش عنوان', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('بله', 'mohtavanegar'),
                'label_off' => __('خیر', 'mohtavanegar'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        // Show Meta
        $this->add_control(
            'show_meta',
            [
                'label' => __('نمایش اطلاعات متا (نویسنده، تاریخ)', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('بله', 'mohtavanegar'),
                'label_off' => __('خیر', 'mohtavanegar'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        // Meta Position
        $this->add_control(
            'meta_position',
            [
                'label' => __('موقعیت اطلاعات متا', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'after_title',
                'options' => [
                    'before_title' => __('قبل از عنوان', 'mohtavanegar'),
                    'after_title' => __('بعد از عنوان', 'mohtavanegar'),
                    'overlay_top' => __('روی تصویر شاخص (بالا)', 'mohtavanegar'),
                ],
                'condition' => [
                    'show_meta' => 'yes',
                ],
            ]
        );

        // Show Read More
        $this->add_control(
            'show_read_more',
            [
                'label' => __('نمایش دکمه ادامه مطلب', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('بله', 'mohtavanegar'),
                'label_off' => __('خیر', 'mohtavanegar'),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );

        $this->end_controls_section(); // End Content Display Section

        // Style Tab - General
        $this->start_controls_section(
            'general_style_section',
            [
                'label' => __('استایل عمومی', 'mohtavanegar'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        // Image Style
        $this->add_control(
            'image_style_heading',
            [
                'label' => __('تصویر شاخص', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'show_thumbnail' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'image_ratio',
            [
                'label' => __('نسبت تصویر', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'square',
                'options' => [
                    'original' => __('اصلی', 'mohtavanegar'),
                    'square' => __('مربع (1:1)', 'mohtavanegar'),
                    'rectangle' => __('مستطیل (4:3)', 'mohtavanegar'),
                ],
                'prefix_class' => 'mohtavanegar-image-ratio-',
                'condition' => [
                    'show_thumbnail' => 'yes',
                ],
            ]
        );

        // List View: Image Max Width
        $this->add_responsive_control(
            'list_image_max_width',
            [
                'label' => __('حداکثر عرض تصویر (نمایش لیستی)', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em', 'vw'],
                'range' => [
                    'px' => [ 'min' => 50, 'max' => 600 ],
                    '%'  => [ 'min' => 5,  'max' => 100 ],
                ],
                'default' => [ 'size' => 160, 'unit' => 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-posts-list .mohtavanegar-post-thumbnail' => 'max-width: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .mohtavanegar-posts-list .mohtavanegar-post-thumbnail img' => 'width: 100%; height: auto;',
                ],
                'condition' => [
                    'show_thumbnail' => 'yes',
                    'display_type' => 'list',
                ],
            ]
        );

        // List View: Image Max Height
        $this->add_responsive_control(
            'list_image_max_height',
            [
                'label' => __('حداکثر ارتفاع تصویر (نمایش لیستی)', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'vh'],
                'range' => [
                    'px' => [ 'min' => 50, 'max' => 600 ],
                    'vh' => [ 'min' => 10, 'max' => 100 ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-posts-list .mohtavanegar-post-thumbnail img' => 'max-height: {{SIZE}}{{UNIT}}; object-fit: cover; width: 100%;',
                ],
                'condition' => [
                    'show_thumbnail' => 'yes',
                    'display_type' => 'list',
                ],
            ]
        );

        $this->add_responsive_control(
            'image_spacing',
            [
                'label' => __('فاصله تصویر', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em'],
                'default' => [
                    'size' => 15,
                    'unit' => 'px',
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-post-thumbnail' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'show_thumbnail' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'image_border_radius',
            [
                'label' => __('گردی گوشه‌ها', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-post-thumbnail' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; overflow: hidden;',
                ],
                'condition' => [
                    'show_thumbnail' => 'yes',
                ],
            ]
        );

        // Layout Spacing
        $this->add_control(
            'layout_spacing_heading',
            [
                'label' => __('فاصله‌بندی', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        // Grid Gap (for grid layout)
        $this->add_responsive_control(
            'grid_gap',
            [
                'label' => __('فاصله شبکه (gap)', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', '%'],
                'range' => [
                    'px' => [ 'min' => 0, 'max' => 100 ],
                ],
                'default' => [ 'size' => 20, 'unit' => 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-posts-grid' => 'gap: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'display_type' => 'grid',
                ],
            ]
        );

        $this->add_responsive_control(
            'column_gap',
            [
                'label' => __('فاصله بین ستون‌ها', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em'],
                'default' => [
                    'size' => 20,
                    'unit' => 'px',
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
            ]
        );

        // Post Item Padding
        $this->add_control(
            'post_item_padding_heading',
            [
                'label' => __('فاصله داخلی آیتم‌ها', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'post_item_padding',
            [
                'label' => __('فاصله داخلی', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'default' => [
                    'top' => '15',
                    'right' => '15',
                    'bottom' => '15',
                    'left' => '15',
                    'unit' => 'px',
                    'isLinked' => true,
                ],
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-post-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'post_item_margin',
            [
                'label' => __('فاصله خارجی', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-post-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'post_item_box_shadow',
                'label' => __('سایه', 'mohtavanegar'),
                'selector' => '{{WRAPPER}} .mohtavanegar-post-item',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'post_item_border',
                'label' => __('حاشیه', 'mohtavanegar'),
                'selector' => '{{WRAPPER}} .mohtavanegar-post-item',
            ]
        );

        $this->add_control(
            'post_item_border_radius',
            [
                'label' => __('گردی گوشه‌ها', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-post-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}}; overflow: hidden;',
                ],
            ]
        );

        $this->add_control(
            'post_item_background_color',
            [
                'label' => __('رنگ پس‌زمینه', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-post-item' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        // Hover State
        $this->start_controls_tabs('post_item_style_tabs');

        $this->start_controls_tab(
            'post_item_normal_tab',
            [
                'label' => __('عادی', 'mohtavanegar'),
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'post_item_box_shadow_normal',
                'label' => __('سایه', 'mohtavanegar'),
                'selector' => '{{WRAPPER}} .mohtavanegar-post-item',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'post_item_hover_tab',
            [
                'label' => __('هاور', 'mohtavanegar'),
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'post_item_box_shadow_hover',
                'label' => __('سایه در حالت هاور', 'mohtavanegar'),
                'selector' => '{{WRAPPER}} .mohtavanegar-post-item:hover',
            ]
        );

        $this->add_control(
            'post_item_hover_background_color',
            [
                'label' => __('رنگ پس‌زمینه در حالت هاور', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-post-item:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        // Column Gap Control
        $this->add_responsive_control(
            'column_gap',
            [
                'label' => __('فاصله بین ستون‌ها', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em'],
                'default' => [
                    'size' => 20,
                    'unit' => 'px',
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-posts-grid .mohtavanegar-post-item' => 'padding-right: {{SIZE}}{{UNIT}}; padding-left: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .mohtavanegar-carousel .swiper' => 'padding-right: {{SIZE}}{{UNIT}}; padding-left: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'row_gap',
            [
                'label' => __('فاصله بین سطرها', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'em'],
                'default' => [
                    'size' => 30,
                    'unit' => 'px',
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-posts-grid' => 'margin-bottom: -{{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .mohtavanegar-post-item' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .mohtavanegar-carousel .swiper-slide' => 'margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'content_padding',
            [
                'label' => __('فاصله محتوا', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-post-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        // Item Background Color
        $this->add_control(
            'item_background_color',
            [
                'label' => __('رنگ پس‌زمینه آیتم', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-post-item' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        // Item Container Styles (Normal / Hover)
        $this->start_controls_tabs('item_box_style_tabs');

        // Normal Tab
        $this->start_controls_tab(
            'item_box_normal_tab',
            [
                'label' => __('عادی', 'mohtavanegar'),
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'item_box_border',
                'label' => __('حاشیه', 'mohtavanegar'),
                'selector' => '{{WRAPPER}} .mohtavanegar-post-item',
            ]
        );

        $this->add_control(
            'item_box_border_radius',
            [
                'label' => __('گردی گوشه‌ها', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-post-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_box_shadow',
                'label' => __('سایه', 'mohtavanegar'),
                'selector' => '{{WRAPPER}} .mohtavanegar-post-item',
            ]
        );

        $this->end_controls_tab();

        // Hover Tab
        $this->start_controls_tab(
            'item_box_hover_tab',
            [
                'label' => __('هاور', 'mohtavanegar'),
            ]
        );

        $this->add_control(
            'item_background_hover_color',
            [
                'label' => __('رنگ پس‌زمینه در هاور', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-post-item:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'item_box_border_hover',
                'label' => __('حاشیه در هاور', 'mohtavanegar'),
                'selector' => '{{WRAPPER}} .mohtavanegar-post-item:hover',
            ]
        );

        $this->add_control(
            'item_border_hover_color',
            [
                'label' => __('رنگ حاشیه در هاور', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-post-item:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_box_shadow_hover',
                'label' => __('سایه در هاور', 'mohtavanegar'),
                'selector' => '{{WRAPPER}} .mohtavanegar-post-item:hover',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        // Title Style
        $this->add_control(
            'title_style_heading',
            [
                'label' => __('عنوان', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'show_title' => 'yes',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('تایپوگرافی عنوان', 'mohtavanegar'),
                'selector' => '{{WRAPPER}} .mohtavanegar-post-title',
                'condition' => [
                    'show_title' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => __('رنگ عنوان', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-post-title a' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'show_title' => 'yes',
                ],
            ]
        );

        // Title Alignment
        $this->add_responsive_control(
            'title_alignment',
            [
                'label' => __('چیدمان عنوان', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [ 'title' => __('چپ', 'mohtavanegar'), 'icon' => 'eicon-text-align-left' ],
                    'center' => [ 'title' => __('میانه', 'mohtavanegar'), 'icon' => 'eicon-text-align-center' ],
                    'right' => [ 'title' => __('راست', 'mohtavanegar'), 'icon' => 'eicon-text-align-right' ],
                ],
                'default' => 'right',
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-post-title' => 'text-align: {{VALUE}};',
                ],
                'condition' => [
                    'show_title' => 'yes',
                ],
            ]
        );

        // Title Lines (single or double)
        $this->add_control(
            'title_lines',
            [
                'label' => __('ارتفاع عنوان', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '2',
                'options' => [
                    '1' => __('یک خطی', 'mohtavanegar'),
                    '2' => __('دو خطی', 'mohtavanegar'),
                ],
                'condition' => [
                    'show_title' => 'yes',
                ],
            ]
        );

        // Meta Style
        $this->add_control(
            'meta_style_heading',
            [
                'label' => __('اطلاعات متا', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'show_meta' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'meta_color',
            [
                'label' => __('رنگ متا', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-post-meta' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'show_meta' => 'yes',
                ],
            ]
        );

        // Read More Button Style
        $this->add_control(
            'read_more_style_heading',
            [
                'label' => __('دکمه ادامه مطلب', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'show_read_more' => 'yes',
                ],
            ]
        );

        // Text Color
        $this->start_controls_tabs('read_more_style_tabs');

        // Normal State
        $this->start_controls_tab(
            'read_more_normal_tab',
            [
                'label' => __('عادی', 'mohtavanegar'),
                'condition' => [
                    'show_read_more' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'read_more_color',
            [
                'label' => __('رنگ متن', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-read-more' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'show_read_more' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'read_more_bg_color',
            [
                'label' => __('رنگ پس‌زمینه', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#3a7bd5',
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-read-more' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'show_read_more' => 'yes',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'read_more_border',
                'label' => __('حاشیه', 'mohtavanegar'),
                'selector' => '{{WRAPPER}} .mohtavanegar-read-more',
                'condition' => [
                    'show_read_more' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'read_more_border_radius',
            [
                'label' => __('گردی گوشه‌ها', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-read-more' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'show_read_more' => 'yes',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'read_more_box_shadow',
                'label' => __('سایه', 'mohtavanegar'),
                'selector' => '{{WRAPPER}} .mohtavanegar-read-more',
                'condition' => [
                    'show_read_more' => 'yes',
                ],
            ]
        );

        $this->end_controls_tab();

        // Hover State
        $this->start_controls_tab(
            'read_more_hover_tab',
            [
                'label' => __('هاور', 'mohtavanegar'),
                'condition' => [
                    'show_read_more' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'read_more_hover_color',
            [
                'label' => __('رنگ متن در هاور', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-read-more:hover' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'show_read_more' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'read_more_bg_hover_color',
            [
                'label' => __('رنگ پس‌زمینه در هاور', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#00d2ff',
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-read-more:hover' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'show_read_more' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'read_more_hover_border_color',
            [
                'label' => __('رنگ حاشیه در هاور', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-read-more:hover' => 'border-color: {{VALUE}}',
                ],
                'condition' => [
                    'show_read_more' => 'yes',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'read_more_hover_box_shadow',
                'label' => __('سایه در هاور', 'mohtavanegar'),
                'selector' => '{{WRAPPER}} .mohtavanegar-read-more:hover',
                'condition' => [
                    'show_read_more' => 'yes',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        // Typography
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'read_more_typography',
                'label' => __('تایپوگرافی دکمه', 'mohtavanegar'),
                'selector' => '{{WRAPPER}} .mohtavanegar-read-more',
                'condition' => [
                    'show_read_more' => 'yes',
                ],
            ]
        );

        // Padding
        $this->add_responsive_control(
            'read_more_padding',
            [
                'label' => __('فاصله داخلی', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-read-more' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'show_read_more' => 'yes',
                ],
                'separator' => 'before',
            ]
        );

        // Margin
        $this->add_responsive_control(
            'read_more_margin',
            [
                'label' => __('فاصله خارجی', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-read-more' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'show_read_more' => 'yes',
                ],
            ]
        );
        
        // Hover Animation
        $this->add_control(
            'read_more_hover_animation',
            [
                'label' => __('انیمیشن هاور', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::HOVER_ANIMATION,
                'condition' => [
                    'show_read_more' => 'yes',
                ],
            ]
        );

        $this->end_controls_section(); // End General Style Section

        // Pagination Style Section
        $this->start_controls_section(
            'pagination_style_section',
            [
                'label' => __('استایل صفحه‌بندی', 'mohtavanegar'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_pagination' => 'yes',
                    'display_type!' => 'carousel',
                ],
            ]
        );

        // Alignment
        $this->add_responsive_control(
            'pagination_alignment',
            [
                'label' => __('چیدمان', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'flex-start' => [ 'title' => __('چپ', 'mohtavanegar'), 'icon' => 'eicon-text-align-left' ],
                    'center'     => [ 'title' => __('میانه', 'mohtavanegar'), 'icon' => 'eicon-text-align-center' ],
                    'flex-end'   => [ 'title' => __('راست', 'mohtavanegar'), 'icon' => 'eicon-text-align-right' ],
                ],
                'default' => 'center',
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-pagination' => 'display: flex; flex-wrap: wrap; align-items: center; justify-content: {{VALUE}};',
                ],
            ]
        );

        // Spacing
        $this->add_responsive_control(
            'pagination_spacing',
            [
                'label' => __('فاصله بالا/پایین', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', 'em', '%'],
                'range' => [ 'px' => [ 'min' => 0, 'max' => 100 ] ],
                'default' => [ 'size' => 20, 'unit' => 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-pagination' => 'margin-top: {{SIZE}}{{UNIT}}; margin-bottom: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        // Typography
        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'pagination_typography',
                'selector' => '{{WRAPPER}} .mohtavanegar-pagination .page-numbers',
            ]
        );

        // Normal/Hover/Active Tabs
        $this->start_controls_tabs('pagination_style_tabs');

        // Normal
        $this->start_controls_tab(
            'pagination_normal_tab',
            [ 'label' => __('عادی', 'mohtavanegar') ]
        );
        $this->add_control(
            'pagination_color',
            [
                'label' => __('رنگ متن', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-pagination .page-numbers' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'pagination_bg_color',
            [
                'label' => __('رنگ پس‌زمینه', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-pagination .page-numbers' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'pagination_border',
                'selector' => '{{WRAPPER}} .mohtavanegar-pagination .page-numbers',
            ]
        );
        $this->add_control(
            'pagination_border_radius',
            [
                'label' => __('گردی گوشه‌ها', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-pagination .page-numbers' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'pagination_item_padding',
            [
                'label' => __('فاصله داخلی آیتم', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-pagination .page-numbers' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'pagination_item_gap',
            [
                'label' => __('فاصله بین آیتم‌ها', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [ 'px' => [ 'min' => 0, 'max' => 30 ] ],
                'default' => [ 'size' => 6, 'unit' => 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-pagination' => 'gap: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();

        // Hover
        $this->start_controls_tab(
            'pagination_hover_tab',
            [ 'label' => __('هاور', 'mohtavanegar') ]
        );
        $this->add_control(
            'pagination_hover_color',
            [
                'label' => __('رنگ متن هاور', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-pagination .page-numbers:hover' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'pagination_hover_bg_color',
            [
                'label' => __('رنگ پس‌زمینه هاور', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-pagination .page-numbers:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'pagination_hover_border_color',
            [
                'label' => __('رنگ حاشیه هاور', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-pagination .page-numbers:hover' => 'border-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();

        // Active
        $this->start_controls_tab(
            'pagination_active_tab',
            [ 'label' => __('فعال', 'mohtavanegar') ]
        );
        $this->add_control(
            'pagination_active_color',
            [
                'label' => __('رنگ متن فعال', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-pagination .page-numbers.current' => 'color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'pagination_active_bg_color',
            [
                'label' => __('رنگ پس‌زمینه فعال', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#3a7bd5',
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-pagination .page-numbers.current' => 'background-color: {{VALUE}}',
                ],
            ]
        );
        $this->add_control(
            'pagination_active_border_color',
            [
                'label' => __('رنگ حاشیه فعال', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => 'transparent',
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-pagination .page-numbers.current' => 'border-color: {{VALUE}}',
                ],
            ]
        );
        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section(); // End Pagination Style Section

        // Carousel Style Section
        $this->start_controls_section(
            'carousel_style_section',
            [
                'label' => __('استایل کروسل', 'mohtavanegar'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
                'condition' => [
                    'display_type' => 'carousel',
                ],
            ]
        );
        
        // Arrows Style
        $this->start_controls_tabs('carousel_arrows_style_tabs');

        // Normal State
        $this->start_controls_tab(
            'carousel_arrows_normal_tab',
            [
                'label' => __('عادی', 'mohtavanegar'),
                'condition' => [
                    'show_arrows' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'arrow_color',
            [
                'label' => __('رنگ فلش', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#333333',
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-carousel .slick-arrow' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'show_arrows' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'arrow_bg_color',
            [
                'label' => __('رنگ پس‌زمینه فلش', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => 'rgba(255, 255, 255, 0.9)',
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-carousel .slick-arrow' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'show_arrows' => 'yes',
                ],
            ]
        );

        $this->end_controls_tab();

        // Hover State
        $this->start_controls_tab(
            'carousel_arrows_hover_tab',
            [
                'label' => __('هاور', 'mohtavanegar'),
                'condition' => [
                    'show_arrows' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'arrow_hover_color',
            [
                'label' => __('رنگ فلش در هاور', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-carousel .slick-arrow:hover' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'show_arrows' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'arrow_bg_hover_color',
            [
                'label' => __('رنگ پس‌زمینه فلش در هاور', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#1e87f0',
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-carousel .slick-arrow:hover' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'show_arrows' => 'yes',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        // Arrow Size
        $this->add_control(
            'arrow_size',
            [
                'label' => __('اندازه فلش (پیکسل)', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 10,
                        'max' => 60,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 20,
                ],
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-carousel .slick-arrow:before' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'show_arrows' => 'yes',
                ],
            ]
        );

        // Arrow Box Size
        $this->add_control(
            'arrow_box_size',
            [
                'label' => __('اندازه باکس فلش (پیکسل)', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 20,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 40,
                ],
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-carousel .slick-arrow' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'show_arrows' => 'yes',
                ],
            ]
        );

        // Dots Style
        $this->add_control(
            'dots_style_heading',
            [
                'label' => __('نقاط ناوبری', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => [
                    'show_dots' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'dots_color',
            [
                'label' => __('رنگ نقاط', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#cccccc',
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-carousel .slick-dots li button' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'show_dots' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'dots_active_color',
            [
                'label' => __('رنگ نقطه فعال', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#1e87f0',
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-carousel .slick-dots li.slick-active button' => 'background-color: {{VALUE}}',
                ],
                'condition' => [
                    'show_dots' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'dots_size',
            [
                'label' => __('اندازه نقاط (پیکسل)', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 4,
                        'max' => 20,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 10,
                ],
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-carousel .slick-dots li button' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'show_dots' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'dots_spacing',
            [
                'label' => __('فاصله بین نقاط (پیکسل)', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 30,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 5,
                ],
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-carousel .slick-dots li' => 'margin: 0 {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'show_dots' => 'yes',
                ],
            ]
        );

        $this->add_control(
            'dots_position',
            [
                'label' => __('موقعیت نقاط', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => -50,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} .mohtavanegar-carousel .slick-dots' => 'bottom: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'show_dots' => 'yes',
                ],
            ]
        );

        $this->end_controls_section(); // End Carousel Style Section

        // Responsive Columns Section
        $this->start_controls_section(
            'responsive_columns_section',
            [
                'label' => __('ستون‌های واکنش‌گرا', 'mohtavanegar'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'display_type' => ['grid', 'carousel'],
                ],
            ]
        );

        $this->add_responsive_control(
            'columns',
            [
                'label' => __('تعداد ستون‌ها', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => '3',
                'tablet_default' => '2',
                'mobile_default' => '1',
                'options' => [
                    '1' => '1',
                    '2' => '2',
                    '3' => '3',
                    '4' => '4',
                    '5' => '5',
                    '6' => '6',
                ],
                'frontend_available' => true,
            ]
        );

        $this->end_controls_section(); // End Responsive Columns Section
    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        
        // Optimize query args
        $is_carousel = isset($settings['display_type']) && $settings['display_type'] === 'carousel';
        $want_pagination = (isset($settings['show_pagination']) && $settings['show_pagination'] === 'yes' && !$is_carousel);
        // Normalize booleans
        $show_thumbnail = !empty($settings['show_thumbnail']) && $settings['show_thumbnail'] === 'yes';
        $show_meta = !empty($settings['show_meta']) && $settings['show_meta'] === 'yes';
        $meta_position = isset($settings['meta_position']) ? $settings['meta_position'] : 'after_title';

        // Determine current page for pagination
        $paged = 1;
        if ($want_pagination) {
            $paged = max(1, get_query_var('paged') ? intval(get_query_var('paged')) : (get_query_var('page') ? intval(get_query_var('page')) : 1));
        }

        $args = [
            'post_type' => $settings['post_type'],
            'posts_per_page' => $settings['posts_per_page'],
            'post_status' => 'publish',
            'orderby' => $settings['orderby'],
            'order' => $settings['order'],
            'no_found_rows' => $want_pagination ? false : true, // Disable only when paginating
            'update_post_meta_cache' => false, // Don't cache post meta
            'update_post_term_cache' => false, // Don't cache terms
        ];
        if ($want_pagination) {
            $args['paged'] = $paged;
        }
        
        // Filter by category if set and post_type is 'post'
        if ($settings['post_type'] === 'post') {
            // Include specific category if set
            if (!empty($settings['category'])) {
                $args['cat'] = $settings['category'];
            }
            
            // Exclude categories if set
            if (!empty($settings['exclude_category'])) {
                $args['category__not_in'] = $settings['exclude_category'];
            }
        }
        
        // If orderby is set to random, remove the order parameter
        if ($settings['orderby'] === 'rand') {
            unset($args['order']);
        }

        $query = new \WP_Query($args);

        if ($query->have_posts()) {
            // Prepare wrapper classes
            $wrapper_classes = [
                'mohtavanegar-posts-wrapper', 
                'mohtavanegar-posts-' . $settings['display_type']
            ];
            
            // Add grid classes for grid and carousel layouts
            if (in_array($settings['display_type'], ['grid', 'carousel'])) {
                $wrapper_classes[] = 'elementor-grid';
                
                // Get responsive columns
                $columns = isset($settings['columns']) ? $settings['columns'] : 3;
                $columns_tablet = isset($settings['columns_tablet']) ? $settings['columns_tablet'] : 2;
                $columns_mobile = isset($settings['columns_mobile']) ? $settings['columns_mobile'] : 1;
                
                // Add responsive grid classes
                $wrapper_classes[] = 'elementor-grid-' . $columns;
                $wrapper_classes[] = 'elementor-grid-tablet-' . $columns_tablet;
                $wrapper_classes[] = 'elementor-grid-mobile-' . $columns_mobile;
                
                // Add carousel specific classes and data attributes
                if ($settings['display_type'] === 'carousel') {
                    $wrapper_classes[] = 'mohtavanegar-carousel';
                    
                    $this->add_render_attribute('wrapper', [
                        'data-columns' => $columns,
                        'data-columns-tablet' => $columns_tablet,
                        'data-columns-mobile' => $columns_mobile,
                        'data-show-arrows' => $settings['show_arrows'],
                        'data-show-dots' => $settings['show_dots'],
                        'data-autoplay' => $settings['autoplay'],
                        'data-autoplay-speed' => $settings['autoplay_speed'],
                        'data-infinite' => $settings['infinite_loop'],
                        'data-pause-on-hover' => $settings['pause_on_hover'],
                        'data-arrow-style' => $settings['arrow_style']
                    ]);
                }
            }
            
            // Add all wrapper classes at once
            $this->add_render_attribute('wrapper', 'class', $wrapper_classes);
            
            echo '<div ' . $this->get_render_attribute_string('wrapper') . '>';
            
            // Get image size
            $image_size = $settings['image_size'] ?? 'mohtavanegar_grid_300x260';
            
            // Register custom image size if not exists
            if ($image_size === 'mohtavanegar_grid_300x260' && !has_image_size('mohtavanegar_grid_300x260')) {
                add_image_size('mohtavanegar_grid_300x260', 300, 260, true);
            }
            
            if ($settings['display_type'] === 'carousel') {
                echo '<div class="mohtavanegar-carousel">';
                echo '<div class="swiper">';
                echo '<div class="swiper-wrapper">';
            }
            
            while ($query->have_posts()) {
                $query->the_post();
                $post_id = get_the_ID();
                // Prepare meta HTML once
                $meta_html = '';
                if ($show_meta) {
                    $meta_html = '<div class="mohtavanegar-post-meta"><span class="mohtavanegar-post-date">' . get_the_date() . '</span><span class="mohtavanegar-post-author">' . esc_html__('نوشته شده توسط ', 'mohtavanegar') . get_the_author() . '</span></div>';
                }
                ?>
                <article id="post-<?php echo esc_attr($post_id); ?>" <?php post_class('mohtavanegar-post-item'); ?>>
                    <?php if ($show_thumbnail && has_post_thumbnail()) : ?>
                        <div class="mohtavanegar-post-thumbnail"<?php echo ($show_meta && $meta_position === 'overlay_top') ? ' style="position:relative;"' : ''; ?>>
                            <?php if ($show_meta && $meta_position === 'overlay_top') : ?>
                                <div class="mohtavanegar-post-meta mohtavanegar-post-meta-overlay" style="position:absolute;top:8px;left:8px;right:8px;z-index:2;">
                                    <span class="mohtavanegar-post-date"><?php echo get_the_date(); ?></span>
                                    <span class="mohtavanegar-post-author"><?php echo esc_html__('نوشته شده توسط ', 'mohtavanegar') . get_the_author(); ?></span>
                                </div>
                            <?php endif; ?>
                            <a href="<?php the_permalink(); ?>">
                                <?php the_post_thumbnail($image_size, [
                                    'class' => 'mohtavanegar-post-image',
                                    'loading' => 'lazy'
                                ]); ?>
                            </a>
                        </div>
                    <?php endif; ?>

                    <div class="mohtavanegar-post-content">
                        <?php if ($show_meta && $meta_position === 'before_title') : ?>
                            <?php echo $meta_html; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
                        <?php endif; ?>
                        <?php if ('yes' === $settings['show_title']) : ?>
                            <?php 
                                $title_lines = isset($settings['title_lines']) ? (int) $settings['title_lines'] : 2; 
                                $title_lines = ($title_lines === 1) ? 1 : 2; 
                                $title_clamp_style = 'display:-webkit-box;-webkit-line-clamp:' . $title_lines . ';-webkit-box-orient:vertical;overflow:hidden;min-height:' . $title_lines . 'lh;';
                            ?>
                            <h3 class="mohtavanegar-post-title">
                                <a href="<?php the_permalink(); ?>" style="<?php echo esc_attr($title_clamp_style); ?>">
                                    <?php the_title(); ?>
                                </a>
                            </h3>
                        <?php endif; ?>

                        <?php if ($show_meta && $meta_position === 'after_title') : ?>
                            <?php echo $meta_html; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
                        <?php endif; ?>

                        <?php if ('yes' === $settings['show_excerpt']) : ?>
                            <div class="mohtavanegar-post-excerpt">
                                <?php the_excerpt(); ?>
                            </div>
                        <?php endif; ?>

                        <?php if ('yes' === $settings['show_read_more']) : ?>
                            <div class="mohtavanegar-post-read-more">
                                <a href="<?php the_permalink(); ?>" class="mohtavanegar-read-more">
                                    <?php echo esc_html__('ادامه مطلب', 'mohtavanegar'); ?>
                                </a>
                            </div>
                        <?php endif; ?>
                    </div>
                </article>
                <?php
            }
            
            if ($settings['display_type'] === 'carousel') {
                echo '</div>'; // Close swiper-wrapper
                
                // Add pagination if enabled
                if ($settings['show_dots'] === 'yes') {
                    echo '<div class="swiper-pagination"></div>';
                }
                
                // Add navigation arrows if enabled
                if ($settings['show_arrows'] === 'yes') {
                    echo '<div class="swiper-button-prev"></div>';
                    echo '<div class="swiper-button-next"></div>';
                }
                
                echo '</div>'; // Close swiper
                echo '</div>'; // Close mohtavanegar-carousel
            }
            
            echo '</div>';

            // Numeric Pagination for grid/list
            if ($want_pagination && $query->max_num_pages > 1) {
                $big = 999999999; // need an unlikely integer
                $pagination_links = paginate_links([
                    'base'      => str_replace($big, '%#%', esc_url(get_pagenum_link($big))),
                    'format'    => '?paged=%#%',
                    'current'   => $paged,
                    'total'     => $query->max_num_pages,
                    'type'      => 'array',
                    'prev_text' => __('« قبلی', 'mohtavanegar'),
                    'next_text' => __('بعدی »', 'mohtavanegar'),
                ]);
                if (!empty($pagination_links) && is_array($pagination_links)) {
                    echo '<nav class="mohtavanegar-pagination" aria-label="Pagination">';
                    foreach ($pagination_links as $link) {
                        // Ensure page-numbers class exists for styling controls
                        if (strpos($link, 'page-numbers') === false) {
                            $link = preg_replace('/<a /', '<a class="page-numbers" ', $link, 1);
                            $link = preg_replace('/<span /', '<span class="page-numbers" ', $link, 1);
                        }
                        echo $link;
                    }
                    echo '</nav>';
                }
            }
            
            wp_reset_postdata();
        } else {
            echo '<p>' . esc_html__('هیچ پستی یافت نشد.', 'mohtavanegar') . '</p>';
        }
    }
}
