<?php
if (!defined('ABSPATH')) {
    exit;
}

class Mohtavanegar_Working_Hours_Widget extends \Elementor\Widget_Base {

    public function get_name() {
        return 'mohtavanegar_working_hours';
    }

    public function get_title() {
        return esc_html__('ساعات کاری', 'mohtavanegar');
    }

    public function get_icon() {
        return 'eicon-clock-o';
    }

    public function get_categories() {
        return ['mohtavanegar'];
    }

    public function get_keywords() {
        return ['working', 'hours', 'schedule', 'time', 'ساعات', 'کاری'];
    }

    protected function register_controls() {
        // Content Section
        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('تنظیمات ساعات کاری', 'mohtavanegar'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__('عنوان', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__('ساعات کاری', 'mohtavanegar'),
            ]
        );

        $this->add_control(
            'hide_closed_days',
            [
                'label' => esc_html__('مخفی کردن روزهای تعطیل', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => esc_html__('بله', 'mohtavanegar'),
                'label_off' => esc_html__('خیر', 'mohtavanegar'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'layout_direction',
            [
                'label' => esc_html__('جهت چیدمان', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'rtl',
                'options' => [
                    'rtl' => esc_html__('راست به چپ', 'mohtavanegar'),
                    'ltr' => esc_html__('چپ به راست', 'mohtavanegar'),
                ],
            ]
        );

        $days = [
            'saturday' => esc_html__('شنبه', 'mohtavanegar'),
            'sunday' => esc_html__('یکشنبه', 'mohtavanegar'),
            'monday' => esc_html__('دوشنبه', 'mohtavanegar'),
            'tuesday' => esc_html__('سه شنبه', 'mohtavanegar'),
            'wednesday' => esc_html__('چهارشنبه', 'mohtavanegar'),
            'thursday' => esc_html__('پنجشنبه', 'mohtavanegar'),
            'friday' => esc_html__('جمعه', 'mohtavanegar'),
        ];

        foreach ($days as $day_id => $day_name) {
            $this->add_control(
                $day_id . '_status',
                [
                    'label' => esc_html__('وضعیت', 'mohtavanegar') . ' ' . $day_name,
                    'type' => \Elementor\Controls_Manager::SELECT,
                    'default' => $day_id === 'friday' ? 'closed' : 'open',
                    'options' => [
                        'open' => esc_html__('باز', 'mohtavanegar'),
                        'closed' => esc_html__('تعطیل', 'mohtavanegar'),
                    ],
                ]
            );

            $this->add_control(
                $day_id . '_hours',
                [
                    'label' => esc_html__('ساعات کاری', 'mohtavanegar') . ' ' . $day_name,
                    'type' => \Elementor\Controls_Manager::TEXT,
                    'default' => $day_id === 'thursday' ? '۱۱ صبح - ۷ عصر' : ($day_id === 'friday' ? '۱۰ صبح - ۲ بعد از ظهر' : '۹ صبح - ۵ عصر'),
                ]
            );
        }

        $this->end_controls_section();



        // Style Section
        $this->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('استایل', 'mohtavanegar'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('رنگ عنوان', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .working-hours-title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => esc_html__('تایپوگرافی عنوان', 'mohtavanegar'),
                'selector' => '{{WRAPPER}} .working-hours-title',
            ]
        );

        $this->add_control(
            'day_color',
            [
                'label' => esc_html__('رنگ روزها', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .working-day' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'hours_color',
            [
                'label' => esc_html__('رنگ ساعات', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .working-hours' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'closed_color',
            [
                'label' => esc_html__('رنگ روزهای تعطیل', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'default' => '#e74c3c',
                'selectors' => [
                    '{{WRAPPER}} .day-closed' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'days_typography',
                'label' => esc_html__('تایپوگرافی روزها', 'mohtavanegar'),
                'selector' => '{{WRAPPER}} .working-day',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
            [
                'name' => 'hours_typography',
                'label' => esc_html__('تایپوگرافی ساعات', 'mohtavanegar'),
                'selector' => '{{WRAPPER}} .working-hours',
            ]
        );

        $this->add_control(
            'divider_color',
            [
                'label' => esc_html__('رنگ جداکننده', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .working-hours-item:not(:last-child)' => 'border-bottom-color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();



        // Layout Section
        $this->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('چیدمان', 'mohtavanegar'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'item_layout',
            [
                'label' => esc_html__('ترتیب نمایش روز و ساعت', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'day_first',
                'options' => [
                    'day_first' => esc_html__('اول روز، بعد ساعت', 'mohtavanegar'),
                    'hours_first' => esc_html__('اول ساعت، بعد روز', 'mohtavanegar'),
                ],
            ]
        );

        $this->add_control(
            'text_align',
            [
                'label' => esc_html__('جهت نمایش متن', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('چپ', 'mohtavanegar'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('وسط', 'mohtavanegar'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('راست', 'mohtavanegar'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'right',
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .working-hours-widget' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'widget_padding',
            [
                'label' => esc_html__('فاصله داخلی', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .working-hours-widget' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'widget_margin',
            [
                'label' => esc_html__('فاصله خارجی', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .working-hours-widget' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        // Items Style Section
        $this->start_controls_section(
            'items_style_section',
            [
                'label' => esc_html__('استایل آیتم‌ها', 'mohtavanegar'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'item_background_color',
            [
                'label' => esc_html__('رنگ پس زمینه آیتم‌ها', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .working-hours-item' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'item_padding',
            [
                'label' => esc_html__('فاصله داخلی آیتم‌ها', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .working-hours-item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'top' => '10',
                    'right' => '10',
                    'bottom' => '10',
                    'left' => '10',
                    'unit' => 'px',
                    'isLinked' => true,
                ],
            ]
        );

        $this->add_control(
            'item_border_radius',
            [
                'label' => esc_html__('گردی گوشه‌های آیتم‌ها', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .working-hours-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_box_shadow',
                'label' => esc_html__('سایه آیتم‌ها', 'mohtavanegar'),
                'selector' => '{{WRAPPER}} .working-hours-item',
            ]
        );

        $this->add_responsive_control(
            'item_margin',
            [
                'label' => esc_html__('فاصله بین آیتم‌ها', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .working-hours-item' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'default' => [
                    'top' => '0',
                    'right' => '0',
                    'bottom' => '5',
                    'left' => '0',
                    'unit' => 'px',
                    'isLinked' => false,
                ],
            ]
        );

        $this->end_controls_section();

        // Background Section
        $this->start_controls_section(
            'background_section',
            [
                'label' => esc_html__('پس زمینه', 'mohtavanegar'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'widget_background',
                'label' => esc_html__('پس زمینه', 'mohtavanegar'),
                'types' => ['classic', 'gradient', 'video'],
                'selector' => '{{WRAPPER}} .working-hours-widget',
            ]
        );

        $this->add_control(
            'widget_border_radius',
            [
                'label' => esc_html__('گردی گوشه‌ها', 'mohtavanegar'),
                'type' => \Elementor\Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .working-hours-widget' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'widget_border',
                'label' => esc_html__('حاشیه', 'mohtavanegar'),
                'selector' => '{{WRAPPER}} .working-hours-widget',
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'widget_box_shadow',
                'label' => esc_html__('سایه', 'mohtavanegar'),
                'selector' => '{{WRAPPER}} .working-hours-widget',
            ]
        );

        $this->end_controls_section();


    }

    protected function render() {
        $settings = $this->get_settings_for_display();
        $days = [
            'saturday' => esc_html__('شنبه', 'mohtavanegar'),
            'sunday' => esc_html__('یکشنبه', 'mohtavanegar'),
            'monday' => esc_html__('دوشنبه', 'mohtavanegar'),
            'tuesday' => esc_html__('سه شنبه', 'mohtavanegar'),
            'wednesday' => esc_html__('چهارشنبه', 'mohtavanegar'),
            'thursday' => esc_html__('پنجشنبه', 'mohtavanegar'),
            'friday' => esc_html__('جمعه', 'mohtavanegar'),
        ];
        
        ?>
        <div class="working-hours-widget">
            <?php if (!empty($settings['title'])) : ?>
                <h3 class="working-hours-title"><?php echo esc_html($settings['title']); ?></h3>
            <?php endif; ?>
            
            <div class="working-hours-list" style="direction: <?php echo esc_attr($settings['layout_direction']); ?>;">
                <?php foreach ($days as $day_id => $day_name) : 
                    // Skip closed days if hide_closed_days is enabled
                    if ($settings['hide_closed_days'] === 'yes' && $settings[$day_id . '_status'] === 'closed') {
                        continue;
                    }
                ?>
                    <div class="working-hours-item">
                        <?php if ($settings['item_layout'] === 'day_first') : ?>
                            <span class="working-day"><?php echo esc_html($day_name); ?></span>
                            <?php if ($settings[$day_id . '_status'] === 'open') : ?>
                                <span class="working-hours"><?php echo esc_html($settings[$day_id . '_hours']); ?></span>
                            <?php else : ?>
                                <span class="working-hours day-closed"><?php echo esc_html__('تعطیل', 'mohtavanegar'); ?>
                                    <?php if (!empty($settings[$day_id . '_hours'])) : ?>
                                        <span class="closed-hours"> (<?php echo esc_html($settings[$day_id . '_hours']); ?>)</span>
                                    <?php endif; ?>
                                </span>
                            <?php endif; ?>
                        <?php else : ?>
                            <?php if ($settings[$day_id . '_status'] === 'open') : ?>
                                <span class="working-hours"><?php echo esc_html($settings[$day_id . '_hours']); ?></span>
                            <?php else : ?>
                                <span class="working-hours day-closed"><?php echo esc_html__('تعطیل', 'mohtavanegar'); ?>
                                    <?php if (!empty($settings[$day_id . '_hours'])) : ?>
                                        <span class="closed-hours"> (<?php echo esc_html($settings[$day_id . '_hours']); ?>)</span>
                                    <?php endif; ?>
                                </span>
                            <?php endif; ?>
                            <span class="working-day"><?php echo esc_html($day_name); ?></span>
                        <?php endif; ?>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        <style>
            .working-hours-widget {
                font-family: inherit;
                overflow: hidden;
                position: relative;
            }
            .working-hours-title {
                margin-bottom: 20px;
                text-align: center;
            }
            .working-hours-list {
                display: flex;
                flex-direction: column;
            }
            .working-hours-item {
                display: flex;
                justify-content: space-between;
                padding: 10px 0;
                border-bottom: 1px solid #eee;
                transition: all 0.3s ease;
            }
            .working-hours-item:last-child {
                border-bottom: none;
            }
            .working-hours-item:hover {
                transform: translateX(5px);
            }
            .working-day {
                font-weight: bold;
            }
            .day-closed {
                font-weight: bold;
            }
            .closed-hours {
                font-weight: normal;
                font-size: 0.9em;
                opacity: 0.8;
            }
            /* RTL/LTR specific styles */
            .working-hours-list[style*="direction: rtl"] .working-hours-item:hover {
                transform: translateX(5px);
            }
            .working-hours-list[style*="direction: ltr"] .working-hours-item:hover {
                transform: translateX(-5px);
            }
        </style>
        <?php
    }
}