jQuery(document).ready(function($) {
    'use strict';
    
    // Add hover class for better touch devices support
    $('.contact-item').on('touchstart', function() {
        $(this).addClass('hover');
    }).on('touchend', function() {
        $(this).removeClass('hover');
    });
    
    // Initialize tooltips if needed
    if (typeof $.fn.tooltip === 'function') {
        $('.contact-item[title]').tooltip();
    }
    
    // Add click animation
    $('.contact-item').on('mousedown', function() {
        $(this).addClass('active');
    }).on('mouseup mouseleave', function() {
        $(this).removeClass('active');
    });
});
