jQuery(document).ready(function ($) {
    $('.mn-floating-contact-wrapper').each(function () {
        var $wrapper = $(this);
        var $btn = $wrapper.find('.mn-floating-contact-main-btn');

        // Toggle menu on click
        $btn.on('click', function (e) {
            e.preventDefault();
            $wrapper.toggleClass('active');

            // Toggle icon rotation or switch if needed
            // Currently utilizing CSS classes for icon states if using FontAwesome 'fa-times' vs 'fa-phone' logic
            // But CSS already handles rotation.
        });

        // Close when clicking outside
        $(document).on('click', function (e) {
            if (!$(e.target).closest('.mn-floating-contact-wrapper').length) {
                $wrapper.removeClass('active');
            }
        });
    });
});
