jQuery(document).ready(function($) {
    // Debug: Check if script is loading
    console.log('Icon selector script loaded');
    
    // Font Awesome icon list (common icons)
    const fontAwesomeIcons = {
        solid: [
            'fas fa-star', 'fas fa-heart', 'fas fa-user', 'fas fa-home', 'fas fa-cog',
            'fas fa-search', 'fas fa-envelope', 'fas fa-phone', 'fas fa-map-marker-alt',
            'fas fa-calendar', 'fas fa-clock', 'fas fa-arrow-right', 'fas fa-arrow-left',
            'fas fa-arrow-up', 'fas fa-arrow-down', 'fas fa-check', 'fas fa-times',
            'fas fa-plus', 'fas fa-minus', 'fas fa-edit', 'fas fa-trash', 'fas fa-save',
            'fas fa-download', 'fas fa-upload', 'fas fa-print', 'fas fa-share',
            'fas fa-lock', 'fas fa-unlock', 'fas fa-key', 'fas fa-eye', 'fas fa-eye-slash',
            'fas fa-bell', 'fas fa-bookmark', 'fas fa-flag', 'fas fa-tag', 'fas fa-tags',
            'fas fa-folder', 'fas fa-file', 'fas fa-image', 'fas fa-video', 'fas fa-music',
            'fas fa-play', 'fas fa-pause', 'fas fa-stop', 'fas fa-volume-up',
            'fas fa-shopping-cart', 'fas fa-credit-card', 'fas fa-dollar-sign',
            'fas fa-gift', 'fas fa-trophy', 'fas fa-medal', 'fas fa-award',
            'fas fa-briefcase', 'fas fa-briefcase-medical', 'fas fa-stethoscope',
            'fas fa-hospital', 'fas fa-ambulance', 'fas fa-pills', 'fas fa-user-md',
            'fas fa-heartbeat', 'fas fa-lungs', 'fas fa-tooth', 'fas fa-thermometer',
            'fas fa-car', 'fas fa-plane', 'fas fa-ship', 'fas fa-train', 'fas fa-bus',
            'fas fa-bicycle', 'fas fa-motorcycle', 'fas fa-taxi', 'fas fa-truck',
            'fas fa-graduation-cap', 'fas fa-book', 'fas fa-library', 'fas fa-chalkboard',
            'fas fa-flask', 'fas fa-microscope', 'fas fa-atom', 'fas fa-rocket',
            'fas fa-satellite', 'fas fa-wifi', 'fas fa-bluetooth', 'fas fa-battery-full',
            'fas fa-signal', 'fas fa-globe', 'fas fa-cloud', 'fas fa-cloud-sun',
            'fas fa-sun', 'fas fa-moon', 'fas fa-snowflake', 'fas fa-fire',
            'fas fa-bolt', 'fas fa-wind', 'fas fa-water', 'fas fa-mountain',
            'fas fa-tree', 'fas fa-leaf', 'fas fa-seedling', 'fas fa-bug',
            'fas fa-fish', 'fas fa-dove', 'fas fa-crow', 'fas fa-cat', 'fas fa-dog',
            'fas fa-horse', 'fas fa-paw', 'fas fa-camera', 'fas fa-video',
            'fas fa-microphone', 'fas fa-headphones', 'fas fa-speaker', 'fas fa-tv',
            'fas fa-desktop', 'fas fa-laptop', 'fas fa-mobile', 'fas fa-tablet',
            'fas fa-database', 'fas fa-server', 'fas fa-network-wired', 'fas fa-code',
            'fas fa-terminal', 'fas fa-file-code', 'fas fa-file-pdf', 'fas fa-file-word',
            'fas fa-file-excel', 'fas fa-file-powerpoint', 'fas fa-file-archive',
            'fas fa-file-image', 'fas fa-file-video', 'fas fa-file-audio',
            'fas fa-chart-bar', 'fas fa-chart-line', 'fas fa-chart-pie', 'fas fa-table',
            'fas fa-list', 'fas fa-list-ul', 'fas fa-list-ol', 'fas fa-th',
            'fas fa-th-large', 'fas fa-grip-horizontal', 'fas fa-grip-vertical',
            'fas fa-ellipsis-h', 'fas fa-ellipsis-v', 'fas fa-ellipsis-v-alt',
            'fas fa-link', 'fas fa-unlink', 'fas fa-anchor', 'fas fa-chain',
            'fas fa-external-link-alt', 'fas fa-external-link-square-alt',
            'fas fa-compress', 'fas fa-expand', 'fas fa-compress-arrows-alt',
            'fas fa-expand-arrows-alt', 'fas fa-arrows-alt', 'fas fa-arrows-alt-h',
            'fas fa-arrows-alt-v', 'fas fa-arrows-alt', 'fas fa-sync', 'fas fa-sync-alt',
            'fas fa-redo', 'fas fa-redo-alt', 'fas fa-undo', 'fas fa-undo-alt',
            'fas fa-random', 'fas fa-shuffle', 'fas fa-retweet', 'fas fa-exchange-alt',
            'fas fa-repeat', 'fas fa-repeat-1', 'fas fa-repeat-1-alt',
            'fas fa-step-forward', 'fas fa-step-backward', 'fas fa-fast-forward',
            'fas fa-fast-backward', 'fas fa-eject', 'fas fa-backward',
            'fas fa-forward', 'fas fa-play-circle', 'fas fa-pause-circle',
            'fas fa-stop-circle', 'fas fa-volume-mute', 'fas fa-volume-off',
            'fas fa-volume-down', 'fas fa-headset', 'fas fa-microphone-slash',
            'fas fa-microphone-alt', 'fas fa-microphone-alt-slash',
            'fas fa-video-slash', 'fas fa-video-plus', 'fas fa-video-minus',
            'fas fa-video-times', 'fas fa-video-check', 'fas fa-video-arrow-up',
            'fas fa-video-arrow-down', 'fas fa-video-arrow-left', 'fas fa-video-arrow-right',
            'fas fa-video-play', 'fas fa-video-pause', 'fas fa-video-stop',
            'fas fa-video-slash', 'fas fa-video-plus', 'fas fa-video-minus',
            'fas fa-video-times', 'fas fa-video-check', 'fas fa-video-arrow-up',
            'fas fa-video-arrow-down', 'fas fa-video-arrow-left', 'fas fa-video-arrow-right'
        ],
        regular: [
            'far fa-star', 'far fa-heart', 'far fa-user', 'far fa-envelope',
            'far fa-calendar', 'far fa-clock', 'far fa-check', 'far fa-times',
            'far fa-plus', 'far fa-minus', 'far fa-edit', 'far fa-trash',
            'far fa-save', 'far fa-download', 'far fa-upload', 'far fa-print',
            'far fa-share', 'far fa-lock', 'far fa-unlock', 'far fa-key',
            'far fa-eye', 'far fa-eye-slash', 'far fa-bell', 'far fa-bookmark',
            'far fa-flag', 'far fa-tag', 'far fa-tags', 'far fa-folder',
            'far fa-file', 'far fa-image', 'far fa-video', 'far fa-music',
            'far fa-play', 'far fa-pause', 'far fa-stop', 'far fa-volume-up',
            'far fa-shopping-cart', 'far fa-credit-card', 'far fa-dollar-sign',
            'far fa-gift', 'far fa-trophy', 'far fa-medal', 'far fa-award',
            'far fa-briefcase', 'far fa-briefcase-medical', 'far fa-stethoscope',
            'far fa-hospital', 'far fa-ambulance', 'far fa-pills', 'far fa-user-md',
            'far fa-heartbeat', 'far fa-lungs', 'far fa-tooth', 'far fa-thermometer',
            'far fa-car', 'far fa-plane', 'far fa-ship', 'far fa-train', 'far fa-bus',
            'far fa-bicycle', 'far fa-motorcycle', 'far fa-taxi', 'far fa-truck',
            'far fa-graduation-cap', 'far fa-book', 'far fa-library', 'far fa-chalkboard',
            'far fa-flask', 'far fa-microscope', 'far fa-atom', 'far fa-rocket',
            'far fa-satellite', 'far fa-wifi', 'far fa-bluetooth', 'far fa-battery-full',
            'far fa-signal', 'far fa-globe', 'far fa-cloud', 'far fa-cloud-sun',
            'far fa-sun', 'far fa-moon', 'far fa-snowflake', 'far fa-fire',
            'far fa-bolt', 'far fa-wind', 'far fa-water', 'far fa-mountain',
            'far fa-tree', 'far fa-leaf', 'far fa-seedling', 'far fa-bug',
            'far fa-fish', 'far fa-dove', 'far fa-crow', 'far fa-cat', 'far fa-dog',
            'far fa-horse', 'far fa-paw', 'far fa-camera', 'far fa-video',
            'far fa-microphone', 'far fa-headphones', 'far fa-speaker', 'far fa-tv',
            'far fa-desktop', 'far fa-laptop', 'far fa-mobile', 'far fa-tablet',
            'far fa-database', 'far fa-server', 'far fa-network-wired', 'far fa-code',
            'far fa-terminal', 'far fa-file-code', 'far fa-file-pdf', 'far fa-file-word',
            'far fa-file-excel', 'far fa-file-powerpoint', 'far fa-file-archive',
            'far fa-file-image', 'far fa-file-video', 'far fa-file-audio',
            'far fa-chart-bar', 'far fa-chart-line', 'far fa-chart-pie', 'far fa-table',
            'far fa-list', 'far fa-list-ul', 'far fa-list-ol', 'far fa-th',
            'far fa-th-large', 'far fa-grip-horizontal', 'far fa-grip-vertical',
            'far fa-ellipsis-h', 'far fa-ellipsis-v', 'far fa-ellipsis-v-alt',
            'far fa-link', 'far fa-unlink', 'far fa-anchor', 'far fa-chain',
            'far fa-external-link-alt', 'far fa-external-link-square-alt',
            'far fa-compress', 'far fa-expand', 'far fa-compress-arrows-alt',
            'far fa-expand-arrows-alt', 'far fa-arrows-alt', 'far fa-arrows-alt-h',
            'far fa-arrows-alt-v', 'far fa-arrows-alt', 'far fa-sync', 'far fa-sync-alt',
            'far fa-redo', 'far fa-redo-alt', 'far fa-undo', 'far fa-undo-alt',
            'far fa-random', 'far fa-shuffle', 'far fa-retweet', 'far fa-exchange-alt',
            'far fa-repeat', 'far fa-repeat-1', 'far fa-repeat-1-alt',
            'far fa-step-forward', 'far fa-step-backward', 'far fa-fast-forward',
            'far fa-fast-backward', 'far fa-eject', 'far fa-backward',
            'far fa-forward', 'far fa-play-circle', 'far fa-pause-circle',
            'far fa-stop-circle', 'far fa-volume-mute', 'far fa-volume-off',
            'far fa-volume-down', 'far fa-headset', 'far fa-microphone-slash',
            'far fa-microphone-alt', 'far fa-microphone-alt-slash',
            'far fa-video-slash', 'far fa-video-plus', 'far fa-video-minus',
            'far fa-video-times', 'far fa-video-check', 'far fa-video-arrow-up',
            'far fa-video-arrow-down', 'far fa-video-arrow-left', 'far fa-video-arrow-right',
            'far fa-video-play', 'far fa-video-pause', 'far fa-video-stop',
            'far fa-video-slash', 'far fa-video-plus', 'far fa-video-minus',
            'far fa-video-times', 'far fa-video-check', 'far fa-video-arrow-up',
            'far fa-video-arrow-down', 'far fa-video-arrow-left', 'far fa-video-arrow-right'
        ],
        brands: [
            'fab fa-facebook', 'fab fa-twitter', 'fab fa-instagram', 'fab fa-linkedin',
            'fab fa-youtube', 'fab fa-google', 'fab fa-amazon', 'fab fa-apple',
            'fab fa-microsoft', 'fab fa-github', 'fab fa-wordpress', 'fab fa-drupal',
            'fab fa-joomla', 'fab fa-magento', 'fab fa-shopify', 'fab fa-bitbucket',
            'fab fa-docker', 'fab fa-figma', 'fab fa-sketch', 'fab fa-adobe',
            'fab fa-chrome', 'fab fa-firefox', 'fab fa-edge', 'fab fa-safari',
            'fab fa-opera', 'fab fa-android', 'fab fa-ios', 'fab fa-windows',
            'fab fa-linux', 'fab fa-ubuntu', 'fab fa-debian', 'fab fa-redhat',
            'fab fa-centos', 'fab fa-fedora', 'fab fa-archlinux', 'fab fa-gentoo',
            'fab fa-opensuse', 'fab fa-slackware', 'fab fa-mint', 'fab fa-kali-linux',
            'fab fa-parrot-os', 'fab fa-tails', 'fab fa-qubes-os', 'fab fa-whonix',
            'fab fa-tor', 'fab fa-vpn', 'fab fa-proxy', 'fab fa-firewall',
            'fab fa-antivirus', 'fab fa-malware', 'fab fa-ransomware', 'fab fa-phishing',
            'fab fa-spam', 'fab fa-scam', 'fab fa-fraud', 'fab fa-hack',
            'fab fa-cybersecurity', 'fab fa-penetration-testing', 'fab fa-ethical-hacking',
            'fab fa-bug-bounty', 'fab fa-vulnerability', 'fab fa-exploit', 'fab fa-zero-day',
            'fab fa-cve', 'fab fa-cvss', 'fab fa-owasp', 'fab fa-nist',
            'fab fa-iso', 'fab fa-iec', 'fab fa-ieee', 'fab fa-w3c',
            'fab fa-ietf', 'fab fa-rfc', 'fab fa-draft', 'fab fa-standard',
            'fab fa-protocol', 'fab fa-algorithm', 'fab fa-cryptography', 'fab fa-encryption',
            'fab fa-decryption', 'fab fa-hash', 'fab fa-signature', 'fab fa-certificate',
            'fab fa-pki', 'fab fa-ca', 'fab fa-ssl', 'fab fa-tls',
            'fab fa-http', 'fab fa-https', 'fab fa-ftp', 'fab fa-sftp',
            'fab fa-ssh', 'fab fa-rdp', 'fab fa-vnc', 'fab fa-radmin',
            'fab fa-teamviewer', 'fab fa-anydesk', 'fab fa-remote-desktop', 'fab fa-cloud-computing',
            'fab fa-aws', 'fab fa-azure', 'fab fa-google-cloud', 'fab fa-digital-ocean',
            'fab fa-vultr', 'fab fa-linode', 'fab fa-rackspace', 'fab fa-heroku',
            'fab fa-netlify', 'fab fa-vercel', 'fab fa-github-pages', 'fab fa-gitlab-pages',
            'fab fa-bitbucket-pages', 'fab fa-codeberg', 'fab fa-sourcehut', 'fab fa-sr.ht',
            'fab fa-gitea', 'fab fa-gogs', 'fab fa-phabricator', 'fab fa-reviewboard',
            'fab fa-jira', 'fab fa-trello', 'fab fa-asana', 'fab fa-basecamp',
            'fab fa-slack', 'fab fa-discord', 'fab fa-telegram', 'fab fa-signal',
            'fab fa-whatsapp', 'fab fa-messenger', 'fab fa-hangouts', 'fab fa-meet',
            'fab fa-zoom', 'fab fa-teams', 'fab fa-skype', 'fab fa-viber',
            'fab fa-line', 'fab fa-wechat', 'fab fa-qq', 'fab fa-weibo',
            'fab fa-renren', 'fab fa-tiktok', 'fab fa-snapchat', 'fab fa-pinterest',
            'fab fa-reddit', 'fab fa-hacker-news', 'fab fa-product-hunt', 'fab fa-indie-hackers',
            'fab fa-dev-to', 'fab fa-codepen', 'fab fa-jsfiddle', 'fab fa-repl-it',
            'fab fa-glitch', 'fab fa-stackblitz', 'fab fa-codesandbox', 'fab fa-stackoverflow',
            'fab fa-github', 'fab fa-gitlab', 'fab fa-bitbucket', 'fab fa-sourceforge',
            'fab fa-launchpad', 'fab fa-gnu', 'fab fa-fsf', 'fab fa-osi',
            'fab fa-creative-commons', 'fab fa-cc-by', 'fab fa-cc-sa', 'fab fa-cc-nd',
            'fab fa-cc-nc', 'fab fa-cc-zero', 'fab fa-public-domain', 'fab fa-copyleft',
            'fab fa-copyright', 'fab fa-trademark', 'fab fa-registered', 'fab fa-patent'
        ]
    };

    let currentCategory = 'all';
    let selectedIcon = '';

    // Initialize icon grid
    function loadIcons(category = 'all') {
        const $iconGrid = $('#icon_grid');
        $iconGrid.empty();

        let iconsToShow = [];
        
        if (category === 'all') {
            iconsToShow = [...fontAwesomeIcons.solid, ...fontAwesomeIcons.regular, ...fontAwesomeIcons.brands];
        } else if (fontAwesomeIcons[category]) {
            iconsToShow = fontAwesomeIcons[category];
        }

        console.log('Loading icons:', iconsToShow.length, 'icons for category:', category); // Debug log

        iconsToShow.forEach(icon => {
            const $iconItem = $('<div class="icon-item" data-icon="' + icon + '">' +
                '<i class="' + icon + '"></i>' +
                '<span class="icon-name">' + icon + '</span>' +
                '</div>');
            $iconGrid.append($iconItem);
        });

        console.log('Icons loaded in DOM:', $('.icon-item').length); // Debug log
    }

    // Icon selection handler
    function selectIcon(iconClass) {
        console.log('Icon selected:', iconClass); // Debug log
        
        // Update input field
        $('#service_icon').val(iconClass).trigger('change');
        
        // Update preview
        const $preview = $('#selected_icon_preview');
        $preview.html('<i class="' + iconClass + '" style="font-size: 24px; margin-right: 10px;"></i>' +
            '<span>' + iconClass + '</span>');
        
        // Close modal
        $('#icon_selector_modal').hide();
        
        // Add visual feedback
        $('#service_icon').addClass('updated');
        setTimeout(function() {
            $('#service_icon').removeClass('updated');
        }, 1000);
    }

    // Open modal
    $('#icon_selector_btn').on('click', function() {
        console.log('Modal button clicked'); // Debug log
        $('#icon_selector_modal').show();
        loadIcons(currentCategory);
        
        // Add direct click handler as backup
        setTimeout(function() {
            $('.icon-item').off('click').on('click', function(e) {
                e.preventDefault();
                e.stopPropagation();
                
                const iconClass = $(this).data('icon');
                selectIcon(iconClass);
            });
        }, 100);
    });

    // Close modal
    $('.icon-modal-close, .icon-modal-overlay').on('click', function() {
        $('#icon_selector_modal').hide();
    });

    // Category filter
    $('.icon-category-btn').on('click', function() {
        $('.icon-category-btn').removeClass('active');
        $(this).addClass('active');
        currentCategory = $(this).data('category');
        loadIcons(currentCategory);
        
        // Re-attach click handlers after loading new icons
        setTimeout(function() {
            $('.icon-item').off('click').on('click', function(e) {
                e.preventDefault();
                e.stopPropagation();
                
                const iconClass = $(this).data('icon');
                selectIcon(iconClass);
            });
        }, 100);
    });

    // Search functionality
    $('#icon_search').on('input', function() {
        const searchTerm = $(this).val().toLowerCase();
        $('.icon-item').each(function() {
            const iconName = $(this).find('.icon-name').text().toLowerCase();
            if (iconName.includes(searchTerm)) {
                $(this).show();
            } else {
                $(this).hide();
            }
        });
    });

    // Icon selection (delegated)
    $(document).on('click', '.icon-item', function(e) {
        e.preventDefault();
        e.stopPropagation();
        
        const iconClass = $(this).data('icon');
        selectIcon(iconClass);
    });

    // Close modal on ESC key
    $(document).on('keydown', function(e) {
        if (e.keyCode === 27) { // ESC key
            $('#icon_selector_modal').hide();
        }
    });

    // Prevent modal close when clicking inside modal content
    $('.icon-modal-content').on('click', function(e) {
        e.stopPropagation();
    });
});
