<?php
/**
 * The template for displaying comments
 *
 * This is the template that displays the area of the page that contains both the current comments
 * and the comment form.
 *
 * @package Stand_Alone_Project
 */

/*
 * If the current post is protected by a password and the visitor has not yet
 * entered the password we will return early without loading the comments.
 */
if ( post_password_required() ) {
	return;
}
?>

<div id="comments" class="comments-area">

    <?php if ( have_comments() ) : ?>
        <div class="comments-header">
            <h2 class="comments-title">
                <i class="fas fa-comments"></i>
                <?php
                $comments_number = get_comments_number();
                if ( '1' === $comments_number ) {
                    printf( esc_html__( 'یک دیدگاه برای "%s"', 'mohtavanegar' ), '<span>' . get_the_title() . '</span>' );
                } else {
                    printf( 
                        esc_html( _nx( '%1$s دیدگاه برای "%2$s"', '%1$s دیدگاه برای "%2$s"', $comments_number, 'comments title', 'mohtavanegar' ) ),
                        number_format_i18n( $comments_number ),
                        '<span>' . get_the_title() . '</span>'
                    );
                }
                ?>
            </h2>
        </div>

        <ul class="comment-list">
            <?php
            wp_list_comments( array(
                'style'       => 'ul',
                'short_ping'  => true,
                'avatar_size' => 60,
                'callback'    => 'mohtavanegar_comment_callback',
            ) );
            ?>
        </ul>

        <?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) : ?>
            <nav class="navigation comment-navigation" role="navigation">
                <h2 class="screen-reader-text"><?php esc_html_e( 'Comment navigation', 'mohtavanegar' ); ?></h2>
                <div class="nav-links">
                    <div class="nav-previous"><?php previous_comments_link( esc_html__( 'دیدگاه‌های قدیمی‌تر', 'mohtavanegar' ) ); ?></div>
                    <div class="nav-next"><?php next_comments_link( esc_html__( 'دیدگاه‌های جدیدتر', 'mohtavanegar' ) ); ?></div>
                </div>
            </nav>
        <?php endif; ?>

    <?php endif; ?>

    <?php if ( ! comments_open() && get_comments_number() && post_type_supports( get_post_type(), 'comments' ) ) : ?>
        <p class="no-comments"><?php esc_html_e( 'دیدگاه‌ها بسته شده‌اند.', 'mohtavanegar' ); ?></p>
    <?php endif; ?>

    <?php
    $commenter = wp_get_current_commenter();
    $req = get_option( 'require_name_email' );
    $aria_req = ( $req ? " aria-required='true'" : '' );

    $fields = array(
        'author' => '<div class="comment-form-author-email-wrapper"><p class="comment-form-author">' .
                    '<label for="author">' . esc_html__( 'نام شما', 'mohtavanegar' ) . ( $req ? ' <span class="required">*</span>' : '' ) . '</label> ' .
                    '<input id="author" name="author" type="text" value="' . esc_attr( $commenter['comment_author'] ) . '" size="30"' . $aria_req . ' placeholder="' . esc_attr__( 'نام خود را وارد کنید...', 'mohtavanegar' ) . '" /></p>',
        'email'  => '<p class="comment-form-email">' .
                    '<label for="email">' . esc_html__( 'ایمیل شما', 'mohtavanegar' ) . ( $req ? ' <span class="required">*</span>' : '' ) . '</label> ' .
                    '<input id="email" name="email" type="email" value="' . esc_attr( $commenter['comment_author_email'] ) . '" size="30"' . $aria_req . ' placeholder="' . esc_attr__( 'ایمیل خود را وارد کنید...', 'mohtavanegar' ) . '" /></p></div>',
    );

    comment_form( array(
        'fields'               => $fields,
        'comment_field'        => '<p class="comment-form-comment"><label for="comment">' . esc_html__( 'دیدگاه شما', 'mohtavanegar' ) . '</label><textarea id="comment" name="comment" cols="45" rows="8" aria-required="true" placeholder="' . esc_attr__( 'متن دیدگاه خود را اینجا بنویسید...', 'mohtavanegar' ) . '"></textarea></p>',
        'title_reply'          => esc_html__( 'ارسال دیدگاه', 'mohtavanegar' ),
        'title_reply_to'       => esc_html__( 'پاسخ به %s', 'mohtavanegar' ),
        'cancel_reply_link'    => esc_html__( 'لغو پاسخ', 'mohtavanegar' ),
        'label_submit'         => esc_html__( 'ثبت دیدگاه', 'mohtavanegar' ),
        'submit_button'        => '<button name="%1$s" type="submit" id="%2$s" class="%3$s">%4$s <i class="fas fa-paper-plane"></i></button>',
        'submit_field'         => '<p class="form-submit">%1$s %2$s</p>',
        'class_submit'         => 'submit-btn',
    ) );
    ?>

</div>

<style>
/* Modern Comments Styling */
.comments-area {
    margin: 4rem auto;
    padding: 2.5rem;
    background: #ffffff;
    border-radius: 20px;
    box-shadow: 0 10px 40px rgba(0, 0, 0, 0.04);
    font-family: 'Vazirmatn', sans-serif;
    direction: rtl;
}

.comments-header {
    margin-bottom: 2.5rem;
    padding-bottom: 1.5rem;
    border-bottom: 2px solid #f1f4f8;
}

.comments-title {
    font-size: 1.6rem;
    font-weight: 800;
    color: #1a202c;
    display: flex;
    align-items: center;
    gap: 12px;
}

.comments-title i {
    color: #3182ce;
    font-size: 1.3rem;
}

.comment-list {
    list-style: none;
    padding: 0;
    margin: 0;
}

.comment-list .children {
    list-style: none;
    padding-right: 2.5rem; /* Indentation for threaded comments */
    margin-top: 1.5rem;
    border-right: 2px solid #edf2f7;
}

.comment-body {
    background: #f8fafc;
    padding: 1.5rem;
    border-radius: 16px;
    margin-bottom: 1.5rem;
    transition: all 0.3s ease;
    border: 1px solid #e2e8f0;
}

.comment-body:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 20px rgba(0, 0, 0, 0.05);
    background: #ffffff;
    border-color: #cbd5e0;
}

.comment-meta {
    margin-bottom: 1rem;
}

.comment-author.vcard {
    display: flex;
    align-items: center;
    gap: 15px;
}

.comment-author img {
    border-radius: 12px;
    box-shadow: 0 4px 10px rgba(0, 0, 0, 0.08);
}

.comment-author-info {
    display: flex;
    flex-direction: column;
}

.comment-author cite.fn {
    font-style: normal;
    font-weight: 700;
    font-size: 1.1rem;
    color: #2d3748;
}

.comment-author cite.fn a {
    color: inherit;
    text-decoration: none;
}

.comment-metadata {
    font-size: 0.85rem;
    color: #718096;
    margin-top: 2px;
}

.comment-metadata a {
    color: inherit;
    text-decoration: none;
}

.comment-content {
    font-size: 1rem;
    line-height: 1.8;
    color: #4a5568;
    margin-bottom: 1rem;
}

.reply {
    display: flex;
    gap: 15px;
    align-items: center;
}

.comment-reply-link, .edit-link a {
    display: inline-flex;
    align-items: center;
    gap: 6px;
    font-size: 0.9rem;
    font-weight: 600;
    color: #3182ce;
    text-decoration: none;
    padding: 6px 14px;
    background: #ebf8ff;
    border-radius: 8px;
    transition: all 0.2s ease;
}

.comment-reply-link:hover, .edit-link a:hover {
    background: #3182ce;
    color: #ffffff;
}

.comment-awaiting-moderation {
    display: block;
    font-size: 0.85rem;
    color: #e53e3e;
    font-style: italic;
    margin-top: 10px;
    background: #fff5f5;
    padding: 5px 12px;
    border-radius: 6px;
}

/* Comment Form Styling */
.comment-respond {
    margin-top: 4rem;
    padding: 2.5rem;
    background: #fdfdfd;
    border-radius: 20px;
    border: 2px dashed #e2e8f0;
}

.comment-reply-title {
    font-size: 1.4rem;
    font-weight: 800;
    color: #1a202c;
    margin-bottom: 2rem;
}

#cancel-comment-reply-link {
    font-size: 0.9rem;
    color: #e53e3e;
    margin-right: 15px;
    font-weight: normal;
    text-decoration: underline;
}

.comment-form-author-email-wrapper {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 20px;
    margin-bottom: 15px;
}

.comment-form p {
    margin-bottom: 1.5rem;
}

.comment-form label {
    display: block;
    font-weight: 700;
    color: #4a5568;
    margin-bottom: 8px;
    font-size: 0.95rem;
}

.comment-form input[type="text"],
.comment-form input[type="email"],
.comment-form textarea {
    width: 100%;
    padding: 12px 18px;
    border-radius: 12px;
    border: 1px solid #cbd5e0;
    background: #ffffff;
    font-family: inherit;
    font-size: 1rem;
    transition: all 0.3s ease;
    box-sizing: border-box;
}

.comment-form input:focus,
.comment-form textarea:focus {
    outline: none;
    border-color: #3182ce;
    box-shadow: 0 0 0 4px rgba(49, 130, 206, 0.1);
}

.submit-btn {
    display: inline-flex;
    align-items: center;
    gap: 10px;
    background: linear-gradient(135deg, #3182ce 0%, #2b6cb0 100%);
    color: #ffffff;
    border: none;
    padding: 14px 35px;
    border-radius: 12px;
    font-size: 1.1rem;
    font-weight: 700;
    cursor: pointer;
    transition: all 0.3s ease;
    box-shadow: 0 4px 15px rgba(49, 130, 206, 0.3);
}

.submit-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(49, 130, 206, 0.4);
}

.submit-btn i {
    font-size: 0.9rem;
    transition: transform 0.3s ease;
}

.submit-btn:hover i {
    transform: translate(-4px, -4px);
}

@media (max-width: 768px) {
    .comments-area {
        padding: 1.5rem;
        margin: 2rem 10px;
    }
    .comment-form-author-email-wrapper {
        grid-template-columns: 1fr;
    }
    .comment-list .children {
        padding-right: 1.2rem;
    }
}
</style>
