<?php
/**
 * Stand Alone Project Theme Functions
 *
 * @package Stand_Alone_Project
 */

if (!defined('ABSPATH')) {
    exit;
}

// Define theme version
if (!defined('STAND_ALONE_PROJECT_VERSION')) {
    define('STAND_ALONE_PROJECT_VERSION', '1.0.0');
}

// Include theme updater only on themes admin page
add_action('load-themes.php', function() {
    require_once get_template_directory() . '/updater.php';
});
require_once get_template_directory() . '/shortcodes/lang-url.php';

/*
add_filter('pre_http_request', function( $pre, $args, $url ) {
    // بلاک ریکوئست‌های المنتور
    if ( strpos( $url, 'https://my.elementor.com/api/v2/info/' ) === 0 ) {
        return new WP_Error(
            'blocked_elementor_info_request',
            'Request to my.elementor.com/api/v2/info blocked by theme.'
        );
    }

    // بلاک ریکوئست‌های Chaty Pro به go.premio.io
    if ( strpos( $url, 'https://go.premio.io/' ) === 0 ) {
        return new WP_Error(
            'blocked_go_premio_request',
            'Request to go.premio.io blocked by theme.'
        );
    }

    return $pre;
}, 10, 3);
*/
// Theme Setup
function mohtavanegar_setup() {
    add_theme_support('title-tag');
    add_theme_support('post-thumbnails');
    add_theme_support('elementor');
    add_theme_support('custom-logo', array(
        'height'      => 100,
        'width'       => 400,
        'flex-height' => true,
        'flex-width'  => true,
        'header-text' => array('site-title', 'site-description'),
    ));
    
    // Add WooCommerce support only if WooCommerce is active
    if (class_exists('WooCommerce')) {
        add_theme_support('woocommerce');
    }
    
    register_nav_menus(array(
        'primary' => esc_html__('Primary Menu', 'mohtavanegar'),
        'footer' => esc_html__('Footer Menu', 'mohtavanegar'),
    ));
}
add_action('after_setup_theme', 'mohtavanegar_setup');

// Enqueue scripts and styles
function mohtavanegar_scripts() {
    // Add resource hints
    add_action('wp_head', function() {
        // Preconnect to required origins
        echo '<link rel="preconnect" href="' . esc_url(site_url()) . '">';
        echo '<link rel="dns-prefetch" href="' . esc_url(site_url()) . '">';
        
        // Preload critical CSS
        echo '<link rel="preload" href="' . get_stylesheet_uri() . '" as="style">';
        
        // Add critical CSS inline
        $critical_css = file_get_contents(get_template_directory() . '/css/critical.css');
        if ($critical_css) {
            echo '<style id="mohtavanegar-critical-css">' . $critical_css . '</style>';
        }
    }, 1);

    // Dequeue unnecessary styles
    wp_dequeue_style('wp-block-library');
    wp_dequeue_style('wp-embed');
    
    // Enqueue Font Awesome for header icons
//    wp_enqueue_style('font-awesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css', array(), '5.15.4');
    wp_enqueue_style('qa-widget-style',get_template_directory_uri() . '/assets/css/qa-widget.css', array(), '1.0.0');
    
   
    // Enqueue main stylesheet with media="print" and onload
    wp_enqueue_style('mohtavanegar-style', get_stylesheet_uri(), array(), '1.0');
    add_filter('style_loader_tag', function($tag, $handle) {
        if ($handle === 'mohtavanegar-style') {
            return str_replace("rel='stylesheet'", "rel='stylesheet' media='print' onload='this.media=\"all\"'", $tag);
        }
        return $tag;
    }, 10, 2);
    
    // Enqueue taxonomy services CSS for services_category taxonomy pages
    if (is_tax('services_category')) {
        wp_enqueue_style(
            'mohtavanegar-taxonomy-services', 
            get_template_directory_uri() . '/assets/css/taxonomy-services.css', 
            array(), 
            '1.0'
        );
    }

    // Add Font Awesome for icons (Loaded globally for comments and other UI elements)
    wp_enqueue_style(
        'font-awesome',
        get_template_directory_uri() .'/assets/css/font-awesome.css',
        array(),
        '5.15.4'
    );

    // Enqueue scripts
    wp_enqueue_script('mohtavanegar-script', get_template_directory_uri() . '/js/main.js', array('jquery'), '1.0', true);
    
    // Enqueue SweetAlert2
    wp_enqueue_script('sweetalert2', get_template_directory_uri() . '/assets/js/sweetalert2.all.min.js', array(), '11.0.0', true);
    wp_enqueue_style('sweetalert2',  get_template_directory_uri() .'/assets/css/sweetalert2.min.css', array(), '11.0.0');
    
}
add_action('wp_enqueue_scripts', 'mohtavanegar_scripts');

// Include Settings Files
function mohtavanegar_load_required_files() {
    // فایل‌های اصلی
    require_once get_template_directory() . '/settings/header-settings.php';
    require_once get_template_directory() . '/settings/footer-settings.php';
    require_once get_template_directory() . '/settings/template-settings.php';
    require_once get_template_directory() . '/settings/services-post-type.php'; // شامل نمونه کارها و سرویس‌ها
    require_once get_template_directory() . '/settings/taxonomy-icons.php';
    require_once get_template_directory() . '/settings/qa-post-type.php';
    require_once get_template_directory() . '/settings/reviews-post-type.php';
    require_once get_template_directory() . '/settings/video-gallery-post-type.php';
    require_once get_template_directory() . '/maintenance-mode.php';
    
    // افزودن تاریخ شمسی در صورت فعال بودن در تنظیمات
    $basic_settings = get_option('basic_settings', array());
    if (isset($basic_settings['jalali_date']) && $basic_settings['jalali_date'] == 1) {
        require_once get_template_directory() . '/inc/jalali-date.php';
    }
    
    // فایل‌های ادمین
    if (is_admin()) {
        require_once get_template_directory() . '/settings/theme-settings.php';
        require_once get_template_directory() . '/settings/import-export.php';
        require_once get_template_directory() . '/settings/ready-templates.php';
    }

    // فایل‌های ویجت المنتور
    if (class_exists('\Elementor\Plugin')) {
        require_once get_template_directory() . '/widgets/elementor/elementor-widgets.php';
    }
}
add_action('after_setup_theme', 'mohtavanegar_load_required_files');

// Optimize Elementor CSS loading
function mohtavanegar_optimize_elementor_css() {
    if (!class_exists('\Elementor\Plugin')) {
        return;
    }
    
    // Dequeue Elementor CSS files that are not needed
    wp_dequeue_style('elementor-frontend');
    wp_dequeue_style('elementor-global');
    
    // Enqueue only necessary Elementor CSS
    wp_enqueue_style('elementor-frontend', plugins_url('elementor/assets/css/frontend.min.css'), array(), ELEMENTOR_VERSION);
}
add_action('wp_enqueue_scripts', 'mohtavanegar_optimize_elementor_css', 20);

/**
 * Replace WordPress admin login logo with custom logo
 */
function mohtavanegar_custom_login_logo() {
    $logo_url = get_stylesheet_directory_uri() . '/assets/img/logo.webp';
    ?>
    <style type="text/css">
        body.login div#login h1 {
            display: block;
            margin-bottom: 25px;
        }
        body.login div#login h1 a {
            background-image: url('<?php echo esc_url($logo_url); ?>') !important;
            background-size: contain;
            background-position: center center;
            background-repeat: no-repeat;
            width: 320px;
            height: 120px;
            margin: 0 auto 25px;
            padding: 0;
            overflow: hidden;
            text-indent: -9999px;
            outline: 0;
            display: block;
        }
        .rtl body.login div#login h1 a {
            margin: 0 auto 25px;
        }
        .login h1 a:before {
            display: none !important;
        }
    </style>
    <?php
}
add_action('login_enqueue_scripts', 'mohtavanegar_custom_login_logo');

// Update login logo URL to site URL
function mohtavanegar_login_logo_url() {
    return home_url();
}
add_filter('login_headerurl', 'mohtavanegar_login_logo_url');

// Update login logo title to site name
function mohtavanegar_login_logo_url_title() {
    return get_bloginfo('name');
}
add_filter('login_headertext', 'mohtavanegar_login_logo_url_title');

/**
 * Ensure timestamps are properly converted to integers
 * Fix for 'gmdate(): Argument #2 ($timestamp) must be of type ?int, string given' error
 */
add_filter('get_the_time', function($the_time, $d, $post) {
    if ($d === 'U') {
        return (int) $the_time; // Ensure Unix timestamp is returned as integer
    }
    return $the_time;
}, 10, 3);

function allow_svg_upload($mimes) {
  $mimes['svg'] = 'image/svg+xml';
  return $mimes;
}
add_filter('upload_mimes', 'allow_svg_upload');
function cc_mime_types($mimes) {
  $mimes['svg'] = 'image/svg+xml';
  return $mimes;
}
add_filter('upload_mimes', 'cc_mime_types');
/*
function fix_svg_display() {
  echo '<style>img[src$=".svg"] { width: 100% !important; height: auto !important; }</style>';
}
add_action('admin_head', 'fix_svg_display');
*/

// حذف فیلد URL از فرم دیدگاه‌ها
function remove_comment_url_field($fields) {
    unset($fields['url']);
    return $fields;
}
add_filter('comment_form_default_fields', 'remove_comment_url_field');

// افزودن فیلد مخفی Honeypot به فرم دیدگاه
function add_honeypot_field() {
    echo '<p class="comment-form-honeypot" style="display:none;">
        <label for="hp_email">اگر انسان هستید این فیلد را خالی بگذارید</label>
        <input type="text" name="hp_email" id="hp_email" value="" />
    </p>';
}
add_action('comment_form', 'add_honeypot_field');

// بررسی پر شدن honeypot و جلوگیری از ارسال اسپم
function check_honeypot_field($commentdata) {
    if (!empty($_POST['hp_email'])) {
        wp_die('اسپم شناسایی شد. ارسال نظر ناموفق بود 🚫');
    }
    return $commentdata;
}
add_filter('preprocess_comment', 'check_honeypot_field');

// AJAX handler for QA pagination
function mohtavanegar_qa_pagination_ajax() {
    // Verify nonce
    if (!wp_verify_nonce($_POST['nonce'], 'qa_submit_nonce')) {
        wp_die('Security check failed');
    }

    $widget_id = intval($_POST['widget_id']);
    $page = intval($_POST['page']);
    $settings = $_POST['settings'];

    // Sanitize settings
    $filter_by_service = sanitize_text_field($settings['filter_by_service']);
    $specific_service = intval($settings['specific_service']);
    $posts_per_page = intval($settings['posts_per_page']);
    $enable_pagination = boolval($settings['enable_pagination']);
    $comments_title = sanitize_text_field($settings['comments_title']);
    $search_query = '';
    if (isset($settings['search'])) {
        $search_query = sanitize_text_field($settings['search']);
    }

    $args = array(
        'post_type'      => 'qa_comment',
        'post_status'    => 'publish',
        'posts_per_page' => $posts_per_page,
        'paged'          => $page,
        'orderby'        => 'date',
        'order'          => 'DESC',
    );

    // Add service filter if specific service is selected
    if ($filter_by_service === 'specific' && $specific_service) {
        $args['meta_query'] = array(
            array(
                'key'     => '_qa_service',
                'value'   => $specific_service,
                'compare' => '=',
            ),
        );
    }

    // If search term provided, augment query to search in title and _qa_answer meta
    if (!empty($search_query)) {
        // Title search via 's'
        $args['s'] = $search_query;

        // Also search in answer meta using meta_query OR relation
        $meta_queries = array(
            'relation' => 'OR',
            array(
                'key'     => '_qa_answer',
                'value'   => $search_query,
                'compare' => 'LIKE',
            ),
        );

        if (!empty($args['meta_query'])) {
            // Combine existing meta query with answer search
            $args['meta_query'] = array(
                'relation' => 'AND',
                $args['meta_query'],
                $meta_queries,
            );
        } else {
            $args['meta_query'] = $meta_queries;
        }
    }

    $comments = new WP_Query($args);

    ob_start();

    if ($comments->have_posts()) :
        echo '<div class="qa-accordion">';
        
        while ($comments->have_posts()) : $comments->the_post();
            $name = get_post_meta(get_the_ID(), '_qa_name', true);
            $question = get_the_title();
            $answer = get_post_meta(get_the_ID(), '_qa_answer', true);
            $date = get_the_date('Y-m-d');
            ?>
            <div class="qa-accordion-item">
                <div class="qa-accordion-header">
                    <div class="qa-accordion-title"><?php echo esc_html($question); ?></div>
                    <div class="qa-accordion-icon"></div>
                </div>
                
                <div class="qa-accordion-content">
                    <div class="qa-accordion-question">
                        <strong><?php echo esc_html__('پرسش:', 'mohtavanegar'); ?></strong>
                        <?php echo esc_html($question); ?>
                    </div>
                    
                    <?php if (!empty($answer)) : ?>
                        <div class="qa-accordion-answer">
                            <strong><?php echo esc_html__('پاسخ:', 'mohtavanegar'); ?></strong>
                            <div class="qa-answer-content">
                                <?php echo wpautop(wp_kses_post($answer)); ?>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
            <?php
        endwhile;
        
        echo '</div>';
        
        // For non-AJAX traditional pagination we do nothing here (widget handles output on first render)
        
        wp_reset_postdata();
    else :
        echo '<div class="qa-no-comments">' . '</div>';
    endif;

    $html = ob_get_clean();

    wp_send_json_success(array(
        'html' => $html,
        'max_pages' => $comments->max_num_pages
    ));
}
add_action('wp_ajax_mohtavanegar_qa_pagination', 'mohtavanegar_qa_pagination_ajax');
add_action('wp_ajax_nopriv_mohtavanegar_qa_pagination', 'mohtavanegar_qa_pagination_ajax');

// AJAX handler for Video Gallery pagination
function mohtavanegar_video_gallery_pagination_ajax() {
    // Verify nonce
    if (!isset($_POST['nonce']) || !wp_verify_nonce($_POST['nonce'], 'video_gallery_nonce')) {
        wp_send_json_error('Security check failed');
    }

    $page = isset($_POST['page']) ? intval($_POST['page']) : 1;
    $settings = isset($_POST['settings']) ? $_POST['settings'] : [];
    
    if (empty($settings)) {
        wp_send_json_error('Settings missing');
    }

    $args = [
        'post_type' => 'video_gallery',
        'posts_per_page' => (int) ($settings['items_limit'] ?: 6),
        'paged' => $page,
    ];

    if (!empty($settings['select_category'])) {
        $args['tax_query'] = [
            [
                'taxonomy' => 'video_category',
                'field'    => 'term_id',
                'terms'    => $settings['select_category'],
            ],
        ];
    }

    if (isset($settings['query_source']) && 'related' === $settings['query_source']) {
        $current_post_id = isset($_POST['current_post_id']) ? intval($_POST['current_post_id']) : 0;
        if ($current_post_id) {
            $current_title = get_the_title($current_post_id);
            if ($current_title) {
                // Broaden search: Split title into keywords, filter out short words
                $keywords = explode(' ', $current_title);
                $filtered_keywords = array_filter($keywords, function($word) {
                    return mb_strlen($word) > 3;
                });
                
                if (!empty($filtered_keywords)) {
                    $args['s'] = implode(' ', array_slice($filtered_keywords, 0, 4));
                } else {
                    $args['s'] = $current_title;
                }

                if (get_post_type($current_post_id) === 'video_gallery') {
                    $args['post__not_in'] = [$current_post_id];
                }
            }
        }
    } elseif (isset($settings['query_source']) && 'manual_search' === $settings['query_source'] && !empty($settings['manual_search_term'])) {
        $args['s'] = $settings['manual_search_term'];
    } elseif (isset($settings['query_source']) && 'manual_selection' === $settings['query_source'] && !empty($settings['select_videos'])) {
        $args['post__in'] = $settings['select_videos'];
        $args['orderby'] = 'post__in';
        unset($args['posts_per_page']);
    }

    $query = new \WP_Query($args);

    ob_start();
    if (class_exists('Video_Gallery_Widget')) {
        \Video_Gallery_Widget::render_video_items($query, $settings);
    }
    $html = ob_get_clean();

    ob_start();
    if ($query->max_num_pages > 1) {
        echo paginate_links(array(
            'base'         => '#',
            'format'       => '',
            'current'      => $page,
            'total'        => $query->max_num_pages,
            'prev_text'    => '<i class="fas fa-chevron-right"></i>',
            'next_text'    => '<i class="fas fa-chevron-left"></i>',
            'type'         => 'plain',
        ));
    }
    $pagination = ob_get_clean();

    wp_send_json_success([
        'html' => $html,
        'pagination' => $pagination,
        'max_pages' => $query->max_num_pages
    ]);
}
add_action('wp_ajax_mohtavanegar_video_gallery_pagination', 'mohtavanegar_video_gallery_pagination_ajax');
add_action('wp_ajax_nopriv_mohtavanegar_video_gallery_pagination', 'mohtavanegar_video_gallery_pagination_ajax');

/**
 * Custom Comment Listing Callback
 */
function mohtavanegar_comment_callback($comment, $args, $depth) {
    $GLOBALS['comment'] = $comment;
    ?>
    <li <?php comment_class(empty($args['has_children']) ? '' : 'parent'); ?> id="comment-<?php comment_ID(); ?>">
        <div id="div-comment-<?php comment_ID(); ?>" class="comment-body">
            <div class="comment-meta">
                <div class="comment-author vcard">
                    <?php if (0 != $args['avatar_size']) echo get_avatar($comment, $args['avatar_size']); ?>
                    <div class="comment-author-info">
                        <?php printf(esc_html__('%s', 'mohtavanegar'), sprintf('<cite class="fn">%s</cite>', get_comment_author_link())); ?>
                        <div class="comment-metadata">
                            <a href="<?php echo esc_url(get_comment_link($comment->comment_ID)); ?>">
                                <time datetime="<?php comment_time('c'); ?>">
                                    <?php printf(esc_html__('%1$s در %2$s', 'mohtavanegar'), get_comment_date(), get_comment_time()); ?>
                                </time>
                            </a>
                        </div>
                    </div>
                </div>

                <?php if ('0' == $comment->comment_approved) : ?>
                    <em class="comment-awaiting-moderation"><?php esc_html_e('دیدگاه شما در انتظار تایید است.', 'mohtavanegar'); ?></em>
                <?php endif; ?>
            </div>

            <div class="comment-content">
                <?php comment_text(); ?>
            </div>

            <div class="reply">
                <?php
                comment_reply_link(array_merge($args, array(
                    'add_below' => 'div-comment',
                    'depth'     => $depth,
                    'max_depth' => $args['max_depth'],
                    'reply_text' => '<i class="fas fa-reply"></i> ' . esc_html__('پاسخ', 'mohtavanegar'),
                )));
                ?>
                <?php edit_comment_link(esc_html__('ویرایش', 'mohtavanegar'), '<span class="edit-link">', '</span>'); ?>
            </div>
        </div>
    <?php
}