(function($){
  function updateRatingUI($container){
    var $checked = $container.find('input[name="review-rating"]:checked');
    var val = parseInt($checked.val() || '5', 10);
    // Ensure a hint element exists
    var $hint = $container.find('.reviews-rating-hint');
    if(!$hint.length){
      $hint = $('<span class="reviews-rating-hint" aria-live="polite"></span>');
      $container.find('.reviews-stars').after($hint);
    }
    $hint.text('امتیاز: ' + val + ' از 5');
    // Highlight stars up to selected value within this container
    $container.find('.review-star-label').each(function(){
      var v = parseInt($(this).data('value'), 10);
      if(v <= val){ $(this).addClass('on'); } else { $(this).removeClass('on'); }
    });
  }

  function getFormContainer($el){
    return $el.closest('.mohtavanegar-reviews-form-widget');
  }

  // Init on DOM ready for all instances
  $(document).ready(function(){
    $('.mohtavanegar-reviews-form-widget').each(function(){
      updateRatingUI($(this));
    });
  });

  // Change handler for rating radios (support multiple instances)
  $(document).on('change', '.mohtavanegar-reviews-form-widget input[name="review-rating"]', function(){
    updateRatingUI(getFormContainer($(this)));
  });

  // Hover feedback for stars
  $(document).on('mouseenter', '.mohtavanegar-reviews-form-widget .review-star-label', function(){
    var $wrap = getFormContainer($(this));
    var hv = parseInt($(this).data('value'), 10);
    $wrap.addClass('rating-hovering');
    $wrap.find('.review-star-label').each(function(){
      var v = parseInt($(this).data('value'), 10);
      if(v <= hv){ $(this).addClass('on'); } else { $(this).removeClass('on'); }
    });
  });
  $(document).on('mouseleave', '.mohtavanegar-reviews-form-widget .reviews-stars', function(){
    var $wrap = getFormContainer($(this));
    $wrap.removeClass('rating-hovering');
    updateRatingUI($wrap);
  });

  // Submit handler (scoped per form instance)
  $(document).on('submit', '#reviews-submission-form', function(e){
    e.preventDefault();
    var $form = $(this);
    var $wrap = $form.closest('.mohtavanegar-reviews-form-widget');
    var $msg = $wrap.find('#reviews-form-message');
    $msg.removeClass('error success').text('');

    var data = {
      action: 'submit_patient_review',
      nonce: (window.reviewsFrontendData && reviewsFrontendData.nonce) || '',
      name: $wrap.find('#review-name').val().trim(),
      service: $wrap.find('#review-service').val() || '',
      rating: $wrap.find('input[name="review-rating"]:checked').val(),
      text: $wrap.find('#review-text').val().trim()
    };
    $form.find(':input, button').prop('disabled', true);
    $.post((window.reviewsFrontendData && reviewsFrontendData.ajaxUrl) || '/wp-admin/admin-ajax.php', data)
      .done(function(res){
        if(res && res.success){
          $msg.addClass('success').text((window.reviewsFrontendData && reviewsFrontendData.i18n_success) || 'Success');
          $form[0].reset();
          // default to 5 stars checked after reset
          $wrap.find('input[name="review-rating"][value="5"]').prop('checked', true);
          updateRatingUI($wrap);
        } else {
          var err = (res && res.data) ? res.data : ((window.reviewsFrontendData && reviewsFrontendData.i18n_error) || 'Error');
          $msg.addClass('error').text(err);
        }
      })
      .fail(function(){
        $msg.addClass('error').text((window.reviewsFrontendData && reviewsFrontendData.i18n_error) || 'Error');
      })
      .always(function(){
        $form.find(':input, button').prop('disabled', false);
      });
  });
})(jQuery);
