<?php get_header(); ?>

<?php 
// بررسی اینکه آیا المنتور قالبی برای صفحه جستجو دارد یا خیر
if ( ! ( function_exists( 'elementor_theme_do_location' ) && elementor_theme_do_location( 'archive' ) ) ) : 
?>
<style>
  .search-results-archive {
    max-width: 1100px;
    margin: 40px auto;
    padding: 20px;
    background-color: #fff;
    box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    border-radius: 10px;
}

.search-title {
    font-size: 24px;
    font-weight: bold;
    color: #333;
    border-bottom: 2px solid #f0f0f0;
    padding-bottom: 10px;
    margin-bottom: 30px;
}

.posts-list {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
    gap: 20px;
}

.post-card {
    border: 1px solid #e6e6e6;
    border-radius: 8px;
    overflow: hidden;
    transition: box-shadow 0.3s, transform 0.3s;
    background-color: #fff;
}

.post-card:hover {
    box-shadow: 0 6px 18px rgba(0,0,0,0.15);
    transform: translateY(-5px);
}

.post-thumbnail img {
    width: 100%;
    height: 180px;
    object-fit: cover;
}

.post-content {
    padding: 15px;
}

.post-title {
    font-size: 18px;
    margin: 0 0 10px;
}

.post-title a {
    color: #222;
    text-decoration: none;
    transition: color 0.3s;
}

.post-title a:hover {
    color: #0073aa;
}

.post-meta {
    font-size: 13px;
    color: #999;
    margin-bottom: 15px;
}

.post-meta span {
    margin-right: 10px;
}

.post-excerpt {
    font-size: 14px;
    line-height: 1.6;
    color: #555;
    margin-bottom: 15px;
}

.read-more {
    display: inline-block;
    padding: 6px 15px;
    font-size: 13px;
    background-color: #0073aa;
    color: #fff;
    text-decoration: none;
    border-radius: 5px;
    transition: background-color 0.3s;
}

.read-more:hover {
    background-color: #005f87;
}

/* Responsive */
@media (max-width: 768px) {
    .search-results-archive {
        padding: 15px;
    }

    .posts-list {
        grid-template-columns: 1fr;
    }

    .post-thumbnail img {
        height: auto;
    }
}

</style>
<div class="search-results-archive">
  <h1 class="search-title">نتایج جستجو برای: <?php echo get_search_query(); ?></h1>
  <div class="posts-list">
    <?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
      <article class="post-card">
        <a href="<?php the_permalink(); ?>" class="post-thumbnail">
          <?php if ( has_post_thumbnail() ) : ?>
            <?php the_post_thumbnail('medium'); ?>
          <?php else: ?>
            <img src="https://via.placeholder.com/300x200?text=No+Image" alt="<?php the_title(); ?>">
          <?php endif; ?>
        </a>
        <div class="post-content">
          <h2 class="post-title">
            <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
          </h2>
          <div class="post-meta">
            <span class="post-date"><?php echo get_the_date(); ?></span>
            <span class="post-author"><?php the_author(); ?></span>
          </div>
          <div class="post-excerpt">
            <?php the_excerpt(); ?>
          </div>
          <a href="<?php the_permalink(); ?>" class="read-more">ادامه مطلب</a>
        </div>
      </article>
    <?php endwhile; else: ?>
      <p>نتیجه‌ای برای جستجوی شما یافت نشد.</p>
    <?php endif; ?>
  </div>
</div>
<?php endif; ?>

<?php get_footer(); ?>
