<?php
if (!defined('ABSPATH')) {
    exit;
}

require_once get_template_directory() . '/settings/elementor-helpers.php';

// Basic Settings Page Content
function mohtavanegar_basic_settings_page() {
    if (!current_user_can('manage_options')) {
        return;
    }

    // Enqueue WordPress media scripts
    wp_enqueue_media();
    wp_enqueue_script('jquery');

    $current_settings = get_option('basic_settings', array());
    $elementor_colors = mohtavanegar_get_elementor_colors();
    ?>
    <div class="basic-settings-wrap">
        <table class="form-table">
            <tr>
                <th scope="row"><?php _e('رنگ اصلی سایت', 'mohtavanegar'); ?></th>
                <td>
                    <input type="text" name="basic_settings[primary_color]" id="primary_color" value="<?php echo esc_attr($current_settings['primary_color'] ?? $elementor_colors['primary']); ?>" class="color-picker" />
                    <p class="description"><?php _e('رنگ اصلی سایت را انتخاب کنید. این رنگ در المنتور به عنوان Primary Color تنظیم می‌شود.', 'mohtavanegar'); ?></p>
                </td>
            </tr>
            <tr>
                <th scope="row"><?php _e('رنگ ثانویه', 'mohtavanegar'); ?></th>
                <td>
                    <input type="text" name="basic_settings[secondary_color]" id="secondary_color" value="<?php echo esc_attr($current_settings['secondary_color'] ?? $elementor_colors['secondary']); ?>" class="color-picker" />
                    <p class="description"><?php _e('رنگ ثانویه سایت را انتخاب کنید. این رنگ در المنتور به عنوان Secondary Color تنظیم می‌شود.', 'mohtavanegar'); ?></p>
                </td>
            </tr>
            <tr>
                <th scope="row"><?php _e('رنگ متن', 'mohtavanegar'); ?></th>
                <td>
                    <input type="text" name="basic_settings[text_color]" id="text_color" value="<?php echo esc_attr($current_settings['text_color'] ?? $elementor_colors['text']); ?>" class="color-picker" />
                    <p class="description"><?php _e('رنگ متن سایت را انتخاب کنید. این رنگ در المنتور به عنوان Text Color تنظیم می‌شود.', 'mohtavanegar'); ?></p>
                </td>
            </tr>
            <tr>
                <th scope="row"><?php _e('رنگ پس‌زمینه بدنه (Body)', 'mohtavanegar'); ?></th>
                <td>
                    <input type="text" name="basic_settings[body_bg_color]" id="body_bg_color" value="<?php echo esc_attr($current_settings['body_bg_color'] ?? '#ffffff'); ?>" class="color-picker" />
                    <p class="description"><?php _e('رنگ پس‌زمینه المان body. پیش‌فرض سفید (#ffffff).', 'mohtavanegar'); ?></p>
                </td>
            </tr>
            <tr>
                <th scope="row"><?php _e('رنگ تاکیدی', 'mohtavanegar'); ?></th>
                <td>
                    <input type="text" name="basic_settings[accent_color]" id="accent_color" value="<?php echo esc_attr($current_settings['accent_color'] ?? $elementor_colors['accent']); ?>" class="color-picker" />
                    <p class="description"><?php _e('رنگ تاکیدی سایت را انتخاب کنید. این رنگ در المنتور به عنوان Accent Color تنظیم می‌شود.', 'mohtavanegar'); ?></p>
                </td>
            </tr>
            <tr>
                <th scope="row"><?php _e('حالت تعمیر سایت', 'mohtavanegar'); ?></th>
                <td>
                    <label for="maintenance_mode">
                        <input type="checkbox" name="basic_settings[maintenance_mode]" id="maintenance_mode" value="1" <?php checked(isset($current_settings['maintenance_mode']) && $current_settings['maintenance_mode'] == 1); ?> />
                        <?php _e('فعال کردن حالت تعمیر', 'mohtavanegar'); ?>
                    </label>
                    <p class="description"><?php _e('در صورت فعال بودن، کاربرانی که لاگین نشده‌اند پیام "در حال تعمیر" را مشاهده خواهند کرد.', 'mohtavanegar'); ?></p>
                </td>
            </tr>
            <tr>
                <th scope="row"><?php _e('نوع نمایش صفحه', 'mohtavanegar'); ?></th>
                <td>
                    <select name="basic_settings[page_layout]" id="page_layout">
                        <option value="container" <?php selected($current_settings['page_layout'] ?? 'container', 'container'); ?>><?php _e('Container (محدود)', 'mohtavanegar'); ?></option>
                        <option value="full-width" <?php selected($current_settings['page_layout'] ?? '', 'full-width'); ?>><?php _e('تمام عرض', 'mohtavanegar'); ?></option>
                    </select>
                    <p class="description"><?php _e('انتخاب کنید که محتوای صفحه به صورت محدود (container) یا تمام عرض نمایش داده شود.', 'mohtavanegar'); ?></p>
                </td>
            </tr>
            <tr>
                <th scope="row"><?php _e('عرض Container', 'mohtavanegar'); ?></th>
                <td>
                    <select name="basic_settings[container_width]" id="container_width">
                        <option value="1140" <?php selected($current_settings['container_width'] ?? '1140', '1140'); ?>>1140px</option>
                        <option value="1320" <?php selected($current_settings['container_width'] ?? '', '1320'); ?>>1320px</option>
                        <option value="1440" <?php selected($current_settings['container_width'] ?? '', '1440'); ?>>1440px</option>
                    </select>
                    <p class="description"><?php _e('در صورت انتخاب حالت Container، عرض آن را مشخص کنید.', 'mohtavanegar'); ?></p>
                </td>
            </tr>
            <tr>
                <th scope="row"><?php _e('لوگوی سایت (المنتور)', 'mohtavanegar'); ?></th>
                <td>
                    <?php
                    // Get logo from wp_options
                    $logo_id = get_option('site_logo');
                    $logo_url = $logo_id ? wp_get_attachment_image_url($logo_id, 'full') : '';
                    ?>
                    <div class="logo-preview-wrapper" style="margin-bottom: 10px; background: #f0f0f0; padding: 10px; border-radius: 4px; display: inline-block;">
                        <?php if ($logo_url): ?>
                            <img src="<?php echo esc_url($logo_url); ?>" style="max-width: 100px; max-height: 50px; width: auto; height: auto; display: block;" />
                        <?php endif; ?>
                    </div>
                    <input type="hidden" name="basic_settings[site_logo]" name="site_logo" id="site_logo" value="<?php echo esc_attr($logo_id); ?>" />
                    <button type="button" class="button" id="upload_logo_button"><?php _e('انتخاب لوگو', 'mohtavanegar'); ?></button>
                    <button type="button" class="button" id="remove_logo_button" <?php echo empty($logo_id) ? 'style="display:none;"' : ''; ?>><?php _e('حذف لوگو', 'mohtavanegar'); ?></button>
                    <p class="description"><?php _e('لوگوی سایت را انتخاب کنید. این لوگو در المنتور به عنوان لوگوی اصلی سایت تنظیم می‌شود.', 'mohtavanegar'); ?></p>
                </td>
            </tr>
            <tr>
                <th scope="row"><?php _e('تاریخ شمسی', 'mohtavanegar'); ?></th>
                <td>
                    <label for="jalali_date">
                        <input type="checkbox" name="basic_settings[jalali_date]" id="jalali_date" value="1" <?php checked(isset($current_settings['jalali_date']) && $current_settings['jalali_date'] == 1); ?> />
                        <?php _e('فعال کردن نمایش تاریخ شمسی', 'mohtavanegar'); ?>
                    </label>
                    <p class="description"><?php _e('در صورت فعال بودن، تمامی تاریخ‌های سایت به صورت شمسی نمایش داده می‌شوند.', 'mohtavanegar'); ?></p>
                </td>
            </tr>
        </table>
    </div>

    <script>
    jQuery(document).ready(function($) {
        // Initialize color pickers
        jQuery('.color-picker').wpColorPicker();

        // Logo upload functionality
        jQuery('#upload_logo_button').on('click', function(e) {
            e.preventDefault();
            var logoUploader = wp.media({
                title: '<?php _e('انتخاب لوگو', 'mohtavanegar'); ?>',
                button: {
                    text: '<?php _e('استفاده از این تصویر', 'mohtavanegar'); ?>'
                },
                multiple: false
            });

            logoUploader.on('select', function() {
                var attachment = logoUploader.state().get('selection').first().toJSON();
                $('#site_logo').val(attachment.id);
                $('.logo-preview-wrapper').html('<img src="' + attachment.url + '" style="max-width: 100px; max-height: 50px; width: auto; height: auto; display: block;" />');
                $('#remove_logo_button').show();
            });

            logoUploader.open();
        });

        $('#remove_logo_button').on('click', function(e) {
            e.preventDefault();
            $('#site_logo').val('');
            $('.logo-preview-wrapper').html('');
            $(this).hide();
        });
    });
    </script>
    <?php
} 