<?php
if (!defined('ABSPATH')) {
    exit;
}

// Get Elementor Global Colors
function mohtavanegar_get_elementor_colors() {
    if (!class_exists('\Elementor\Plugin')) {
        return [
            'primary' => '#000000',
            'secondary' => '#000000',
            'text' => '#000000',
            'accent' => '#000000'
        ];
    }

    $elementor = \Elementor\Plugin::$instance;
    $kit = $elementor->kits_manager->get_active_kit();
    
    if (!$kit) {
        return [
            'primary' => '#000000',
            'secondary' => '#000000',
            'text' => '#000000',
            'accent' => '#000000'
        ];
    }

    $kit_settings = $kit->get_settings();
    $system_colors = $kit_settings['system_colors'] ?? [];
    
    $colors = [
        'primary' => '#000000',
        'secondary' => '#000000',
        'text' => '#000000',
        'accent' => '#000000'
    ];

    foreach ($system_colors as $color) {
        if ($color['title'] === 'Primary') {
            $colors['primary'] = $color['color'];
        } elseif ($color['title'] === 'Secondary') {
            $colors['secondary'] = $color['color'];
        } elseif ($color['title'] === 'Text') {
            $colors['text'] = $color['color'];
        } elseif ($color['title'] === 'Accent') {
            $colors['accent'] = $color['color'];
        }
    }

    return $colors;
}

// Update Elementor Global Colors
function mohtavanegar_update_elementor_colors($old_settings, $new_settings) {
    if (!class_exists('\Elementor\Plugin')) {
        return;
    }

    $kit = \Elementor\Plugin::$instance->kits_manager->get_active_kit();
    if (!$kit) {
        return;
    }

    $colors = array(
        'primary' => $new_settings['primary_color'] ?? '',
        'secondary' => $new_settings['secondary_color'] ?? '',
        'text' => $new_settings['text_color'] ?? '',
        'accent' => $new_settings['accent_color'] ?? ''
    );

    $kit->update_settings(array(
        'system_colors' => array(
            array(
                '_id' => 'primary',
                'title' => 'Primary',
                'color' => $colors['primary']
            ),
            array(
                '_id' => 'secondary',
                'title' => 'Secondary',
                'color' => $colors['secondary']
            ),
            array(
                '_id' => 'text',
                'title' => 'Text',
                'color' => $colors['text']
            ),
            array(
                '_id' => 'accent',
                'title' => 'Accent',
                'color' => $colors['accent']
            )
        )
    ));

    // Clear Elementor cache
    if (class_exists('\Elementor\Plugin')) {
        \Elementor\Plugin::$instance->files_manager->clear_cache();
    }
} 