<?php
if (!defined('ABSPATH')) {
    exit;
}

// Load Header Template with Type
function mohtavanegar_load_header_template() {
    if (!function_exists('mohtavanegar_is_elementor_active') || !mohtavanegar_is_elementor_active()) {
        return;
    }

    static $header_template_id = null;
    static $header_type = null;
    
    if ($header_template_id === null) {
        $header_template_id = get_option('header_template');
        $header_type = get_option('header_type', 'default');
    }
    
    if ($header_template_id) {
        echo '<div class="site-header type-' . esc_attr($header_type) . '">';
        if (function_exists('mohtavanegar_get_elementor_template')) {
            echo mohtavanegar_get_elementor_template($header_template_id);
        } else {
            echo do_shortcode('[elementor-template id="' . $header_template_id . '"]');
        }
        echo '</div>';
    }
}

// Add Theme Builder Header Support
function mohtavanegar_theme_builder_header() {
    if (!function_exists('mohtavanegar_is_elementor_active') || !mohtavanegar_is_elementor_active()) {
        return;
    }

    if (class_exists('\Elementor\Plugin')) {
        $elementor = \Elementor\Plugin::instance();
        $document = $elementor->documents->get_current();
        
        if ($document && $document->get_location() === 'header') {
            remove_action('get_header', 'mohtavanegar_load_header_template');
        }
    }
}
add_action('wp', 'mohtavanegar_theme_builder_header'); 