jQuery(document).ready(function($) {
    // Tab Navigation
    $('.theme-settings-nav a').on('click', function(e) {
        e.preventDefault();
        
        // Remove active class from all tabs and sections
        $('.theme-settings-nav a').removeClass('active');
        $('.theme-settings-section').removeClass('active');
        
        // Add active class to clicked tab
        $(this).addClass('active');
        
        // Show corresponding section
        var target = $(this).attr('href');
        $(target).addClass('active');
        
        // Update URL hash
        window.location.hash = target;
    });
    
    // Handle initial hash in URL
    if (window.location.hash) {
        $('.theme-settings-nav a[href="' + window.location.hash + '"]').click();
    } else {
        // Activate first tab by default
        $('.theme-settings-nav a:first').click();
    }
    
    // Typography Preview
    function updateTypographyPreview() {
        var mainFont = $('#main_font').val();
        var mainFontSize = $('#main_font_size').val();
        
        $('.typography-preview').css({
            'font-family': mainFont,
            'font-size': mainFontSize
        });
    }
    
    $('#main_font, #main_font_size').on('change', updateTypographyPreview);
    
    // Initialize typography preview
    updateTypographyPreview();
    
    // Initialize color pickers
    $('.color-picker').wpColorPicker();
    
    // Handle form submission
    $('#theme-settings-form').on('submit', function(e) {
        e.preventDefault();
        
        // Show loading state
        var $submitButton = $(this).find('input[type="submit"]');
        var originalText = $submitButton.val();
        $submitButton.val('در حال ذخیره...').prop('disabled', true);
        
        // Collect form data
        var formData = new FormData(this);
        formData.append('action', 'mohtavanegar_save_theme_settings');
        formData.append('security', mohtavanegarSettings.nonce);
        
        // Handle maintenance mode checkbox properly
        // First, remove any existing maintenance_mode value that might have been added
        if (formData.has('basic_settings[maintenance_mode]')) {
            formData.delete('basic_settings[maintenance_mode]');
        }
        
        // Then add the correct value based on checkbox state
        if ($('#maintenance_mode').is(':checked')) {
            formData.append('basic_settings[maintenance_mode]', '1');
        } else {
            formData.append('basic_settings[maintenance_mode]', '0');
        }
        
        // Send Ajax request
        $.ajax({
            url: mohtavanegarSettings.ajaxurl,
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                if (response.success) {
                    showNotice('success', response.data.message);
                    
                    // If Elementor colors were updated, clear cache
                    if (response.data.elementor_updated) {
                        clearElementorCache();
                    }
                } else {
                    showNotice('error', response.data.message);
                }
            },
            error: function() {
                showNotice('error', 'خطا در ارتباط با سرور. لطفاً دوباره تلاش کنید.');
            },
            complete: function() {
                // Reset button state
                $submitButton.val(originalText).prop('disabled', false);
            }
        });
    });
    
    // Live preview functionality
    function updatePreview() {
        var layout = $('#page_layout').val();
        var containerWidth = $('#container_width').val();
        
        if (layout === 'container') {
            $('.preview-container').css({
                'max-width': containerWidth + 'px',
                'margin': '0 auto'
            });
        } else {
            $('.preview-container').css({
                'max-width': '100%',
                'margin': '0'
            });
        }
    }
    
    // Update preview on any change
    $('.basic-settings-wrap select').on('change', updatePreview);
    
    // Initial preview
    updatePreview();
    
    // Show notice function
    function showNotice(type, message) {
        // Remove any existing notices
        $('.notice').remove();
        
        // Create new notice
        var $notice = $('<div class="notice notice-' + type + '"><p>' + message + '</p></div>');
        $('body').append($notice);
        
        // Auto dismiss after 3 seconds
        setTimeout(function() {
            $notice.addClass('dismissing');
            setTimeout(function() {
                $notice.remove();
            }, 300);
        }, 3000);
    }
    
    // Clear Elementor cache
    function clearElementorCache() {
        $.ajax({
            url: mohtavanegarSettings.ajaxurl,
            type: 'POST',
            data: {
                action: 'elementor_clear_cache',
                security: mohtavanegarSettings.nonce
            },
            success: function(response) {
                if (response.success) {
                    showNotice('success', 'کش المنتور با موفقیت پاک شد.');
                }
            }
        });
    }
}); 