<?php
if (!defined('ABSPATH')) {
    exit;
}

// Register Services Post Type
function mohtavanegar_register_services_post_type() {
    $labels = array(
        'name'                  => _x('خدمات', 'Post type general name', 'mohtavanegar'),
        'singular_name'         => _x('خدمات', 'Post type singular name', 'mohtavanegar'),
        'menu_name'            => _x('خدمات', 'Admin Menu text', 'mohtavanegar'),
        'name_admin_bar'       => _x('خدمات', 'Add New on Toolbar', 'mohtavanegar'),
        'add_new'              => __('افزودن جدید', 'mohtavanegar'),
        'add_new_item'         => __('افزودن خدمات جدید', 'mohtavanegar'),
        'new_item'             => __('خدمات جدید', 'mohtavanegar'),
        'edit_item'            => __('ویرایش خدمات', 'mohtavanegar'),
        'view_item'            => __('مشاهده خدمات', 'mohtavanegar'),
        'all_items'            => __('همه خدمات', 'mohtavanegar'),
        'search_items'         => __('جستجوی خدمات', 'mohtavanegar'),
        'not_found'            => __('هیچ خدمتی یافت نشد.', 'mohtavanegar'),
        'not_found_in_trash'   => __('هیچ خدمتی در سطل زباله یافت نشد.', 'mohtavanegar'),
        'featured_image'       => _x('تصویر شاخص خدمات', 'Overrides the "Featured Image" phrase', 'mohtavanegar'),
        'set_featured_image'   => _x('تنظیم تصویر شاخص', 'Overrides the "Set featured image" phrase', 'mohtavanegar'),
        'remove_featured_image'=> _x('حذف تصویر شاخص', 'Overrides the "Remove featured image" phrase', 'mohtavanegar'),
        'use_featured_image'   => _x('استفاده به عنوان تصویر شاخص', 'Overrides the "Use as featured image" phrase', 'mohtavanegar'),
        'archives'             => _x('آرشیو خدمات', 'The post type archive label used in nav menus', 'mohtavanegar'),
        'insert_into_item'     => _x('درج در خدمات', 'Overrides the "Insert into post" phrase', 'mohtavanegar'),
        'uploaded_to_this_item'=> _x('آپلود شده در این خدمات', 'Overrides the "Uploaded to this post" phrase', 'mohtavanegar'),
        'filter_items_list'    => _x('فیلتر لیست خدمات', 'Screen reader text for the filter links heading', 'mohtavanegar'),
        'items_list_navigation'=> _x('ناوبری لیست خدمات', 'Screen reader text for the pagination heading', 'mohtavanegar'),
        'items_list'           => _x('لیست خدمات', 'Screen reader text for the items list heading', 'mohtavanegar'),
    );

    $args = array(
        'labels'             => $labels,
        'public'             => true,
        'publicly_queryable' => true,
        'show_ui'            => true,
        'show_in_menu'       => true,
        'query_var'          => true,
        'rewrite'            => array('slug' => 'services'),
        'capability_type'    => 'post',
        'has_archive'        => true,
        'hierarchical'       => false,
        'menu_position'      => 5,
        'menu_icon'          => 'dashicons-clipboard',
        'supports'           => array('title', 'editor', 'thumbnail', 'excerpt','discussion','comments'),
        'show_in_rest'       => true,
    );

    register_post_type('services', $args);
}
add_action('init', 'mohtavanegar_register_services_post_type');

// Register Services Category Taxonomy
function mohtavanegar_register_services_taxonomy() {
    $labels = array(
        'name'              => _x('دسته‌بندی خدمات', 'taxonomy general name', 'mohtavanegar'),
        'singular_name'     => _x('دسته‌بندی خدمات', 'taxonomy singular name', 'mohtavanegar'),
        'search_items'      => __('جستجوی دسته‌بندی‌ها', 'mohtavanegar'),
        'all_items'         => __('همه دسته‌بندی‌ها', 'mohtavanegar'),
        'parent_item'       => __('دسته‌بندی والد', 'mohtavanegar'),
        'parent_item_colon' => __('دسته‌بندی والد:', 'mohtavanegar'),
        'edit_item'         => __('ویرایش دسته‌بندی', 'mohtavanegar'),
        'update_item'       => __('بروزرسانی دسته‌بندی', 'mohtavanegar'),
        'add_new_item'      => __('افزودن دسته‌بندی جدید', 'mohtavanegar'),
        'new_item_name'     => __('نام دسته‌بندی جدید', 'mohtavanegar'),
        'menu_name'         => __('دسته‌بندی‌ها', 'mohtavanegar'),
    );

    $args = array(
        'hierarchical'      => true,
        'labels'            => $labels,
        'show_ui'           => true,
        'show_admin_column' => true,
        'query_var'         => true,
        'rewrite'           => array('slug' => 'services-category'),
        'show_in_rest'      => true,
    );

    register_taxonomy('services_category', array('services'), $args);
}
add_action('init', 'mohtavanegar_register_services_taxonomy');

// Register Portfolio Custom Post Type
add_action('init', function() {
    $labels = array(
        'name' => 'نمونه کارها',
        'singular_name' => 'نمونه کار',
        'add_new' => 'افزودن نمونه کار',
        'add_new_item' => 'افزودن نمونه کار جدید',
        'edit_item' => 'ویرایش نمونه کار',
        'new_item' => 'نمونه کار جدید',
        'view_item' => 'مشاهده نمونه کار',
        'search_items' => 'جستجوی نمونه کارها',
        'not_found' => 'نمونه کاری یافت نشد',
        'not_found_in_trash' => 'نمونه کاری در زباله‌دان یافت نشد',
        'all_items' => 'همه نمونه کارها',
        'menu_name' => 'نمونه کارها',
    );
    $args = array(
        'labels' => $labels,
        'public' => true,
        'has_archive' => true,
        'rewrite' => array('slug' => 'portfolio'),
        'supports' => array('title', 'editor', 'thumbnail', 'excerpt', 'custom-fields'),
        'menu_icon' => 'dashicons-portfolio',
        'show_in_rest' => true,
    );
    register_post_type('portfolio', $args);

    // Register Portfolio Category Taxonomy
    $tax_labels = array(
        'name' => 'دسته‌بندی نمونه کارها',
        'singular_name' => 'دسته‌بندی نمونه کار',
        'search_items' => 'جستجوی دسته‌بندی نمونه کارها',
        'all_items' => 'همه دسته‌بندی‌ها',
        'parent_item' => 'دسته‌بندی مادر',
        'parent_item_colon' => 'دسته‌بندی مادر:',
        'edit_item' => 'ویرایش دسته‌بندی',
        'update_item' => 'به‌روزرسانی دسته‌بندی',
        'add_new_item' => 'افزودن دسته‌بندی جدید',
        'new_item_name' => 'نام دسته‌بندی جدید',
        'menu_name' => 'دسته‌بندی نمونه کارها',
    );
    $tax_args = array(
        'hierarchical' => true,
        'labels' => $tax_labels,
        'show_ui' => true,
        'show_admin_column' => true,
        'query_var' => true,
        'rewrite' => array('slug' => 'portfolio-category'),
        'show_in_rest' => true,
    );
    register_taxonomy('portfolio_category', array('portfolio'), $tax_args);
});

// Add custom meta boxes for services
function mohtavanegar_add_services_meta_boxes() {
    add_meta_box(
        'services_details',
        __('جزئیات خدمات', 'mohtavanegar'),
        'mohtavanegar_services_meta_box_callback',
        'services',
        'normal',
        'high'
    );
}
add_action('add_meta_boxes', 'mohtavanegar_add_services_meta_boxes');

// Meta box callback function
function mohtavanegar_services_meta_box_callback($post) {
    wp_nonce_field('mohtavanegar_save_services_meta', 'mohtavanegar_services_meta_nonce');

    $service_icon = get_post_meta($post->ID, '_service_icon', true);
    $service_price = get_post_meta($post->ID, '_service_price', true);
    $service_duration = get_post_meta($post->ID, '_service_duration', true);
    ?>
    <div class="mohtavanegar-meta-box">
        <p>
            <label for="service_icon"><?php _e('آیکون خدمات:', 'mohtavanegar'); ?></label>
            <div class="icon-input-group">
                <input type="text" id="service_icon" name="service_icon" value="<?php echo esc_attr($service_icon); ?>" class="widefat" placeholder="fas fa-star">
                <button type="button" id="icon_selector_btn" class="button button-secondary"><?php _e('انتخاب آیکون', 'mohtavanegar'); ?></button>
            </div>
            <div id="selected_icon_preview" class="icon-preview" style="margin-top: 10px;">
                <?php if (!empty($service_icon)): ?>
                    <i class="<?php echo esc_attr($service_icon); ?>" style="font-size: 24px; margin-right: 10px;"></i>
                    <span><?php echo esc_html($service_icon); ?></span>
                <?php endif; ?>
            </div>
        </p>
        <p>
            <label for="service_price"><?php _e('قیمت:', 'mohtavanegar'); ?></label>
            <input type="text" id="service_price" name="service_price" value="<?php echo esc_attr($service_price); ?>" class="widefat">
        </p>
        <p>
            <label for="service_duration"><?php _e('مدت زمان:', 'mohtavanegar'); ?></label>
            <input type="text" id="service_duration" name="service_duration" value="<?php echo esc_attr($service_duration); ?>" class="widefat">
        </p>
    </div>
    <?php
}

// Save meta box data
function mohtavanegar_save_services_meta($post_id) {
    if (!isset($_POST['mohtavanegar_services_meta_nonce'])) {
        return;
    }

    if (!wp_verify_nonce($_POST['mohtavanegar_services_meta_nonce'], 'mohtavanegar_save_services_meta')) {
        return;
    }

    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return;
    }

    if (!current_user_can('edit_post', $post_id)) {
        return;
    }

    if (isset($_POST['service_icon'])) {
        update_post_meta($post_id, '_service_icon', sanitize_text_field($_POST['service_icon']));
    }

    if (isset($_POST['service_price'])) {
        update_post_meta($post_id, '_service_price', sanitize_text_field($_POST['service_price']));
    }

    if (isset($_POST['service_duration'])) {
        update_post_meta($post_id, '_service_duration', sanitize_text_field($_POST['service_duration']));
    }
}
add_action('save_post_services', 'mohtavanegar_save_services_meta');

// Enqueue scripts and styles for icon selector
function mohtavanegar_enqueue_icon_selector_scripts($hook) {
    global $post_type;
    
    if (($hook === 'post.php' || $hook === 'post-new.php') && $post_type === 'services') {
        // Enqueue Font Awesome
        wp_enqueue_style('font-awesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css', array(), '6.4.0');
        
        // Enqueue custom script
        wp_enqueue_script('icon-selector', get_template_directory_uri() . '/assets/js/icon-selector.js', array('jquery'), '1.0.0', true);
        
        // Enqueue custom styles
        wp_enqueue_style('icon-selector', get_template_directory_uri() . '/assets/css/icon-selector.css', array(), '1.0.0');
    }
}
add_action('admin_enqueue_scripts', 'mohtavanegar_enqueue_icon_selector_scripts');

// Add modal HTML to admin footer
function mohtavanegar_add_icon_modal_to_footer() {
    global $post_type;
    
    if ($post_type === 'services') {
        ?>
        <div id="icon_selector_modal" class="icon-selector-modal" style="display: none;">
            <div class="icon-modal-overlay"></div>
            <div class="icon-modal-content">
                <div class="icon-modal-header">
                    <h3><?php _e('انتخاب آیکون', 'mohtavanegar'); ?></h3>
                    <button type="button" class="icon-modal-close">&times;</button>
                </div>
                <div class="icon-modal-body">
                    <div class="icon-search">
                        <input type="text" id="icon_search" placeholder="<?php _e('جستجوی آیکون...', 'mohtavanegar'); ?>" class="widefat">
                    </div>
                    <div class="icon-categories">
                        <button type="button" class="icon-category-btn active" data-category="all"><?php _e('همه', 'mohtavanegar'); ?></button>
                        <button type="button" class="icon-category-btn" data-category="solid">Solid</button>
                        <button type="button" class="icon-category-btn" data-category="regular">Regular</button>
                        <button type="button" class="icon-category-btn" data-category="brands">Brands</button>
                    </div>
                    <div class="icon-grid" id="icon_grid">
                        <!-- Icons will be loaded here via JavaScript -->
                    </div>
                </div>
            </div>
        </div>
        <?php
    }
}
add_action('admin_footer', 'mohtavanegar_add_icon_modal_to_footer'); 

// Use classic TinyMCE editor for services_category term description (add/edit screens)
// Add screen: /wp-admin/edit-tags.php?taxonomy=services_category
add_action('services_category_add_form_fields', function($taxonomy) {
    echo '<style> #addtag .term-description-wrap { display:none; } </style>';
    echo '<div class="form-field term-description-wrap">';
    echo '<label for="services_category_description">' . esc_html__('توضیحات', 'mohtavanegar') . '</label>';
    $settings = array(
        'textarea_name' => 'description', // keep WP core save mechanism
        'teeny'         => true,
        'quicktags'     => true,
        'editor_height' => 200,
    );
    // Unique editor ID; name remains 'description' for saving
    wp_editor('', 'services_category_description', $settings);
    echo '<p class="description">' . esc_html__('توضیحات دسته‌بندی خدمات را وارد کنید.', 'mohtavanegar') . '</p>';
    echo '</div>';
}, 10, 1);

// Edit screen: /wp-admin/term.php?taxonomy=services_category
add_action('services_category_edit_form_fields', function($term, $taxonomy) {
    // Hide default textarea row via CSS
    echo '<style> .term-description-wrap { display:none; } </style>';
    echo '<tr class="form-field">';
    echo '<th scope="row"><label for="services_category_description">' . esc_html__('توضیحات', 'mohtavanegar') . '</label></th>';
    echo '<td>';
    $settings = array(
        'textarea_name' => 'description', // WP expects this name
        'media_buttons' => false,
        'teeny'         => true,
        'quicktags'     => true,
        'editor_height' => 250,
    );
    // Pre-fill with current description
    $content = isset($term->description) ? $term->description : '';
    wp_editor($content, 'services_category_description', $settings);
    echo '<p class="description">' . esc_html__('توضیحات دسته‌بندی خدمات.', 'mohtavanegar') . '</p>';
    echo '</td>';
    echo '</tr>';
}, 10, 2);

// Ensure editor assets are available on term add/edit pages
add_action('admin_enqueue_scripts', function($hook) {
    if ($hook === 'term.php' || $hook === 'edit-tags.php') {
        wp_enqueue_editor();
    }
});