<?php

/**
 * Add icon upload field to taxonomy edit forms
 */
function add_taxonomy_icon_field($term) {
    $icon_id = null;
    $display_order = '';
    $background_image_id = null;
    $subtitle = '';
    
    // If this is a term object (edit form)
    if (is_object($term) && isset($term->term_id)) {
        $icon_id = get_term_meta($term->term_id, 'taxonomy_icon', true);
        $display_order = get_term_meta($term->term_id, 'display_order', true);
        $background_image_id = get_term_meta($term->term_id, 'taxonomy_background_image', true);
        $subtitle = get_term_meta($term->term_id, 'taxonomy_subtitle', true);
    }
    // If this is a taxonomy string (add form)
    else if (is_string($term)) {
        $icon_id = null; // No icon for new terms
        $display_order = '';
        $background_image_id = null;
        $subtitle = '';
    }
    ?>
    <tr class="form-field">
        <th scope="row" valign="top">
            <label for="taxonomy_icon">آیکون</label>
        </th>
        <td>
            <input type="hidden" id="taxonomy_icon" name="taxonomy_icon" value="<?php echo esc_attr($icon_id); ?>">
            <div id="taxonomy_icon_preview">
                <?php 
                if ($icon_id) {
                    echo wp_get_attachment_image($icon_id, 'thumbnail');
                } else {
                    echo '<p>آیکونی انتخاب نشده است</p>';
                }
                ?>
            </div>
            <p>
                <input type="button" class="button button-secondary" value="آپلود آیکون" id="upload_taxonomy_icon">
                <input type="button" class="button button-secondary" value="حذف آیکون" id="remove_taxonomy_icon" <?php echo $icon_id ? '' : 'style="display:none"'; ?>>
            </p>
            <p class="description">برای انتخاب آیکون از گالری وردپرس استفاده کنید</p>
        </td>
    </tr>
    <tr class="form-field">
        <th scope="row" valign="top">
            <label for="display_order">شماره ترتیب اولیت نمایش</label>
        </th>
        <td>
            <input type="number" id="display_order" name="display_order" value="<?php echo esc_attr($display_order); ?>" min="0" step="1" style="width: 100px;">
            <p class="description">ترتیب نمایش زیر دسته‌ها (اختیاری، پیش‌فرض خالی است)</p>
        </td>
    </tr>
    <tr class="form-field">
        <th scope="row" valign="top">
            <label for="taxonomy_subtitle">زیر عنوان</label>
        </th>
        <td>
            <input type="text" id="taxonomy_subtitle" name="taxonomy_subtitle" value="<?php echo esc_attr($subtitle); ?>" style="width: 100%;">
            <p class="description">زیر عنوان دسته بندی را وارد کنید (اختیاری)</p>
        </td>
    </tr>
    <tr class="form-field">
        <th scope="row" valign="top">
            <label for="taxonomy_background_image">تصویر پس‌زمینه</label>
        </th>
        <td>
            <input type="hidden" id="taxonomy_background_image" name="taxonomy_background_image" value="<?php echo esc_attr($background_image_id); ?>">
            <div id="taxonomy_background_image_preview" style="margin: 10px 0;">
                <?php 
                if ($background_image_id) {
                    echo wp_get_attachment_image($background_image_id, 'medium');
                } else {
                    echo '<p>تصویری انتخاب نشده است</p>';
                }
                ?>
            </div>
            <p>
                <input type="button" class="button button-secondary" value="آپلود تصویر پس‌زمینه" id="upload_taxonomy_background_image">
                <input type="button" class="button button-secondary" value="حذف تصویر" id="remove_taxonomy_background_image" <?php echo $background_image_id ? '' : 'style="display:none"'; ?>>
            </p>
            <p class="description">برای انتخاب تصویر پس‌زمینه از گالری وردپرس استفاده کنید</p>
        </td>
    </tr>
    <?php
}
add_action('category_add_form_fields', 'add_taxonomy_icon_field', 10, 2);
add_action('category_edit_form_fields', 'add_taxonomy_icon_field', 10, 2);
add_action('post_tag_add_form_fields', 'add_taxonomy_icon_field', 10, 2);
add_action('post_tag_edit_form_fields', 'add_taxonomy_icon_field', 10, 2);
add_action('services_category_add_form_fields', 'add_taxonomy_icon_field', 10, 2);
add_action('services_category_edit_form_fields', 'add_taxonomy_icon_field', 10, 2);


add_action('portfolio_category_add_form_fields', 'add_taxonomy_icon_field', 10, 2);
add_action('portfolio_category_edit_form_fields', 'add_taxonomy_icon_field', 10, 2);
add_action('edited_portfolio_category', 'save_taxonomy_icon');
add_action('create_portfolio_category', 'save_taxonomy_icon');
add_filter('manage_edit-portfolio_category_columns', 'add_taxonomy_icon_column');
add_action('manage_portfolio_category_custom_column', 'display_taxonomy_icon_column', 10, 3);

/**
 * Save taxonomy icon
 */
function save_taxonomy_icon($term_id) {
    if (isset($_POST['taxonomy_icon'])) {
        update_term_meta($term_id, 'taxonomy_icon', sanitize_text_field($_POST['taxonomy_icon']));
    }
    if (isset($_POST['display_order'])) {
        $order = sanitize_text_field($_POST['display_order']);
        if ($order === '') {
            delete_term_meta($term_id, 'display_order');
        } else {
            update_term_meta($term_id, 'display_order', $order);
        }
    }
    if (isset($_POST['taxonomy_background_image'])) {
        $background_image = sanitize_text_field($_POST['taxonomy_background_image']);
        if (empty($background_image)) {
            delete_term_meta($term_id, 'taxonomy_background_image');
        } else {
            update_term_meta($term_id, 'taxonomy_background_image', $background_image);
        }
    }
    
    // Save subtitle
    if (isset($_POST['taxonomy_subtitle'])) {
        $subtitle = sanitize_text_field($_POST['taxonomy_subtitle']);
        if (empty($subtitle)) {
            delete_term_meta($term_id, 'taxonomy_subtitle');
        } else {
            update_term_meta($term_id, 'taxonomy_subtitle', $subtitle);
        }
    }
}
add_action('edited_category', 'save_taxonomy_icon');
add_action('create_category', 'save_taxonomy_icon');
add_action('edited_post_tag', 'save_taxonomy_icon');
add_action('create_post_tag', 'save_taxonomy_icon');
add_action('edited_services_category', 'save_taxonomy_icon');
add_action('create_services_category', 'save_taxonomy_icon');
add_action('sellino_product_category_add_form_fields', 'add_taxonomy_icon_field', 10, 2);
add_action('sellino_product_category_edit_form_fields', 'add_taxonomy_icon_field', 10, 2);
add_action('edited_sellino_product_category', 'save_taxonomy_icon');
add_action('create_sellino_product_category', 'save_taxonomy_icon');

/**
 * Enqueue media upload scripts
 */
function enqueue_taxonomy_icon_scripts($hook) {
    if (in_array($hook, array('category.php', 'edit-tags.php', 'term.php'))) {
        // Enqueue media uploader
        wp_enqueue_media();
        
        // Add inline JavaScript for the media uploader
        add_action('admin_footer', function() {
            ?>
            <script type='text/javascript'>
                jQuery(document).ready(function($) {
                    // Handle icon upload
                    $('#upload_taxonomy_icon').click(function(e) {
                        e.preventDefault();
                        var button = $(this);
                        var frame = wp.media({
                            title: 'انتخاب آیکون',
                            button: { text: 'استفاده از این تصویر' },
                            multiple: false
                        });
                        frame.on('select', function() {
                            var attachment = frame.state().get('selection').first().toJSON();
                            $('#taxonomy_icon').val(attachment.id);
                            $('#taxonomy_icon_preview').html('<img src="' + attachment.sizes.thumbnail ? attachment.sizes.thumbnail.url : attachment.url + '" />');
                            $('#remove_taxonomy_icon').show();
                        });
                        frame.open();
                    });

                    // Handle icon removal
                    $('#remove_taxonomy_icon').click(function(e) {
                        e.preventDefault();
                        $('#taxonomy_icon').val('');
                        $('#taxonomy_icon_preview').html('<p>آیکونی انتخاب نشده است</p>');
                        $(this).hide();
                    });

                    // Handle background image upload
                    $('#upload_taxonomy_background_image').click(function(e) {
                        e.preventDefault();
                        var button = $(this);
                        var frame = wp.media({
                            title: 'انتخاب تصویر پس‌زمینه',
                            button: { text: 'استفاده از این تصویر' },
                            multiple: false
                        });
                        frame.on('select', function() {
                            var attachment = frame.state().get('selection').first().toJSON();
                            $('#taxonomy_background_image').val(attachment.id);
                            var preview = $('#taxonomy_background_image_preview');
                            preview.html('<img src="' + (attachment.sizes.medium ? attachment.sizes.medium.url : attachment.url) + '" style="max-width: 100%; height: auto;" />');
                            $('#remove_taxonomy_background_image').show();
                        });
                        frame.open();
                    });

                    // Handle background image removal
                    $('#remove_taxonomy_background_image').click(function(e) {
                        e.preventDefault();
                        $('#taxonomy_background_image').val('');
                        $('#taxonomy_background_image_preview').html('<p>تصویری انتخاب نشده است</p>');
                        $(this).hide();
                    });
                });
            </script>
            <?php
        });
    }
}
add_action('admin_enqueue_scripts', 'enqueue_taxonomy_icon_scripts');

/**
 * Add icon column to taxonomy list
 */
function add_taxonomy_icon_column($columns) {
    $new_columns = array();
    foreach ($columns as $key => $value) {
        $new_columns[$key] = $value;
        if ($key === 'name') {
            $new_columns['icon'] = 'آیکون';
            $new_columns['display_order'] = 'شماره ترتیب';
        }
    }
    return $new_columns;
}
add_filter('manage_edit-category_columns', 'add_taxonomy_icon_column');
add_filter('manage_edit-post_tag_columns', 'add_taxonomy_icon_column');
add_filter('manage_edit-services_category_columns', 'add_taxonomy_icon_column');
add_filter('manage_edit-sellino_product_category_columns', 'add_taxonomy_icon_column');

function display_taxonomy_icon_column($content, $column_name, $term_id) {
    if ($column_name === 'icon') {
        $icon_id = get_term_meta($term_id, 'taxonomy_icon', true);
        if ($icon_id) {
            echo wp_get_attachment_image($icon_id, 'thumbnail');
        }
    } elseif ($column_name === 'display_order') {
        $order = get_term_meta($term_id, 'display_order', true);
        echo esc_html($order);
    }
}
add_action('manage_category_custom_column', 'display_taxonomy_icon_column', 10, 3);
add_action('manage_post_tag_custom_column', 'display_taxonomy_icon_column', 10, 3);
add_action('manage_services_category_custom_column', 'display_taxonomy_icon_column', 10, 3);
add_action('manage_sellino_product_category_custom_column', 'display_taxonomy_icon_column', 10, 3);

/**
 * Add icon to taxonomy term links
 */
function add_taxonomy_icon_to_link($link, $term) {
    $icon_id = get_term_meta($term->term_id, 'taxonomy_icon', true);
    if ($icon_id) {
        $icon = wp_get_attachment_image($icon_id, 'thumbnail');
        $link = str_replace('</a>', $icon . '</a>', $link);
    }
    return $link;
}
add_filter('get_term_link', 'add_taxonomy_icon_to_link', 10, 2);
