<?php
if (!defined('ABSPATH')) {
    exit;
}

// Include Settings Files
require_once get_template_directory() . '/settings/theme-settings.php';
require_once get_template_directory() . '/settings/header-settings.php';
require_once get_template_directory() . '/settings/footer-settings.php';
require_once get_template_directory() . '/settings/template-settings.php';
require_once get_template_directory() . '/settings/single-post-settings.php'; 
// Enqueue settings assets
function mohtavanegar_settings_assets() {
    wp_enqueue_style('mohtavanegar-settings', get_template_directory_uri() . '/settings/css/theme-settings.css');
    wp_enqueue_script('mohtavanegar-settings', get_template_directory_uri() . '/settings/js/theme-settings.js', array('jquery'), '1.0', true);
    
    // Localize script
    wp_localize_script('mohtavanegar-settings', 'mohtavanegarSettings', array(
        'ajaxurl' => admin_url('admin-ajax.php'),
        'nonce' => wp_create_nonce('mohtavanegar_save_settings')
    ));
}
add_action('admin_enqueue_scripts', 'mohtavanegar_settings_assets');

// Theme Options Page
function mohtavanegar_add_admin_menu() {
    add_menu_page(
        'تنظیمات قالب',
        'تنظیمات قالب',
        'manage_options',
        'theme-settings',
        'mohtavanegar_theme_settings_page',
        'dashicons-admin-customizer',
        30
    );
}
add_action('admin_menu', 'mohtavanegar_add_admin_menu');

// Register Theme Settings
function mohtavanegar_register_settings() {
    // Basic Settings
    register_setting('mohtavanegar_settings', 'basic_settings', array(
        'sanitize_callback' => 'mohtavanegar_sanitize_basic_settings',
        'default' => array(
            'primary_color' => '#000000',
            'secondary_color' => '#000000',
            'body_bg_color' => '#ffffff',
            'page_layout' => 'container',
            'container_width' => '1140',
            'jalali_date' => 0  // Default to disabled
        )
    ));
    
    // Header Settings
    register_setting('mohtavanegar_settings', 'header_template', array(
        'sanitize_callback' => 'absint',
        'default' => ''
    ));
    register_setting('mohtavanegar_settings', 'header_type', array(
        'sanitize_callback' => 'sanitize_text_field',
        'default' => 'default'
    ));
    register_setting('mohtavanegar_settings', 'header_body_margin_top', array(
        'sanitize_callback' => 'absint',
        'default' => 100
    ));
    register_setting('mohtavanegar_settings', 'header_blur_initial', array(
        'sanitize_callback' => 'absint',
        'default' => 0
    ));
    register_setting('mohtavanegar_settings', 'header_blur_scrolled', array(
        'sanitize_callback' => 'absint',
        'default' => 10
    ));
    
    // Footer Settings
    register_setting('mohtavanegar_settings', 'footer_template', array(
        'sanitize_callback' => 'absint',
        'default' => ''
    ));
    register_setting('mohtavanegar_settings', 'footer_type', array(
        'sanitize_callback' => 'sanitize_text_field',
        'default' => 'default'
    ));
    
    // Post Settings
    register_setting('mohtavanegar_settings', 'single_post_template', array(
        'sanitize_callback' => 'absint',
        'default' => ''
    ));
    
    // Product Settings
    register_setting('mohtavanegar_settings', 'single_product_template', array(
        'sanitize_callback' => 'absint',
        'default' => ''
    ));
    
    // Typography Settings
    register_setting('mohtavanegar_settings', 'typography_settings', array(
        'sanitize_callback' => 'mohtavanegar_sanitize_typography_settings',
        'default' => array(
            'body_font' => '',
            'heading_font' => ''
        )
    ));

    // Service Settings
    register_setting('mohtavanegar_settings', 'service_settings', array(
        'sanitize_callback' => 'mohtavanegar_sanitize_service_settings',
        'default' => array(
            'service_button_color' => '#0073aa',
            'service_button_text_color' => '#ffffff'
        )
    ));
}
add_action('admin_init', 'mohtavanegar_register_settings');

// Sanitize Basic Settings
function mohtavanegar_sanitize_basic_settings($input) {
    if (!is_array($input)) {
        return array();
    }
    
    $sanitized = array();
    
    if (isset($input['primary_color'])) {
        $sanitized['primary_color'] = sanitize_hex_color($input['primary_color']);
    }
    
    if (isset($input['secondary_color'])) {
        $sanitized['secondary_color'] = sanitize_hex_color($input['secondary_color']);
    }
    
    if (isset($input['text_color'])) {
        $sanitized['text_color'] = sanitize_hex_color($input['text_color']);
    }
    
    if (isset($input['body_bg_color'])) {
        $sanitized['body_bg_color'] = sanitize_hex_color($input['body_bg_color']);
    }
    
    if (isset($input['accent_color'])) {
        $sanitized['accent_color'] = sanitize_hex_color($input['accent_color']);
    }
    
    if (isset($input['page_layout'])) {
        $sanitized['page_layout'] = sanitize_text_field($input['page_layout']);
    }
    
    if (isset($input['container_width'])) {
        $sanitized['container_width'] = absint($input['container_width']);
    }

    if (isset($input['site_logo'])) {
        $sanitized['site_logo'] = absint($input['site_logo']);
    }
    
    // Sanitize maintenance mode checkbox
    // Make sure to explicitly set it to 0 if not set or not equal to 1
    $sanitized['maintenance_mode'] = (isset($input['maintenance_mode']) && $input['maintenance_mode'] == '1') ? 1 : 0;
    
    // Sanitize jalali date checkbox
    $sanitized['jalali_date'] = (isset($input['jalali_date']) && $input['jalali_date'] == '1') ? 1 : 0;
    
    return $sanitized;
}

// Sanitize Typography Settings
function mohtavanegar_sanitize_typography_settings($input) {
    if (!is_array($input)) {
        return array();
    }
    
    $sanitized = array();
    
    if (isset($input['body_font'])) {
        $sanitized['body_font'] = sanitize_text_field($input['body_font']);
    }
    
    if (isset($input['heading_font'])) {
        $sanitized['heading_font'] = sanitize_text_field($input['heading_font']);
    }
    
    return $sanitized;
}

// Sanitize Service Settings
function mohtavanegar_sanitize_service_settings($input) {
    if (!is_array($input)) {
        return array();
    }
    
    $sanitized = array();
    $defaults = array(
        'service_button_color' => '#0073aa',
        'service_button_text_color' => '#ffffff',
        'category_icon_bg' => '#f5f5f5',
        'subcategory_image_width' => 300,
        'subcategory_image_height' => 200,
        'show_view_button' => 'on',
        'subcategory_columns' => 3
    );
    
    // Sanitize color fields
    if (isset($input['service_button_color'])) {
        $sanitized['service_button_color'] = sanitize_hex_color($input['service_button_color']);
    }
    if (isset($input['service_button_text_color'])) {
        $sanitized['service_button_text_color'] = sanitize_hex_color($input['service_button_text_color']);
    }
    if (isset($input['category_icon_bg'])) {
        $sanitized['category_icon_bg'] = sanitize_hex_color($input['category_icon_bg']);
    }
    
    // Sanitize numeric fields
    if (isset($input['subcategory_image_width'])) {
        $width = absint($input['subcategory_image_width']);
        $sanitized['subcategory_image_width'] = ($width >= 100 && $width <= 1200) ? $width : $defaults['subcategory_image_width'];
    }
    
    if (isset($input['subcategory_image_height'])) {
        $height = absint($input['subcategory_image_height']);
        $sanitized['subcategory_image_height'] = ($height >= 100 && $height <= 1200) ? $height : $defaults['subcategory_image_height'];
    }
    
    // Sanitize checkboxes
    $sanitized['show_view_button'] = (isset($input['show_view_button']) && $input['show_view_button'] === 'on') ? 'on' : 'off';
    $sanitized['show_description'] = (isset($input['show_description']) && $input['show_description'] === 'on') ? 'on' : 'off';
    
    // Sanitize columns
    if (isset($input['subcategory_columns'])) {
        $columns = absint($input['subcategory_columns']);
        $sanitized['subcategory_columns'] = ($columns >= 1 && $columns <= 6) ? $columns : $defaults['subcategory_columns'];
    }
    
    return wp_parse_args($sanitized, $defaults);
}

// Include settings files
require_once get_template_directory() . '/settings/elementor-helpers.php';
require_once get_template_directory() . '/settings/typography-settings.php';
require_once get_template_directory() . '/settings/basic-settings.php';
require_once get_template_directory() . '/settings/service-settings.php';
require_once get_template_directory() . '/settings/plugin-installer.php';

// Enqueue color picker
function mohtavanegar_enqueue_color_picker() {
    wp_enqueue_style('wp-color-picker');
    wp_enqueue_script('wp-color-picker');
}
add_action('admin_enqueue_scripts', 'mohtavanegar_enqueue_color_picker');

// Handle Ajax form submission
function mohtavanegar_save_theme_settings() {
    // Verify nonce
    if (!isset($_POST['security']) || !wp_verify_nonce($_POST['security'], 'mohtavanegar_save_settings')) {
        wp_send_json_error(array('message' => 'خطای امنیتی. لطفاً صفحه را رفرش کنید.'));
    }
    
    // Check user capabilities
    if (!current_user_can('manage_options')) {
        wp_send_json_error(array('message' => 'شما دسترسی لازم برای انجام این کار را ندارید.'));
    }
    
    // Save basic settings
    if (isset($_POST['basic_settings'])) {
        $basic_settings = mohtavanegar_sanitize_basic_settings($_POST['basic_settings']);
        
        // Explicitly handle maintenance mode
        if (isset($_POST['basic_settings']['maintenance_mode'])) {
            $basic_settings['maintenance_mode'] = ($_POST['basic_settings']['maintenance_mode'] == '1') ? 1 : 0;
        } else {
            $basic_settings['maintenance_mode'] = 0;
        }
        
        update_option('basic_settings', $basic_settings);

        // Save site logo
        if (isset($basic_settings['site_logo'])) {
            update_option('site_logo', $basic_settings['site_logo']);
        }

        // Update Elementor colors
        mohtavanegar_update_elementor_colors(get_option('basic_settings'), $basic_settings);
    }
    
    // Save header settings
    if (isset($_POST['header_template'])) {
        update_option('header_template', absint($_POST['header_template']));
    }
    if (isset($_POST['header_type'])) {
        update_option('header_type', sanitize_text_field($_POST['header_type']));
    }
    // Save header fixed option
    update_option('header_fixed', isset($_POST['header_fixed']) ? 1 : 0);
    if (isset($_POST['header_body_margin_top'])) {
        update_option('header_body_margin_top', absint($_POST['header_body_margin_top']));
    }
    if (isset($_POST['header_blur_initial'])) {
        update_option('header_blur_initial', absint($_POST['header_blur_initial']));
    }
    if (isset($_POST['header_blur_scrolled'])) {
        update_option('header_blur_scrolled', absint($_POST['header_blur_scrolled']));
    }
    
    // Save footer settings
    if (isset($_POST['footer_template'])) {
        update_option('footer_template', absint($_POST['footer_template']));
    }
    if (isset($_POST['footer_type'])) {
        update_option('footer_type', sanitize_text_field($_POST['footer_type']));
    }
    
    // Save post settings
    if (isset($_POST['single_post_template'])) {
        update_option('single_post_template', absint($_POST['single_post_template']));
    }
    
    // Save product settings
    if (isset($_POST['single_product_template'])) {
        update_option('single_product_template', absint($_POST['single_product_template']));
    }
    
    // Save typography settings
    if (isset($_POST['typography_settings'])) {
        $typography_settings = mohtavanegar_sanitize_typography_settings($_POST['typography_settings']);
        update_option('typography_settings', $typography_settings);
    }

    // Save service settings
    if (isset($_POST['service_settings'])) {
        $service_settings = mohtavanegar_sanitize_service_settings($_POST['service_settings']);
        update_option('service_settings', $service_settings);
    }
    
    // Send success response
    wp_send_json_success(array(
        'message' => 'تنظیمات با موفقیت ذخیره شد.',
        'elementor_updated' => isset($_POST['basic_settings'])
    ));
}
add_action('wp_ajax_mohtavanegar_save_theme_settings', 'mohtavanegar_save_theme_settings');

// Clear Elementor cache
function mohtavanegar_clear_elementor_cache() {
    // Verify nonce
    if (!isset($_POST['security']) || !wp_verify_nonce($_POST['security'], 'mohtavanegar_save_settings')) {
        wp_send_json_error(array('message' => 'خطای امنیتی. لطفاً صفحه را رفرش کنید.'));
    }
    
    // Check user capabilities
    if (!current_user_can('manage_options')) {
        wp_send_json_error(array('message' => 'شما دسترسی لازم برای انجام این کار را ندارید.'));
    }
    
    // Clear Elementor cache
    if (class_exists('\Elementor\Plugin')) {
        \Elementor\Plugin::$instance->files_manager->clear_cache();
    }
    
    wp_send_json_success(array('message' => 'کش المنتور با موفقیت پاک شد.'));
}
add_action('wp_ajax_elementor_clear_cache', 'mohtavanegar_clear_elementor_cache');

// Theme Settings Page Content
function mohtavanegar_theme_settings_page() {
    if (!current_user_can('manage_options')) {
        return;
    }
    
    // Get Elementor templates
    $all_templates = get_posts(array(
        'post_type' => 'elementor_library',
        'posts_per_page' => -1,
    ));

    // Filter templates
    $header_templates = array_filter($all_templates, function($template) {
        return get_post_meta($template->ID, '_elementor_template_type', true) === 'header';
    });

    $footer_templates = array_filter($all_templates, function($template) {
        return get_post_meta($template->ID, '_elementor_template_type', true) === 'footer';
    });

    $single_post_templates = array_filter($all_templates, function($template) {
        return get_post_meta($template->ID, '_elementor_template_type', true) === 'single-post';
    });

    $single_product_templates = array_filter($all_templates, function($template) {
        return get_post_meta($template->ID, '_elementor_template_type', true) === 'product';
    });
    
    ?>
    <div class="wrap">
        <h1><?php echo esc_html(get_admin_page_title()); ?></h1>
        
        <form id="theme-settings-form" method="post">
            <div class="theme-settings-wrap">
                <div class="theme-settings-nav">
                    <ul>
                        <li><a href="#basic-settings"><?php _e('تنظیمات پایه', 'mohtavanegar'); ?></a></li>
                        <li><a href="#header-settings"><?php _e('تنظیمات هدر', 'mohtavanegar'); ?></a></li>
                        <li><a href="#footer-settings"><?php _e('تنظیمات فوتر', 'mohtavanegar'); ?></a></li>
                        <li><a href="#post-settings"><?php _e('تنظیمات پست', 'mohtavanegar'); ?></a></li>
                        <?php if (class_exists('WooCommerce')) : ?>
                        <li><a href="#product-settings"><?php _e('تنظیمات محصول', 'mohtavanegar'); ?></a></li>
                        <?php endif; ?>
                        <li><a href="#typography-settings"><?php _e('تایپوگرافی', 'mohtavanegar'); ?></a></li>
                        <li><a href="#service-settings"><?php _e('تنظیمات خدمات', 'mohtavanegar'); ?></a></li>
                    </ul>
                </div>
                
                <div class="theme-settings-content">
                    <!-- Basic Settings -->
                    <div id="basic-settings" class="theme-settings-section">
                        <?php mohtavanegar_basic_settings_page(); ?>
                    </div>

                    <!-- Header Settings -->
                    <div id="header-settings" class="theme-settings-section">
                        <h2><?php _e('تنظیمات هدر', 'mohtavanegar'); ?></h2>
                        <table class="form-table">
                            <tr>
                                <th scope="row"><?php _e('نوع هدر', 'mohtavanegar'); ?></th>
                                <td>
                                    <select name="header_type" id="header_type">
                                        <option value="default" <?php selected(get_option('header_type'), 'default'); ?>><?php _e('پیش‌فرض', 'mohtavanegar'); ?></option>
                                        <option value="transparent" <?php selected(get_option('header_type'), 'transparent'); ?>><?php _e('شفاف', 'mohtavanegar'); ?></option>
                                        <option value="sticky" <?php selected(get_option('header_type'), 'sticky'); ?>><?php _e('چسبان', 'mohtavanegar'); ?></option>
                                        <option value="centered" <?php selected(get_option('header_type'), 'centered'); ?>><?php _e('وسط‌چین', 'mohtavanegar'); ?></option>
                                        <option value="blurry" <?php selected(get_option('header_type'), 'blurry'); ?>><?php _e('بلوری', 'mohtavanegar'); ?></option>
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <th scope="row"><?php _e('قالب هدر', 'mohtavanegar'); ?></th>
                                <td>
                                    <select name="header_template">
                                        <option value=""><?php _e('انتخاب قالب هدر', 'mohtavanegar'); ?></option>
                                        <?php foreach ($header_templates as $template) : ?>
                                            <option value="<?php echo $template->ID; ?>" <?php selected(get_option('header_template'), $template->ID); ?>>
                                                <?php echo $template->post_title; ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <th scope="row"><?php _e('حالت ثابت', 'mohtavanegar'); ?></th>
                                <td>
                                    <label for="header_fixed">
                                        <input type="checkbox" name="header_fixed" id="header_fixed" value="1" <?php checked(get_option('header_fixed'), 1); ?>>
                                        <?php _e('فعال‌سازی هدر ثابت', 'mohtavanegar'); ?>
                                    </label>
                                    <p class="description"><?php _e('در صورت فعال‌سازی، هدر در بالای صفحه ثابت می‌شود.', 'mohtavanegar'); ?></p>
                                </td>
                            </tr>
                            <tr>
                                <th scope="row"><?php _e('مقدار بلور اولیه (px)', 'mohtavanegar'); ?></th>
                                <td>
                                    <input type="number" name="header_blur_initial" id="header_blur_initial" min="0" max="50" step="1" value="<?php echo esc_attr(get_option('header_blur_initial', 0)); ?>">
                                </td>
                            </tr>
                            <tr>
                                <th scope="row"><?php _e('فاصله از بالای بدنه (px)', 'mohtavanegar'); ?></th>
                                <td>
                                    <input type="number" name="header_body_margin_top" id="header_body_margin_top" min="0" max="500" step="1" value="<?php echo esc_attr(get_option('header_body_margin_top', 100)); ?>">
                                    <p class="description"><?php _e('مقدار فاصله بالای body بر حسب پیکسل. پیش‌فرض 100px است.', 'mohtavanegar'); ?></p>
                                </td>
                            </tr>
                            <tr>
                                <th scope="row"><?php _e('مقدار بلور بعد از اسکرول (px)', 'mohtavanegar'); ?></th>
                                <td>
                                    <input type="number" name="header_blur_scrolled" id="header_blur_scrolled" min="0" max="50" step="1" value="<?php echo esc_attr(get_option('header_blur_scrolled', 10)); ?>">
                                </td>
                            </tr>
                        </table>
                    </div>
                    
                    <!-- Footer Settings -->
                    <div id="footer-settings" class="theme-settings-section">
                        <h2><?php _e('تنظیمات فوتر', 'mohtavanegar'); ?></h2>
                        <table class="form-table">
                            <tr>
                                <th scope="row"><?php _e('نوع فوتر', 'mohtavanegar'); ?></th>
                                <td>
                                    <select name="footer_type" id="footer_type">
                                        <option value="default" <?php selected(get_option('footer_type'), 'default'); ?>><?php _e('پیش‌فرض', 'mohtavanegar'); ?></option>
                                        <option value="minimal" <?php selected(get_option('footer_type'), 'minimal'); ?>><?php _e('مینیمال', 'mohtavanegar'); ?></option>
                                        <option value="extended" <?php selected(get_option('footer_type'), 'extended'); ?>><?php _e('گسترده', 'mohtavanegar'); ?></option>
                                        <option value="centered" <?php selected(get_option('footer_type'), 'centered'); ?>><?php _e('وسط‌چین', 'mohtavanegar'); ?></option>
                                    </select>
                                </td>
                            </tr>
                            <tr>
                                <th scope="row"><?php _e('قالب فوتر', 'mohtavanegar'); ?></th>
                                <td>
                                    <select name="footer_template">
                                        <option value=""><?php _e('انتخاب قالب فوتر', 'mohtavanegar'); ?></option>
                                        <?php foreach ($footer_templates as $template) : ?>
                                            <option value="<?php echo $template->ID; ?>" <?php selected(get_option('footer_template'), $template->ID); ?>>
                                                <?php echo $template->post_title; ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </td>
                            </tr>
                        </table>
                    </div>
                    
                    <!-- Post Settings -->
                    <div id="post-settings" class="theme-settings-section">
                        <h2><?php _e('تنظیمات پست', 'mohtavanegar'); ?></h2>
                        <div class="template-selection">
                            <label for="single_post_template"><?php _e('قالب صفحه تک پست', 'mohtavanegar'); ?></label>
                            <select name="single_post_template" id="single_post_template">
                                <option value=""><?php _e('انتخاب قالب صفحه تک پست', 'mohtavanegar'); ?></option>
                                <?php foreach ($single_post_templates as $template) : ?>
                                    <option value="<?php echo $template->ID; ?>" <?php selected(get_option('single_post_template'), $template->ID); ?>>
                                        <?php echo $template->post_title; ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    
                    <?php if (class_exists('WooCommerce')) : ?>
                    <!-- Product Settings -->
                    <div id="product-settings" class="theme-settings-section">
                        <h2><?php _e('تنظیمات محصول', 'mohtavanegar'); ?></h2>
                        <div class="template-selection">
                            <label for="single_product_template"><?php _e('قالب صفحه تک محصول', 'mohtavanegar'); ?></label>
                            <select name="single_product_template" id="single_product_template">
                                <option value=""><?php _e('انتخاب قالب صفحه تک محصول', 'mohtavanegar'); ?></option>
                                <?php foreach ($single_product_templates as $template) : ?>
                                    <option value="<?php echo $template->ID; ?>" <?php selected(get_option('single_product_template'), $template->ID); ?>>
                                        <?php echo $template->post_title; ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    <?php endif; ?>
                    
                    <!-- Typography Settings -->
                    <div id="typography-settings" class="theme-settings-section">
                        <?php mohtavanegar_typography_settings_page(); ?>
                    </div>
                    <!-- Service Settings -->
                    <div id="service-settings" class="theme-settings-section">
                        <?php mohtavanegar_service_settings_page(); ?>
                    </div>
                </div>
            </div>
            
            <?php submit_button(); ?>
        </form>
    </div>
    <?php
} 